/**
 * @(#)ActivityItemDto.java 1.0 2020/8/27
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request;

import java.util.Objects;

/**
 * 活动商品dto
 *
 * @author wu.sheng
 * @date 2020/8/27 15:50
 */
public class ActivityItemDto {

    /**
     * 店铺id
     */
    private Long shopId;

    /**
     * 商品id
     */
    private Long itemId;
    /**
     * 活动id
     */
    private Long activityId;

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public ActivityItemDto() {
    }

    public ActivityItemDto(Long shopId, Long itemId) {
        this.shopId = shopId;
        this.itemId = itemId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ActivityItemDto)) return false;
        ActivityItemDto that = (ActivityItemDto) o;
        return getShopId().equals(that.getShopId()) &&
                getItemId().equals(that.getItemId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getShopId(), getItemId());
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }
}
