/**
 * @(#)ActivityGroupDetailRespDto.java 1.0 2020/4/13
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 拼团队伍详情响应dto
 *
 * @author wu.sheng
 * @date 2020/4/13 15:59
 */
@ApiModel(value = "ActivityGroupDetailRespDto", description = "拼团队伍详情响应dto")
public class ActivityGroupDetailRespDto {

    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    /**
     * 所属团ID
     */
    @ApiModelProperty(name = "groupId", value = "团id")
    private String groupId;
    /**
     * 拼团活动ID
     */
    @ApiModelProperty(name = "activityId", value = "拼团活动ID")
    private String activityId;
    /**
     * 参与人名称
     */
    @ApiModelProperty(name = "playerPersonName", value = "参与人名称")
    private String playerPersonName;
    /**
     * 参与人
     */
    @ApiModelProperty(name = "playerPersonId", value = "参与人")
    private Long playerPersonId;
    /**
     * 订单号
     */
    @ApiModelProperty(name = "orderNo", value = "订单号")
    private String orderNo;
    /**
     * 实付金额
     */
    @ApiModelProperty(name = "payAmount", value = "实付金额")
    private BigDecimal payAmount;
    /**
     * 状态：1有效0无效
     */
    @ApiModelProperty(name = "status", value = "状态：1有效0无效")
    private Integer status;

    /**
     * 头像
     */
    @ApiModelProperty(name = "avatar", value = "参与人头像")
    private String avatar;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getActivityId() {
        return activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getPlayerPersonName() {
        return playerPersonName;
    }

    public void setPlayerPersonName(String playerPersonName) {
        this.playerPersonName = playerPersonName;
    }

    public Long getPlayerPersonId() {
        return playerPersonId;
    }

    public void setPlayerPersonId(Long playerPersonId) {
        this.playerPersonId = playerPersonId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public BigDecimal getPayAmount() {
        return payAmount;
    }

    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

}
