/**
 * @(#)ActivityGroupRespDto.java 1.0 2020/4/13
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.response;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 拼团队伍响应dto
 *
 * @author wu.sheng
 * @date 2020/4/13 15:59
 */
@ApiModel(value = "ActivityGroupRespDto", description = "拼团队伍响应dto")
public class ActivityGroupRespDto extends RequestDto {


    @ApiModelProperty(name = "id", value = "id")
    private Long id;

    /**
     * 拼团活动ID
     */
    @ApiModelProperty(name = "activityId", value = "拼团活动ID")
    private Long activityId;

    /**
     * 团名称
     */
    @ApiModelProperty(name = "name", value = "团名称")
    private String name;

    /**
     * 开团人
     */
    @ApiModelProperty(name = "openGroupPerson", value = "开团人id")
    private Long openGroupPerson;

    /**
     * 拼团成功标识 0 - 进行中 ,1 -成功 .2-失败
     */
    @ApiModelProperty(name = "groupStatus", value = "团状态： 0 - 进行中 ,1 -成功 .2-失败")
    private Integer groupStatus;

    /**
     * 开团时间
     */
    @ApiModelProperty(name = "openTime", value = "开团时间")
    private Date openTime;

    /**
     * 团结束时间
     */
    @ApiModelProperty(name = "closeTime", value = "团结束时间")
    private Date closeTime;

    /**
     * 拼团成功时间
     */
    @ApiModelProperty(name = "successTime", value = "拼团成功时间")
    private Date successTime;

    /**
     * 成团情况，即还差多少人满足成团条件
     */
    @ApiModelProperty(name = "successTime", value = "成团情况，即还差多少人满足成团条件")
    private Integer groupLackNum;

    /**
     * 头像
     */
    @ApiModelProperty(name = "avatar", value = "开团人头像")
    private String avatar;

    @ApiModelProperty(name = "playerPersonName", value = "开团人名称")
    private String personName;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getOpenGroupPerson() {
        return openGroupPerson;
    }

    public void setOpenGroupPerson(Long openGroupPerson) {
        this.openGroupPerson = openGroupPerson;
    }

    public Integer getGroupStatus() {
        return groupStatus;
    }

    public void setGroupStatus(Integer groupStatus) {
        this.groupStatus = groupStatus;
    }

    public Date getOpenTime() {
        return openTime;
    }

    public void setOpenTime(Date openTime) {
        this.openTime = openTime;
    }

    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public Date getSuccessTime() {
        return successTime;
    }

    public void setSuccessTime(Date successTime) {
        this.successTime = successTime;
    }

    public Integer getGroupLackNum() {
        return groupLackNum;
    }

    public void setGroupLackNum(Integer groupLackNum) {
        this.groupLackNum = groupLackNum;
    }

    public String getAvatar() {
        return avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getPersonName() {
        return personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }
}