/**
 * @(#)IActivityGroupQeuryApi.java 1.0 2020/4/13
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityGroupDetailReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityGroupReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.response.ActivityGroupDetailRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.response.ActivityGroupRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;

/**
 * 拼团信息
 *
 * @author wu.sheng
 * @date 2020/4/13 16:37
 */
@Api(tags = "拼团信息接口")
@FeignClient(contextId = "com-dtyunxi-yundt-cube-biz-marketing-api-crowdordering-service-query-IActivityGroupQeuryApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v1/crowdordering",
        url = "${yundt.cube.center.promotion.api:}")
public interface IActivityGroupQueryApi {

    /**
     * 根据团id查看拼团信息
     *
     * @param id
     * @return
     */
    @GetMapping("/group/{id}")
    @ApiOperation(value = "根据团id查看拼团信息")
    RestResponse<ActivityGroupRespDto> getById(@PathVariable("id") Long id);

    /**
     * 分页查询拼团列表
     *
     * @param activityGroupReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/group/list")
    @ApiOperation(value = "分页查询拼团列表")
    RestResponse<PageInfo<ActivityGroupRespDto>> queryByPage(@SpringQueryMap ActivityGroupReqDto activityGroupReqDto,
                                                             @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                             @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize);


    /**
     * 根据活动维度或团维度统计订单实付金额
     *
     * @param activityId
     * @param groupId
     * @return
     */
    @GetMapping("/group/statistic/orderAmount")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityId", value = "活动id", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "groupId", value = "团id", dataType = "Long", paramType = "query")
    })
    @ApiOperation(value = "根据活动维度或团维度统计订单实付金额", notes = "传activityId按活动维度，同时传入按团维度统计")
    RestResponse<BigDecimal> countOrderAmount(@RequestParam(value = "activityId") Long activityId,
                                              @RequestParam(value = "groupId",required = false) Long groupId);


    /**
     * 根据活动维度或团维度统计订单实付金额
     *
     * @param activityId
     * @param groupId
     * @return
     */
    @GetMapping("/group/statistic/groupNumber")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityId", value = "活动id", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "groupId", value = "团id", dataType = "Long", paramType = "query")
    })
    @ApiOperation(value = "根据活动维度或团维度统计成团人数", notes = "传activityId按活动维度，同时传入按团维度统计")
    RestResponse<Long> countGroupNumber(@RequestParam(value = "activityId") Long activityId,
                                              @RequestParam(value = "groupId",required = false) Long groupId);

    /**
     * 分页查询拼团详情
     *
     * @param activityGroupDetailReqDto
     * @param pageNum
     * @param pageSize
     * @return
     */
    @GetMapping("/group-detail/list")
    @ApiOperation(value = "分页查询拼团详情")
    RestResponse<PageInfo<ActivityGroupDetailRespDto>> queryGroupDetailByPage(@SpringQueryMap ActivityGroupDetailReqDto activityGroupDetailReqDto,
                                                                              @RequestParam(value = "pageNum",
                                                                                      defaultValue = "1") Integer pageNum,
                                                                              @RequestParam(value = "pageSize",
                                                                                      defaultValue = "10") Integer pageSize);
}
