package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 发券渠道
 *
 * @author 浮云
 */
public enum CouponChannelEnum {

    ACTIVE("10000", "主动营销"),
    EVENT("10001", "事件营销"),
    DAVIN_EVENT("10005", "画布事件营销"),
    PUSH("10002", "基础促销"),
    WX_APPLET("10003", "小程序发券"),

    /**
     * 储值赠礼
     */
    RECHARGE_GIFT("10004", "储值赠礼"),

    /**
     * app发券
     */
    APP("app", "APP、外卖发券"),

    /**
     * 问券网发券
     */
    WENJUAN("wenjuan", "问券网发券"),

    /**
     * 手淘发券
     */
    TAOBAO("taobao", "手淘发券"),

    /**
     * 拼团发券
     */
    PIN_TUAN("pintuan", "拼团发券"),



    OTHER("other", "其他"),

    ;

    CouponChannelEnum(String channel, String describe) {
        this.channel = channel;
        this.describe = describe;
    }

    private String channel;

    private String describe;

    public String getChannel() {
        return channel;
    }

    public String getDescribe() {
        return describe;
    }

    public static CouponChannelEnum findEnum(String channel){
        if(StringUtils.isBlank(channel)){
            return OTHER;
        }
        for (CouponChannelEnum couponChannelEnum: values()){
            if(couponChannelEnum.getChannel().equals(channel)){
                return couponChannelEnum;
            }
        }
        return OTHER;
    }
}
