package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums;

import com.dtyunxi.cube.biz.commons.enums.IEnum;

/**
 * 优惠券推送方式【0：定向推券 1：领券中心-通用 2：领券中心-精准】
 *
 * @author 浮云
 */
public enum CouponPushMethodEnum implements IEnum {

    /**
     *
     */
    RECEIVE(0, "定向推券"),
    SPELL(1, "领券中心-通用"),
    PUSH(2, "领券中心-精准");

    private int key;

    private String value;

    CouponPushMethodEnum(int key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getKey() {
        return key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    @Override
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    /**
     * 跳过库存校验的推送类型
     * @author : 萧玄
     * @Date   : 13:43 2019/9/11
     * @param pushMethod
     * @return : boolean
     */
    public static boolean skipStockValidCheck(Integer pushMethod){
        //产品需求更改
        //主动营销，优惠券有三种模式
        //1.定向推券，需要保留原来的券库存校验。
        //2.领取中心-通用，需要去掉券库存校验，会员在小程序领取，先到先得。
        //3.领取中心-精准，需要去掉券库存校验，会员在小程序领取，先到先得。
        if(CouponPushMethodEnum.PUSH.isEqual(pushMethod) || CouponPushMethodEnum.SPELL.isEqual(pushMethod)){
            return true;
        }
        return false;
    }

}
