package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 优惠券状态枚举类
 *
 * @author 浮云
 */
public enum CouponStatusEnum {

    //券状态，10-已创建，20-已核销，30-已作废，40-未领取，50-冻结 （与原中台状态机统一）

    CREATE("10", "已创建"),
    STOP("20", "已核销"),
    INVALID("30", "已作废"),
    NEW("40", "未领取（临时）"),
    FREEZE("50", "冻结");

    private String status;

    private String description;

    CouponStatusEnum(String status, String description) {
        this.status = status;
        this.description = description;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * 根据状态查询枚举
     *
     * @param status
     * @return
     */
    public static CouponStatusEnum getByStatus(String status) {
        if(StringUtils.isEmpty(status)){
            return null;
        }
        for (CouponStatusEnum couponStatusEnum : values()) {
            if (couponStatusEnum.getStatus().equals(status)) {
                return couponStatusEnum;
            }
        }
        return null;
    }
}
