package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 优惠券类型枚举类, 01=团购券, 02=APP提货券, 03=福利券, 04=客情券, 05=优惠券
 * @author: li.jundong
 * @date: 2019/6/26 14:48
 */
public enum CouponTypeEnum {

    GROUP_PURCHASE("01", "团购券"),

    APP_EXTRACT("02", "APP提货券"),

    WELFARE("03", "福利券"),

    GUEST("04", "客情券"),

    COUPON("05", "优惠券"),

    FREIGHT("06", "运费券"),

    COLLAGE("07", "拼团券"),
    PERSONALIZE("11", "个性化优惠券"),

    COUPON_PUSHED("10", "优惠券（手动发放）")
    ;

    private String type;

    private String describe;

    CouponTypeEnum(String type, String describe) {
        this.type = type;
        this.describe = describe;
    }

    public String getType() {
        return type;
    }

    public String getDescribe() {
        return describe;
    }

    /**
     * 根据枚举值查找枚举类
     * @author: li.jundong
     * @date: 2019/6/26 14:44
     * @param: * @param status
     * @return:com.dtyunxi.yundt.cube.biz.marketing.enums.CouponTypeEnum
     */
    public static CouponTypeEnum findEnum(String type){
        if(StringUtils.isBlank(type)){
            return null;
        }
        for(CouponTypeEnum typeEnum: values()){
            if(typeEnum.getType().equals(type)){
                return typeEnum;
            }
        }
        return null;
    }
}
