package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums;

/**
 * 优惠券有效期类型,1固定日期，2动态日期
 *
 * @author: li.jundong
 * @date: 2019/6/26 14:48
 */
public enum CouponValidityTypeEnum {

    FOREVER_DATE(-1,"永久日期"),

    FIXED_DATE(1, "固定日期"),

    DYNAMIC_DATE(2, "动态日期");

    private Integer type;

    private String describe;

    CouponValidityTypeEnum(Integer type, String describe) {
        this.type = type;
        this.describe = describe;
    }

    public Integer getType() {
        return type;
    }

    public String getDescribe() {
        return describe;
    }

    /**
     * 根据枚举值查找枚举类
     *
     * @author: li.jundong
     * @date: 2019/6/26 14:44
     * @param: * @param status
     * @return:com.dtyunxi.yundt.cube.biz.marketing.enums.CouponValidityTypeEnum
     */
    public static CouponValidityTypeEnum findEnum(Integer type) {
        if (null == type) {
            return null;
        }
        for (CouponValidityTypeEnum typeEnum : values()) {
            if (typeEnum.getType().equals(type)) {
                return typeEnum;
            }
        }
        return null;
    }
}
