package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums;

import com.dtyunxi.cube.biz.commons.enums.IEnum;

/**
 * 营销时间触发类型（0：触发时 1：触发前X天 2：触发后X天）
 * @author : 萧玄
 * @Date   : 16:45 2019/5/24
 */
public enum TriggerTimeTypeEnum implements IEnum {

    /**
     *
     */
    NOW(0, "触发时"),
    BEFORE(1, "触发前X天"),
    AFTER(2, "触发后X天"),
    ;

    private int key;

    private String value;

    TriggerTimeTypeEnum(int key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getKey() {
        return key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    @Override
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}
