package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeAccountUseReq;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceAccountReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceRollBackReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.InitExchangeAccountReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 换购额度账户表服务接口
 *
 * @author cijian
 * @since 2022-01-06
 */
@Api(tags = {"换购额度账户表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-icom-bundle-base-center-promotion-api-IExchangeBalanceAccountApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v1/exchange/account",
        url = "${yundt.cube.center.promotion.api:}"
)
public interface IExchangeBalanceAccountApi {

    /**
     * 新增换购额度账户表
     *
     * @param addReqDto 换购额度账户表请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增换购额度账户表", notes = "新增换购额度账户表")
    RestResponse<Long> addExchangeBalanceAccount(@RequestBody ExchangeBalanceAccountReqDto addReqDto);

    /**
     * 修改换购额度账户表
     *
     * @param modifyReqDto 换购额度账户表请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改换购额度账户表", notes = "修改换购额度账户表")
    RestResponse<Void> modifyExchangeBalanceAccount(@RequestBody ExchangeBalanceAccountReqDto modifyReqDto);

    /**
     * 初始化换购额度账户
     *
     * @param initExchangeAccountReqDto 初始化换购额度账户请求dto
     * @return 返回账户id
     */
    @PostMapping("/initExchangeAccount")
    @ApiOperation(value = "初始化换购额度账户,返回账户id", notes = "初始化换购额度账户,返回账户id")
    RestResponse<Long> initExchangeAccount(@RequestBody InitExchangeAccountReqDto initExchangeAccountReqDto);

    /**
     * 使用换购额度账户
     *
     * @param exchangeAccountUseReq 使用换购额度账户请求dto
     * @return 处理结果
     */
    @PutMapping("/useExchangeBalanceAccount")
    @ApiOperation(value = "使用换购额度账户", notes = "使用换购额度账户")
    RestResponse<Void> useExchangeBalanceAccount(@RequestBody ExchangeAccountUseReq exchangeAccountUseReq);

    /**
     * 回滚换购使用额度
     *
     * @param exchangeBalanceRollBackReqDto 回滚换购额度请求dto
     * @return 处理结果
     */
    @PutMapping("/rollback")
    @ApiOperation(value = "回滚换购使用额度", notes = "回滚换购使用额度")
    RestResponse<Void> rollbackExchangeAccount(@RequestBody ExchangeBalanceRollBackReqDto exchangeBalanceRollBackReqDto);

}
