package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceTurnoverReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 换购额度账户变更日志表服务接口
 *
 * @author cijian
 * @since 2022-01-07
 */
@Api(tags = {"换购额度账户变更日志表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-icom-bundle-base-center-promotion-api-IExchangeBalanceTurnoverApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v1/exchange/turnover",
        url = "${yundt.cube.center.promotion.api:}"
)
public interface IExchangeBalanceTurnoverApi {

    /**
     * 新增换购额度账户变更日志表
     *
     * @param addReqDto 换购额度账户变更日志表请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增换购额度账户变更日志表", notes = "新增换购额度账户变更日志表")
    RestResponse<Long> addExchangeBalanceTurnover(@RequestBody ExchangeBalanceTurnoverReqDto addReqDto);

    /**
     * 修改换购额度账户变更日志表
     *
     * @param modifyReqDto 换购额度账户变更日志表请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改换购额度账户变更日志表", notes = "修改换购额度账户变更日志表")
    RestResponse<Void> modifyExchangeBalanceTurnover(@RequestBody ExchangeBalanceTurnoverReqDto modifyReqDto);

}
