package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.TurnoverChangeTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 使用换购额度账户请求dto
 *
 * @author cijian
 * @since 2022-01-07
 */
@Data
@ApiModel(value = "ExchangeAccountUseReq", description = "使用换购额度账户请求dto")
public class ExchangeAccountUseReq extends BaseVo {
    /**
     * 订单编号
     */
    @NotNull(message = "订单编号不能为空")
    @ApiModelProperty(name = "orderNo", value = "订单编号")
    private String orderNo;
    /**
     * 换购活动id
     */
    @NotNull(message = "换购活动id不能为空")
    @ApiModelProperty(name = "activityId", value = "换购活动id")
    private Long activityId;
    /**
     * 客户id
     */
    @NotNull(message = "客户id不能为空")
    @ApiModelProperty(name = "customerId", value = "客户id")
    private Long customerId;

    /**
     * 使用金额或者累计金额
     */
    @NotNull(message = "累计金额不能为空")
    @ApiModelProperty(name = "changeAvaBalance", value = "累计金额")
    private BigDecimal changeAvaBalance;

    /**
     * 使用金额或者累计金额
     */
    @NotNull(message = "使用金额")
    @ApiModelProperty(name = "changeUsedBalance", value = "使用金额")
    private BigDecimal changeUsedBalance;

    @ApiModelProperty(name = "changeBalance", value = "使用金额或者累计金额")
    private TurnoverChangeTypeEnum turnoverChangeTypeEnum;

}
