package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
* 换购额度账户表Eo对象
*
* @author cijian
* @since 2022-01-06
*/
@Data
@ApiModel(value = "ExchangeBalanceAccountReqDto", description = "换购额度账户表Eo对象")
public class ExchangeBalanceAccountReqDto extends RequestDto{
    /**
    *  主键ID
    */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;
    /**
    *  换购活动ID
    */
    @ApiModelProperty(name = "activityId", value = "换购活动ID")
    private Long activityId;
    /**
    *  客户ID
    */
    @ApiModelProperty(name = "customerId", value = "客户ID")
    private Long customerId;
    /**
    *  客户编号
    */
    @ApiModelProperty(name = "customerCode", value = "客户编号")
    private String customerCode;
    /**
    *  客户名称
    */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;
    /**
    *  可用额度
    */
    @ApiModelProperty(name = "availableBalance", value = "可用额度")
    private BigDecimal availableBalance;
    /**
    *  已用额度
    */
    @ApiModelProperty(name = "usedBalance", value = "已用额度")
    private BigDecimal usedBalance;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 当前页
     */
    @ApiModelProperty(name = "pageNum", value = "当前页")
    Integer pageNum = 1;

    /**
     * 每页数量
     */
    @ApiModelProperty(name = "pageSize", value = "每页数量")
    Integer pageSize;
}
