package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request;

import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.TurnoverChangeTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 回滚换购额度请求dto
 *
 * @author cijian
 * @since 2022-01-10
 */
@Data
@ApiModel(value = "ExchangeBalanceRollBackReqDto", description = "回滚换购额度请求dto")
public class ExchangeBalanceRollBackReqDto extends BaseVo {

    /**
     * 订单编号
     */
    @NotNull(message = "订单编号不能为空")
    @ApiModelProperty(name = "orderNo", value = "订单编号")
    private String orderNo;

    /**
     * 变更类型
     */
    @NotNull(message = "变更类型不能为空")
    @ApiModelProperty(name = "turnoverChangeTypeEnum", value = "变更类型")
    private TurnoverChangeTypeEnum turnoverChangeTypeEnum;
}
