package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceAccountReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.response.ExchangeBalanceAccountRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;

/**
* 换购额度账户表服务接口
*
* @author cijian
* @since 2022-01-06
*/
@Api(tags = {"换购额度账户表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-icom-bundle-base-center-promotion-api-query-IExchangeBalanceAccountQueryApi",
    name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
    path = "/v1/exchange/account",
    url = "${yundt.cube.center.promotion.api:}"
)
public interface IExchangeBalanceAccountQueryApi {

    /**
    * 根据id查询换购额度账户表
    *
    * @param id 换购额度账户表id
    * @return   换购额度账户表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询换购额度账户表", notes = "根据id查询换购额度账户表")
    RestResponse<ExchangeBalanceAccountRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 换购额度账户表分页数据
    *
    * @return 换购额度账户表分页数据
    */
    @PostMapping("/page")
    @ApiOperation(value = "换购额度账户表分页数据", notes = "根据查询条件查询换购额度账户表数据")
    RestResponse<PageInfo<ExchangeBalanceAccountRespDto>> queryByPage(ExchangeBalanceAccountReqDto exchangeBalanceAccountReqDto);

}
