package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.response.ExchangeBalanceTurnoverRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 换购额度账户变更日志表服务接口
 *
 * @author cijian
 * @since 2022-01-07
 */
@Api(tags = {"换购额度账户变更日志表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-icom-bundle-base-center-promotion-api-query-IExchangeBalanceTurnoverQueryApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v1/exchange/turnover",
        url = "${yundt.cube.center.promotion.api:}"
)
public interface IExchangeBalanceTurnoverQueryApi {

    /**
     * 根据id查询换购额度账户变更日志表
     *
     * @param id 换购额度账户变更日志表id
     * @return 换购额度账户变更日志表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询换购额度账户变更日志表", notes = "根据id查询换购额度账户变更日志表")
    RestResponse<ExchangeBalanceTurnoverRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 换购额度账户变更日志表分页数据
     *
     * @param filter   换购额度账户变更日志表查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 换购额度账户变更日志表分页数据
     */
    @GetMapping("/page")
    @ApiOperation(value = "换购额度账户变更日志表分页数据", notes = "根据filter查询条件查询换购额度账户变更日志表数据，filter=ExchangeBalanceTurnoverReqDto")
    RestResponse<PageInfo<ExchangeBalanceTurnoverRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                                       @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                       @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
