/**
 * @(#)ExchangeItemDto.java 1.0 2021/7/28
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "ExcItemDto", description = "换购商品dto")
public class ExcItemDto {

    @ApiModelProperty(name = "skuId", value = "规格id")
    private Long skuId;

    /**
     * 商品id
     */
    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;


    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String itemName;

    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;

    @ApiModelProperty(name = "totalStock", value = "可用库存")
    private Long totalStock;

    @ApiModelProperty(name = "exchangePrice", value = "换购价")
    private BigDecimal exchangePrice;

    /**
     * 赠送商品店铺id
     */
    @ApiModelProperty(name = "shopId", value = "赠送商品店铺id")
    private Long shopId;

    @ApiModelProperty(name = "excSkuDtos", value = "换购商品sku列表")
    private List<ExcSkuDto> excSkuDtos;

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public List<ExcSkuDto> getExcSkuDtos() {
        return excSkuDtos;
    }

    public void setExcSkuDtos(List<ExcSkuDto> excSkuDtos) {
        this.excSkuDtos = excSkuDtos;
    }

    public Long getTotalStock() {
        return totalStock;
    }

    public void setTotalStock(Long totalStock) {
        this.totalStock = totalStock;
    }

    public String getShopName() {
        return shopName;
    }

    public void setShopName(String shopName) {
        this.shopName = shopName;
    }

    public BigDecimal getExchangePrice() {
        return exchangePrice;
    }

    public void setExchangePrice(BigDecimal exchangePrice) {
        this.exchangePrice = exchangePrice;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }
}
