/**
 * @(#)ExchangeRuleContent.java 1.0 2021/7/28
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "ExcRuleContent", description = "换购条件内容")
public class ExcRuleContentDto {

    /**
     * 换购方式 0任意消费(免费换购)，1指定消费门槛(加价换购)
     */
    @ApiModelProperty(name = "thresholdType", value = "换购方式 0任意消费(免费换购)，1指定消费门槛(加价换购)")
    private Integer thresholdType;

    /**
     * 促销条件数量
     */
    @ApiModelProperty(name = "threshold", value = "促销条件数量")
    private BigDecimal threshold;

    /**
     * 单位: 1 元，2 件
     */
    @ApiModelProperty(name = "unit", value = "单位: 1 元，2 件")
    private Integer unit;

    /**
     * 额度类型: 1 元，2 件
     */
    @ApiModelProperty(name = "discountUnit", value = "额度类型: 1 元，2 件")
    private Integer discountUnit;

    /**
     * 额度比例: 1 固定值，2 商品金额比例
     */
    @ApiModelProperty(name = "discountScale", value = "额度比例: 1 固定值，2 商品金额比例")
    private Integer discountScale;

    /**
     * 额度值
     */
    @ApiModelProperty(name = "discount", value = "额度值")
    private BigDecimal discount;

    /**
     * 是否订单满额度
     */
    @ApiModelProperty(name = "isOrderScale", value = "是否订单满额度: 1 是 2 否")
    private Integer isOrderScale;

    /**
     * 订单额度
     */
    @ApiModelProperty(name = "orderScale", value = "订单额度")
    private BigDecimal orderScale;

    @ApiModelProperty(name = "exchangeItems", value = "换购商品列表")
    private List<ExcItemDto> exchangeItems;

    public BigDecimal getThreshold() {
        return threshold;
    }

    public void setThreshold(BigDecimal threshold) {
        this.threshold = threshold;
    }

    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public Integer getDiscountUnit() {
        return discountUnit;
    }

    public void setDiscountUnit(Integer discountUnit) {
        this.discountUnit = discountUnit;
    }

    public Integer getDiscountScale() {
        return discountScale;
    }

    public void setDiscountScale(Integer discountScale) {
        this.discountScale = discountScale;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public List<ExcItemDto> getExchangeItems() {
        return exchangeItems;
    }

    public void setExchangeItems(List<ExcItemDto> exchangeItems) {
        this.exchangeItems = exchangeItems;
    }

    public Integer getThresholdType() {
        return thresholdType;
    }

    public void setThresholdType(Integer thresholdType) {
        this.thresholdType = thresholdType;
    }

    public Integer getIsOrderScale() {
        return isOrderScale;
    }

    public void setIsOrderScale(Integer isOrderScale) {
        this.isOrderScale = isOrderScale;
    }

    public BigDecimal getOrderScale() {
        return orderScale;
    }

    public void setOrderScale(BigDecimal orderScale) {
        this.orderScale = orderScale;
    }
}
