/**
 * @(#)ExchangeSkuDto.java 1.0 2021/7/28
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

@ApiModel(value = "ExchangeSkuDto", description = "换购商品SKU dto")
public class ExcSkuDto {

    @ApiModelProperty(name = "skuId", value = "skuId")
    private Long skuId;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "itemName", value = "商品名称")
    private String skuName;

    @ApiModelProperty(name = "sellPrice", value = "售价")
    private BigDecimal sellPrice;

    @ApiModelProperty(name = "activityStock", value = "活动库存")
    private Long activityStock;

    @ApiModelProperty(name = "stock", value = "可用库存")
    private Long stock;

    @ApiModelProperty(name = "exchangeNum", value = "单次换购数量")
    private Long exchangeNum;

    @ApiModelProperty(name = "levelPriceDtos", value = "会员等级换购价格列表")
    private List<ExcLevelPriceDto> levelPriceDtos;

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public String getSkuName() {
        return skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public BigDecimal getSellPrice() {
        return sellPrice;
    }

    public void setSellPrice(BigDecimal sellPrice) {
        this.sellPrice = sellPrice;
    }

    public Long getActivityStock() {
        return activityStock;
    }

    public void setActivityStock(Long activityStock) {
        this.activityStock = activityStock;
    }

    public List<ExcLevelPriceDto> getLevelPriceDtos() {
        return levelPriceDtos;
    }

    public void setLevelPriceDtos(List<ExcLevelPriceDto> levelPriceDtos) {
        this.levelPriceDtos = levelPriceDtos;
    }

    public Long getStock() {
        return stock;
    }

    public void setStock(Long stock) {
        this.stock = stock;
    }

    public Long getExchangeNum() {
        return exchangeNum;
    }

    public void setExchangeNum(Long exchangeNum) {
        this.exchangeNum = exchangeNum;
    }
}
