/**
 * @(#)ExchangeRule.java 1.0 2021/7/29
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model;

import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 换购规则
 *
 * @author wu.sheng
 * @date 2021/7/29 10:40
 */
public class ExchangeRule {

    @ApiModelProperty(name = "换购门槛", value = "0任意消费(免费换购)，1指定消费门槛(加价换购)")
    private Integer thresholdType;

    @ApiModelProperty(name = "itemLimit", value = "商品换购数量限制：1可换购一件，2可换购多件")
    private Integer itemLimit;
    /**
     * 促销方式：1 整单，2 单品
     */
    private Integer promotionMethod;

    /**
     * 促销类别：1 满减，2 满折 3 换购
     */
    private Integer promotionType;

    /**
     * 促销条件： 1 阶梯，2 每满，3 满
     */
    private Integer promotionCondition;

    /**
     * 促销内容
     */
    private List<ExcRuleContentDto> excRuleContents;

    public Integer getThresholdType() {
        return thresholdType;
    }

    public void setThresholdType(Integer thresholdType) {
        this.thresholdType = thresholdType;
    }

    public Integer getItemLimit() {
        return itemLimit;
    }

    public void setItemLimit(Integer itemLimit) {
        this.itemLimit = itemLimit;
    }

    public Integer getPromotionMethod() {
        return promotionMethod;
    }

    public void setPromotionMethod(Integer promotionMethod) {
        this.promotionMethod = promotionMethod;
    }

    public Integer getPromotionCondition() {
        return promotionCondition;
    }

    public void setPromotionCondition(Integer promotionCondition) {
        this.promotionCondition = promotionCondition;
    }

    public List<ExcRuleContentDto> getExcRuleContents() {
        return excRuleContents;
    }

    public void setExcRuleContents(List<ExcRuleContentDto> excRuleContents) {
        this.excRuleContents = excRuleContents;
    }

    public Integer getPromotionType() {
        return promotionType;
    }

    public void setPromotionType(Integer promotionType) {
        this.promotionType = promotionType;
    }
}
