/**
 * @(#)FullDecContent.java 1.0 2020/5/7
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 促销内容条件明细
 *
 * @author 伯约
 * @since 1.0.0
 */
public class ReturnGiftContent {

    /**
     * 促销条件数量
     */
    private BigDecimal threshold;

    /**
     * 单位: 1 元，2 件
     */
    private Integer unit;

    /**
     * 优惠额度
     */
    private BigDecimal discount;

    /**
     * 赠送优惠券
     */
    private Map<Long, Integer> coupons;
    /**
     * 赠送商品
     */
    private List<GiftItem> giftItems;
    /**
     * 返积分数量
     */
    private BigDecimal points;


    /**
     * 是否包邮
     */
    private Boolean isPostage = false;

    /**
     * 是否本品
     */
    private Boolean isSelfItem = false;

    /**
     * 赠送数量
     */
    private Long giftNum;

    /**
     * 活动总赠送数量
     */
    private Long totalGiftNum;

    /**
     * 是否赠品
     */
    private Boolean isGiftItem = false;

    /**
     * 促销逻辑: 1 与，2 或
     */
    private Integer logic = 2;

    public Integer getLogic() {
        return logic;
    }

    public void setLogic(Integer logic) {
        this.logic = logic;
    }

    public Long getTotalGiftNum() {
        return totalGiftNum;
    }

    public void setTotalGiftNum(Long totalGiftNum) {
        this.totalGiftNum = totalGiftNum;
    }

    public BigDecimal getThreshold() {
        return threshold;
    }

    public void setThreshold(BigDecimal threshold) {
        this.threshold = threshold;
    }

    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public Map<Long, Integer> getCoupons() {
        return coupons;
    }

    public void setCoupons(Map<Long, Integer> coupons) {
        this.coupons = coupons;
    }

    public Boolean getPostage() {
        return isPostage;
    }

    public void setPostage(Boolean postage) {
        isPostage = postage;
    }

    public BigDecimal getPoints() {
        return points;
    }

    public void setPoints(BigDecimal points) {
        this.points = points;
    }

    public List<GiftItem> getGiftItems() {
        return giftItems;
    }

    public void setGiftItems(List<GiftItem> giftItems) {
        this.giftItems = giftItems;
    }

    public Boolean getSelfItem() {
        return isSelfItem;
    }

    public void setSelfItem(Boolean selfItem) {
        isSelfItem = selfItem;
    }

    public Long getGiftNum() {
        return giftNum;
    }

    public void setGiftNum(Long giftNum) {
        this.giftNum = giftNum;
    }

    public Boolean getGiftItem() {
        return isGiftItem;
    }

    public void setGiftItem(Boolean giftItem) {
        isGiftItem = giftItem;
    }
}
