/*
 * *
 *  * @(#)EngineParams.java 2.0.0 19-1-7 下午4:31
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle;

import com.alibaba.fastjson.annotation.JSONField;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ExchangeActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.fullreduction.model.ActivityGiftNum;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Component;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 引擎参数基类
 *
 * @author tuyun
 * @since 2.0.0
 */
@Component
public class EngineParams implements Serializable, Cloneable {
    private static final long serialVersionUID = 4535566788660870546L;
    /**
     * 活动编号
     */
    protected long activityId;
    @ApiModelProperty(name = "activityIds", value = "当参与多个活动时使用该字段")
    private List<Long> activityIds;
    /**
     * 优惠券模板id，领券时候使用
     */
    protected long couponTemplateId;
    /**
     * 优惠券id集合，核销时候使用
     */
    protected List<Long> couponIds;
    @ApiModelProperty(name = "activityCouponList", value = "活动优惠券")
    protected List<ActivityCoupon> activityCouponList = new ArrayList<>(8);
    /**
     * 用户编号
     */
    protected long userId;

    /**
     * 用户对应的组织ID
     */
    protected Long orgId;

    /**
     * 商品
     */
    protected List<ItemVo> items;
    /**
     * 个性化折扣率返回
     */
    @ApiModelProperty(name = "个性化折扣率返回")
    protected BigDecimal discountValue;

    /**
     * 个性化优惠券面额
     */
    @ApiModelProperty(name = "个性化优惠券面额返回")
    protected BigDecimal couponAmt;

    /**
     * 赠品
     */
    @ApiModelProperty(name = "赠品")
    protected List<ItemVo> gifts;

    /**
     * 换购商品
     */
    @ApiModelProperty(name = "换购商品")
    protected List<ItemVo> excItems = new ArrayList<>();

    /**
     * 临时数据存储域 不参与计算，用于还原现场
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private List<ItemVo> tempItems;


    protected BigDecimal freight;

    @ApiModelProperty(name = "运费优惠金额")
    protected BigDecimal totalDiscountFreight;

    @ApiModelProperty(name = "优惠金额")
    protected BigDecimal totalDiscountAmount;

    @ApiModelProperty(name = "orderAmount", value = "订单金额")
    protected BigDecimal orderAmount;

    /**
     * 所属系统
     */
    protected String programSrc;

    /**
     * 由使用者定义具体意义
     */
    protected String serialNumber;

    protected Long tenantId;

    protected Long instanceId;

    @ApiModelProperty(name = "价格精度")
    private int scale = 2;

    @ApiModelProperty(name = "取余方式，@See BigDecimal")
    private int roundModel = 4;

    @ApiModelProperty(name = "业务自定义属性")
    Map<String, Object> extendsAttribute = new HashMap<>();

    @ApiModelProperty("来源店铺，非下单业务使用")
    protected String shopId;

    @ApiModelProperty("订单编号")
    private String orderCode;
    @ApiModelProperty(name = "validType", value = "引擎执行条件校验方式:1抛异常,出现异常中断执行（默认1）；2不抛异常,移除不满足条件的活动,依次执行每个活动")
    private Integer validType;

    /**
     * 商品SKU-活动映射关系，skuId-List[activityId]
     */
    @JsonIgnore
    @JSONField(serialize = false)
    private Map<String, List<Long>> itemActivitiesMapping;

    @ApiModelProperty(name = "activityShopsMapping", value = "活动和店铺的对应关系")
    private Map<String, List<Long>> activityShopsMapping;

    @ApiModelProperty(name = "activitySkusMapping", value = "活动和店铺+SKU的对应关系")
    private Map<String, List<String>> activitySkusMapping = new HashMap<>();

    @ApiModelProperty(name = "activityReasonMap", value = "不能使用活动原因 key=活动ID value=原因说明")
    private Map<String, String> activityReasonMap = new HashMap<>();

    @ApiModelProperty(name = "activityDiscountMap", value = "活动优惠 key=活动ID value=该活动优惠金额")
    private Map<String, BigDecimal> activityDiscountMap = new HashMap<>();

    @ApiModelProperty(name = "unusedActivityList", value = "未选中的活动列表")
    private List<UnuesdActivityDto> unusedActivityList = new ArrayList<>();

    @ApiModelProperty(name = "populationFlag", value = "是否需要校验目标人群范围 false：否；true:是")
    private Boolean populationFlag = true;

    @ApiModelProperty(name = "handleActivityFlag", value = "是否来源于订单维度促销活动处理 false：否；true:是")
    private Boolean handleActivityFlag = false;

    @ApiModelProperty(name = "activityFlag", value = "是否是B端促销活动 false：否；true:是")
    private Boolean activityFlag = false;

    @ApiModelProperty(name = "srcType", value = "来源类型（1:H5商城，2:PC商城）")
    private Integer srcType = 1;

    @ApiModelProperty(name = "activityStockFlag", value = "是否需要校验活动库存 false：否；true:是")
    private Boolean activityStockFlag = true;

    @ApiModelProperty(name = "exchangeActivityRespDtos", value = "换购活动相关响应信息")
    List<ExchangeActivityRespDto> exchangeActivityRespDtos = new ArrayList<>();

    @ApiModelProperty(name = "combinationActivityIds", value = "优惠套餐活动")
    List<Long> combinationActivityIds = new ArrayList<>();

    @ApiModelProperty(name = "combinationActivityItemVos", value = "优惠套餐活动商品")
    List<ItemVo> combinationActivityItemVos = new ArrayList<>();

    @ApiModelProperty(name = "tempCombinedIds", value = "临时优惠套餐活动ID集合")
    private List<Long> tempCombinedIds = new ArrayList<>();

    @ApiModelProperty(name = "activityGiftNumList", value = "赠品活动赠送赠品对应数量")
    private List<ActivityGiftNum> activityGiftNumList = new ArrayList<>();

    public List<ActivityGiftNum> getActivityGiftNumList() {
        return activityGiftNumList;
    }

    public void setActivityGiftNumList(List<ActivityGiftNum> activityGiftNumList) {
        this.activityGiftNumList = activityGiftNumList;
    }

    /**
     * 查询优化-活动模板下的实例等信息
     */
    private ActivityRespDto activityRespDto;
    /**
     * 活动库存操作结果 成功 success 失败 fail 默认成功
     */
    private String activityOptResult = "success";
    /**
     * 是否校验活动活动状态。默认强制校验 null和true是校验的
     */
    private Boolean ifValidActivityStatus = true;

    @ApiModelProperty(value = "是否使用换购额度累计：true-使用，false-不适用，默认false")
    private boolean useExchangeAccount;

    public boolean isUseExchangeAccount() {
        return useExchangeAccount;
    }

    public void setUseExchangeAccount(boolean useExchangeAccount) {
        this.useExchangeAccount = useExchangeAccount;
    }

    public List<Long> getTempCombinedIds() {
        return tempCombinedIds;
    }

    public void setTempCombinedIds(List<Long> tempCombinedIds) {
        this.tempCombinedIds = tempCombinedIds;
    }

    public List<ExchangeActivityRespDto> getExchangeActivityRespDtos() {
        return exchangeActivityRespDtos;
    }

    public void setExchangeActivityRespDtos(List<ExchangeActivityRespDto> exchangeActivityRespDtos) {
        this.exchangeActivityRespDtos = exchangeActivityRespDtos;
    }

    public List<Long> getCombinationActivityIds() {
        return combinationActivityIds;
    }

    public void setCombinationActivityIds(List<Long> combinationActivityIds) {
        this.combinationActivityIds = combinationActivityIds;
    }

    public EngineParams() {
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public Boolean getActivityStockFlag() {
        return activityStockFlag;
    }

    public void setActivityStockFlag(Boolean activityStockFlag) {
        this.activityStockFlag = activityStockFlag;
    }

    public Integer getSrcType() {
        return srcType;
    }

    public void setSrcType(Integer srcType) {
        this.srcType = srcType;
    }

    public Boolean getActivityFlag() {
        return activityFlag;
    }

    public void setActivityFlag(Boolean activityFlag) {
        this.activityFlag = activityFlag;
    }

    public Map<String, BigDecimal> getActivityDiscountMap() {
        return activityDiscountMap;
    }

    public void setActivityDiscountMap(Map<String, BigDecimal> activityDiscountMap) {
        this.activityDiscountMap = activityDiscountMap;
    }

    public Boolean getHandleActivityFlag() {
        return handleActivityFlag;
    }

    public void setHandleActivityFlag(Boolean handleActivityFlag) {
        this.handleActivityFlag = handleActivityFlag;
    }

    public Map<String, List<String>> getActivitySkusMapping() {
        return activitySkusMapping;
    }

    public void setActivitySkusMapping(Map<String, List<String>> activitySkusMapping) {
        this.activitySkusMapping = activitySkusMapping;
    }

    public Boolean getPopulationFlag() {
        return populationFlag;
    }

    public void setPopulationFlag(Boolean populationFlag) {
        this.populationFlag = populationFlag;
    }

    public Boolean getIfValidActivityStatus() {
        return ifValidActivityStatus;
    }

    public void setIfValidActivityStatus(Boolean ifValidActivityStatus) {
        this.ifValidActivityStatus = ifValidActivityStatus;
    }

    public String getActivityOptResult() {
        return activityOptResult;
    }

    public void setActivityOptResult(String activityOptResult) {
        this.activityOptResult = activityOptResult;
    }

    public ActivityRespDto getActivityRespDto() {
        return activityRespDto;
    }

    public void setActivityRespDto(ActivityRespDto activityRespDto) {
        this.activityRespDto = activityRespDto;
    }

    public Integer getValidType() {
        return validType;
    }

    public void setValidType(Integer validType) {
        this.validType = validType;
    }

    public Map<String, Object> getExtendsAttribute() {
        if (null == this.extendsAttribute) {
            this.extendsAttribute = new HashMap<>();
        }
        return extendsAttribute;

    }

    public BigDecimal getCouponAmt() {
        return couponAmt;
    }

    public void setCouponAmt(BigDecimal couponAmt) {
        this.couponAmt = couponAmt;
    }

    public List<ActivityCoupon> getActivityCouponList() {
        return activityCouponList;
    }

    public ActivityCoupon getCouponByActivityId(Long activityId) {
        for (ActivityCoupon activityCoupon : activityCouponList) {
            if (activityId.equals(activityCoupon.getActivityId())) {
                return activityCoupon;
            }

        }
        return null;
    }

    public void setActivityCouponList(List<ActivityCoupon> activityCouponList) {
        this.activityCouponList = activityCouponList;
    }

    public void setExtendsAttribute(Map<String, Object> extendsAttribute) {

        this.extendsAttribute = extendsAttribute;
    }

    public void addExtAttribute(String key, Object value) {
        this.extendsAttribute.put(key, value);
    }

    public BigDecimal getFreight() {
        return freight;
    }

    public void setFreight(BigDecimal freight) {
        this.freight = freight;
    }

    public BigDecimal getTotalDiscountFreight() {
        if (null == totalDiscountFreight) {
            return new BigDecimal("0");
        }
        return totalDiscountFreight.setScale(scale, roundModel);
    }

    public void setTotalDiscountFreight(BigDecimal totalDiscountFreight) {
        this.totalDiscountFreight = totalDiscountFreight;
    }

    public BigDecimal getTotalDiscountAmount() {
        if (null == totalDiscountAmount) {
            return new BigDecimal("0");
        }
        return totalDiscountAmount.setScale(scale, roundModel);
    }

    public void setTotalDiscountAmount(BigDecimal totalDiscountAmount) {
        this.totalDiscountAmount = totalDiscountAmount;
    }

    public BigDecimal getOrderAmount() {
        if (null == orderAmount) {
            return BigDecimal.ZERO;
        }
        return orderAmount.setScale(scale, roundModel);
    }

    public BigDecimal getDiscountValue() {
        return discountValue;
    }

    public void setDiscountValue(BigDecimal discountValue) {
        this.discountValue = discountValue;
    }

    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }

    public long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public long getActivityId() {
        return activityId;
    }

    public Object getResponse() {
        return null;
    }

    public List<ItemVo> getItems() {
        return items;
    }

    public void setItems(List<ItemVo> items) {
        this.items = items;
    }

    public List<ItemVo> getGifts() {
        return gifts;
    }

    public void setGifts(List<ItemVo> gifts) {
        this.gifts = gifts;
    }

    public String getProgramSrc() {
        return programSrc;
    }

    public void setProgramSrc(String programSrc) {
        this.programSrc = programSrc;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setActivityId(long activityId) {
        this.activityId = activityId;
    }

    public long getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(long couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }


    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public List<Long> getCouponIds() {
        return couponIds;
    }

    public void setCouponIds(List<Long> couponIds) {
        this.couponIds = couponIds;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    public int getScale() {
        return scale;
    }

    public List<Long> getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public int getRoundModel() {
        return roundModel;
    }

    public void setRoundModel(int roundModel) {
        this.roundModel = roundModel;
    }

    public String getShopId() {
        return shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }

    public List<ItemVo> getCombinationActivityItemVos() {
        return combinationActivityItemVos;
    }

    public void setCombinationActivityItemVos(List<ItemVo> combinationActivityItemVos) {
        this.combinationActivityItemVos = combinationActivityItemVos;
    }

    public List<ItemVo> getTempItems() {
        if (CollectionUtils.isEmpty(tempItems)) {
            tempItems = Lists.newLinkedList();
        }
        return tempItems;
    }

    public void setTempItems(List<ItemVo> tempItems) {
        this.tempItems = tempItems;
    }

    @Override
    public EngineParams clone() {
        EngineParams params = new EngineParams();

        params.setActivityId(this.activityId);
        params.setUserId(this.userId);
        params.setFreight(this.freight);
        params.setTotalDiscountFreight(this.totalDiscountFreight);
        params.setProgramSrc(this.programSrc);
        params.setSerialNumber(this.serialNumber);
        params.setCouponTemplateId(this.couponTemplateId);
        params.setTenantId(this.tenantId);
        params.setInstanceId(this.instanceId);
        params.setTotalDiscountAmount(this.totalDiscountAmount);
        params.setScale(this.getScale());
        params.setRoundModel(this.getRoundModel());
        if (CollectionUtils.isNotEmpty(this.items)) {
            final List<ItemVo> item = this.items.parallelStream().map(ItemVo::clone).collect(Collectors.toList());
            params.setItems(item);
        }
        if (MapUtils.isNotEmpty(this.extendsAttribute)) {
            Map<String, Object> tempData = new HashMap<>();
            this.extendsAttribute.entrySet().parallelStream().forEach(entry -> {
                tempData.put(entry.getKey(), entry.getValue());
            });
            params.setExtendsAttribute(tempData);
        }


        return params;
    }


    @Override
    public String toString() {
        return "EngineParams{" +
                "activityId=" + activityId +
                ", couponTemplateId=" + couponTemplateId +
                ", couponIds=" + couponIds +
                ", userId=" + userId +
                ", items=" + items +
                ", freight=" + freight +
                ", totalDiscountFreight=" + totalDiscountFreight +
                ", totalDiscountAmount=" + totalDiscountAmount +
                ", programSrc='" + programSrc + '\'' +
                ", serialNumber='" + serialNumber + '\'' +
                ", tenantId=" + tenantId +
                ", instanceId=" + instanceId +
                ", scale=" + scale +
                ", roundModel=" + roundModel +
                ", extendsAttribute=" + extendsAttribute +
                '}';
    }

    public Map<String, List<Long>> getItemActivitiesMapping() {
        return itemActivitiesMapping;
    }

    public void setItemActivitiesMapping(Map<String, List<Long>> itemActivitiesMapping) {
        this.itemActivitiesMapping = itemActivitiesMapping;
    }

    public Map<String, String> getActivityReasonMap() {
        return activityReasonMap;
    }

    public void setActivityReasonMap(Map<String, String> activityReasonMap) {
        this.activityReasonMap = activityReasonMap;
    }

    public Map<String, List<Long>> getActivityShopsMapping() {
        return activityShopsMapping;
    }

    public void setActivityShopsMapping(Map<String, List<Long>> activityShopsMapping) {
        this.activityShopsMapping = activityShopsMapping;
    }

    public List<UnuesdActivityDto> getUnusedActivityList() {
        return unusedActivityList;
    }

    public void setUnusedActivityList(List<UnuesdActivityDto> unusedActivityList) {
        this.unusedActivityList = unusedActivityList;
    }

    public List<ItemVo> getExcItems() {
        return excItems;
    }

    public void setExcItems(List<ItemVo> excItems) {
        this.excItems = excItems;
    }
}
