/*
 * *
 *  * @(#)ItemVo.java 2.0.0 19-1-7 下午4:31
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.collections.MapUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;

/**
 * 活动商品信息
 *
 * @author luo.lei
 * @since 2.0.0
 */
@ApiModel(value = "ItemVo")
public class ItemVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -2979876491765115979L;

    @ApiModelProperty(value = "itemId", name = "商品ID")
    private String itemId;
    /**
     * 此字段是调用方传进来
     */
    @ApiModelProperty(value = "price", name = "商品单价,应付价，参与某个活动可以修改这个价格")
    private BigDecimal price;

    @ApiModelProperty(value = "origPrice", name = "商品单价,原价，参与某个活动不可以修改这个价格")
    private BigDecimal origPrice;

    @ApiModelProperty(name = "优惠后的单价")
    private BigDecimal discountPrice;

    @ApiModelProperty(name = "商品优惠后的总金额")
    private BigDecimal discountTotalPrice;

    @ApiModelProperty(value = "exchangePrice", name = "换购商品价格,活动配置的换购价")
    private BigDecimal exchangePrice;

    @ApiModelProperty(value = "itemCategory", name = "商品类目id")
    private List<Long> itemCategory = new LinkedList<>();
    /**
     * 商品品牌
     */
    @ApiModelProperty(value = "itemBrands", name = "商品品牌id")
    private List<Long> itemBrands = Lists.newArrayList();

    @ApiModelProperty(value = "num", name = "商品数量")
    private int num = 1;

    @ApiModelProperty(value = "skuId", name = "SKU id")
    private String skuId;

    @ApiModelProperty(value = "shelfId", name = "SKU上架ID")
    private String shelfId;

    @ApiModelProperty(name = "couponId", value = "基于用户行为指定某商品使用某优惠券是使用该字段," +
            "但是如果存在一个就需要所有都使用该字段。否则使用外部的优惠券集合字段")
    private long couponId;

    @ApiModelProperty(value = "sellerId", name = "商户id")
    private String sellerId;

    @ApiModelProperty(value = "shopId", name = "店铺id")
    private String shopId;
    @ApiModelProperty(value = "activityDiscountAmount", name = "每个活动的优惠金额，Map存放")
    private List<DiscountAmount> activityDiscountAmount = new ArrayList<>(16);


    @ApiModelProperty(value = "activityList", name = "每个商品所参与的活动")
    private List<Long> activityList = new ArrayList<>(10);

    @ApiModelProperty(value = "shopPointDeductRuleId", name = "商品所在的店铺命中的积分抵扣规则 使用商品自己的规则的时候 该字段为空")
    private String shopPointDeductRuleId;

    @ApiModelProperty(
            value = "shopPointDeductRule",
            name = "0 全局规则； 1 SKU；-1 不适用任何规则"
    )
    private Integer shopPointDeductRule = -1;

    @ApiModelProperty(
            name = "minCashOutPoint",
            value = "最低抵现积分"
    )
    private Integer minCashOutPoint;
    @ApiModelProperty(
            name = "maxCashOutPoint",
            value = "最高抵现积分"
    )
    private Integer maxCashOutPoint;

    @ApiModelProperty(
            name = "cashOutPoint",
            value = "抵现积分"
    )
    private Integer cashOutPoint;

    @ApiModelProperty(
            name = "cashOutAmount",
            value = "抵现金额"
    )
    private BigDecimal cashOutAmount;

    @ApiModelProperty(value = "exchange", name = "换购商品：1是，0不是")
    private Integer exchange = 0;

    @ApiModelProperty(value = "giftSkuList", name = "每个赠品所对应的商品SKU")
    private Set<String> giftSkuList = new HashSet<>(10);

    @ApiModelProperty(name = "赠品成本")
    private BigDecimal giftCost;

    @ApiModelProperty(name = "clearExchangeItem", value = "是否清除换购商品,0 不清除，1，清除，默认为0")
    private Integer clearExchangeItem = 0;

    @ApiModelProperty(name = "exchangeActivityId", value = "换购活动id")
    private Long exchangeActivityId;

    @ApiModelProperty(name = "isCombinedPackage", value = "是否是组合套装：1是，0不是")
    private Integer isCombinedPackage = 0;

    @ApiModelProperty(value = "combinedPackageActivityId", name = "组合套装活动id")
    private Long combinedPackageActivityId;

    @ApiModelProperty(name = "lackRemainingStockMap", value = "不足的活动剩余库存 key=活动ID value=该活动对应的活动剩余库存(剩余库存大于零但小于购买数量)")
    private Map<Long, Long> lackRemainingStockMap = new HashMap<>();

    public Map<Long, Long> getLackRemainingStockMap() {
        return lackRemainingStockMap;
    }

    public void setLackRemainingStockMap(Map<Long, Long> lackRemainingStockMap) {
        this.lackRemainingStockMap = lackRemainingStockMap;
    }

    public Long getExchangeActivityId() {
        return exchangeActivityId;
    }

    public void setExchangeActivityId(Long exchangeActivityId) {
        this.exchangeActivityId = exchangeActivityId;
    }

    public BigDecimal getExchangePrice() {
        return exchangePrice;
    }

    public void setExchangePrice(BigDecimal exchangePrice) {
        this.exchangePrice = exchangePrice;
    }

    public Integer getClearExchangeItem() {
        return clearExchangeItem;
    }

    public void setClearExchangeItem(Integer clearExchangeItem) {
        this.clearExchangeItem = clearExchangeItem;
    }

    public BigDecimal getGiftCost() {
        if (null == giftCost) {
            return new BigDecimal("0");
        }
        return giftCost.setScale(2, 4);
    }

    public void setGiftCost(BigDecimal giftCost) {
        this.giftCost = giftCost;
    }
    public Set<String> getGiftSkuList() {
        return giftSkuList;
    }

    public void setGiftSkuList(Set<String> giftSkuList) {
        this.giftSkuList = giftSkuList;
    }

    public BigDecimal getOrigPrice() {
        return origPrice;
    }

    public void setOrigPrice(BigDecimal origPrice) {
        this.origPrice = origPrice;
    }

    public BigDecimal getDiscountTotalPrice() {
        return discountTotalPrice;
    }


    public void setDiscountTotalPrice(BigDecimal discountTotalPrice) {
        this.discountTotalPrice = discountTotalPrice;
    }

    public List<DiscountAmount> getActivityDiscountAmount() {
        return activityDiscountAmount;
    }

    public BigDecimal getTotoalDiscountAmount() {
        return getActivityDiscountAmount().stream()
                .map(DiscountAmount::getAmount)
                .reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public void setActivityDiscountAmount(List<DiscountAmount> activityDiscountAmount) {
        this.activityDiscountAmount = activityDiscountAmount;
    }

    public DiscountAmount getDiscountAmountByActivityId(Long activityId) {
        for (DiscountAmount discountAmount : activityDiscountAmount) {
            if (discountAmount.getActivityId().equals(activityId)) {
                return discountAmount;
            }
        }
        return null;
    }

    @ApiModelProperty(name = "业务自定义属性")
    private Map<String, Object> extendsAttribute = new HashMap<>(1);


    public ItemVo() {
    }

    public ItemVo(String itemId, BigDecimal price, int num, String skuId, long couponId,
                  String shopId, String sellerId, List<Long> itemCategory, List<Long> itemBrands, Map<String, Object> data) {
        this.itemId = itemId;
        this.price = price;
        this.num = num;
        this.extendsAttribute = data;

        this.skuId = skuId;
        this.couponId = couponId;
        this.shopId = shopId;
        this.sellerId = sellerId;
        this.itemCategory = itemCategory;
        this.itemBrands = itemBrands;
    }

    public List<Long> getItemCategory() {
        return itemCategory;
    }

    public void setItemCategory(List<Long> itemCategory) {
        this.itemCategory = itemCategory;
    }

    public int getNum() {
        return num;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public String getItemId() {
        return itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getSkuId() {
        return skuId;
    }

    public void setSkuId(String skuId) {
        this.skuId = skuId;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getDiscountPrice() {
        if (null == this.discountPrice) {
            return this.price;
        }
        return discountPrice;
    }

    public void setDiscountPrice(BigDecimal discountPrice) {
        this.discountPrice = discountPrice;
    }

    public Map<String, Object> getExtendsAttribute() {
        return extendsAttribute;
    }

    public void setExtendsAttribute(Map<String, Object> extendsAttribute) {
        this.extendsAttribute.putAll(extendsAttribute);
    }

    public void addExtendsAttribute(String key, Object value) {
        this.extendsAttribute.put(key, value);
    }

    public long getCouponId() {
        return couponId;
    }

    public void setCouponId(long couponId) {
        this.couponId = couponId;
    }

    public String getSellerId() {
        return sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public String getShopId() {
        return shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public List<Long> getItemBrands() {
        return itemBrands;
    }

    public void setItemBrands(List<Long> itemBrands) {
        this.itemBrands = itemBrands;
    }


    public String getShelfId() {
        return shelfId;
    }

    public void setShelfId(String shelfId) {
        this.shelfId = shelfId;
    }

    @Override
    protected ItemVo clone() {
        ItemVo itemVo = new ItemVo(this.itemId, this.price, this.num,
                this.skuId, this.couponId, this.shopId, this.sellerId, this.itemCategory, this.itemBrands, this.extendsAttribute);
        itemVo.setDiscountPrice(this.discountPrice);
        itemVo.setShelfId(this.getShelfId());
        //设置活动列表
        this.getActivityList().forEach(activityId -> {
            itemVo.getActivityList().add(activityId);
        });
        if (MapUtils.isNotEmpty(this.extendsAttribute)) {
            final Map<String, Object> tempData = new HashMap<>();
            this.extendsAttribute.entrySet().parallelStream().forEach(entry -> tempData.put(entry.getKey(), entry.getValue()));
            itemVo.setExtendsAttribute(tempData);
        }
        return itemVo;
    }

    @Override
    public String toString() {
//        return "ItemVo{" +
//                "itemId=" + itemId +
//                ", price=" + price +
//                ", discountPrice=" + discountPrice +
//                ", itemCategory=" + itemCategory +
//                ", itemBrands=" + itemBrands +
//                ", num=" + num +
//                ", skuId=" + skuId +
//                ", couponId=" + couponId +
//                ", sellerId=" + sellerId +
//                ", shopId=" + shopId +
//                ", extendsAttribute=" + extendsAttribute +
//                '}';
        return JSON.toJSONString(this);
    }

    public List<Long> getActivityList() {
        return activityList;
    }

    public void setActivityList(List<Long> activityList) {
        this.activityList = activityList;
    }

    public String getShopPointDeductRuleId() {
        return shopPointDeductRuleId;
    }

    public void setShopPointDeductRuleId(String shopPointDeductRuleId) {
        this.shopPointDeductRuleId = shopPointDeductRuleId;
    }

    public Integer getShopPointDeductRule() {
        return shopPointDeductRule;
    }

    public void setShopPointDeductRule(Integer shopPointDeductRule) {
        this.shopPointDeductRule = shopPointDeductRule;
    }

    public Integer getMinCashOutPoint() {
        return minCashOutPoint;
    }

    public void setMinCashOutPoint(Integer minCashOutPoint) {
        this.minCashOutPoint = minCashOutPoint;
    }

    public Integer getMaxCashOutPoint() {
        return maxCashOutPoint;
    }

    public void setMaxCashOutPoint(Integer maxCashOutPoint) {
        this.maxCashOutPoint = maxCashOutPoint;
    }

    public Integer getCashOutPoint() {
        return cashOutPoint;
    }

    public void setCashOutPoint(Integer cashOutPoint) {
        this.cashOutPoint = cashOutPoint;
    }

    public BigDecimal getCashOutAmount() {
        return cashOutAmount;
    }

    public void setCashOutAmount(BigDecimal cashOutAmount) {
        this.cashOutAmount = cashOutAmount;
    }

    public Integer getExchange() {
        return exchange;
    }

    public void setExchange(Integer exchange) {
        this.exchange = exchange;
    }

    public Integer getIsCombinedPackage() {
        return isCombinedPackage;
    }

    public void setIsCombinedPackage(Integer isCombinedPackage) {
        this.isCombinedPackage = isCombinedPackage;
    }

    public Long getCombinedPackageActivityId() {
        return combinedPackageActivityId;
    }

    public void setCombinedPackageActivityId(Long combinedPackageActivityId) {
        this.combinedPackageActivityId = combinedPackageActivityId;
    }
}