/*
 * *
 *  * @(#)Param.java 2.0.0 18-12-21 上午11:01
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 参数
 *
 * @author tuyun
 * @since 2.0.0
 */
@ApiModel(value = "Param", description = "参数配置")
public class Param {

    /**
     * 参数名
     */
    @ApiModelProperty("参数名")
    private String name;

    /**
     * 基本数据类型，字符串，时间
     */
    @ApiModelProperty("参数类型[int,long,short,byte,char,boolean,float,double,String,Date]")
    private String valueType;

    /**
     * 如果为时间格式，则需要格式转换方式 默认 yyyy-MM-dd HH:mm:ss
     */
    @ApiModelProperty("如果参数类型为Date，则需要格式转换方式 默认 yyyy-MM-dd HH:mm:ss")
    private String pattern;

    @ApiModelProperty("是否集合")
    private boolean multiple;

    @ApiModelProperty("参数是否必填")
    private boolean required = true;
    /**
     * 参数描述
     */
    private String desc;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getValueType() {
        return valueType;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public String getPattern() {
        return pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean isMultiple() {
        return multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public boolean isRequired() {
        return required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }
}
