/*
 * *
 *  * @(#)ConditionTemplateDefine.java 2.0.0 18-12-21 上午11:00
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * 条件模板定义
 *
 * @author tuyun
 * @since 2.0.0
 */
public class TemplateDefine {

    /**
     * 模板分类
     */
    private String category;
    /**
     * 标题
     */
    private String title;
    /**
     * 描述
     */
    private String desc;
    /**
     * 页面显示配置
     */
    private String show;
    /**
     * 加载class
     */
    private String loadClass;
    /**
     * 入参
     */
    private List<Param> params;


    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getShow() {
        return show;
    }

    public void setShow(String show) {
        this.show = show;
    }

    public String getLoadClass() {
        return loadClass;
    }

    public void setLoadClass(String loadClass) {
        this.loadClass = loadClass;
    }

    public List<Param> getParams() {
        return params;
    }

    public void setParams(List<Param> params) {
        this.params = params;
    }

    @JsonIgnore
    public Param getParam(String key) {
        if (CollectionUtils.isNotEmpty(this.params)) {
            return this.params.stream().filter(p -> p.getName().equals(key)).findAny().orElse(null);
        }
        return null;
    }

}
