/**
 * @(#)UnuesdActivityDto.java 1.0 2021/5/27
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Objects;

@ApiModel(value = "UnuesdActivityDto")
public class UnuesdActivityDto implements Serializable, Cloneable {
    @ApiModelProperty("活动id")
    private Long activityId;
    @ApiModelProperty("优惠券id")
    private Long couponId;

    public UnuesdActivityDto() {
    }

    public UnuesdActivityDto(Long activityId, Long couponId) {
        this.activityId = activityId;
        this.couponId = couponId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof UnuesdActivityDto)) return false;
        UnuesdActivityDto that = (UnuesdActivityDto) o;
        return Objects.equals(getActivityId(), that.getActivityId()) &&
                Objects.equals(getCouponId(), that.getCouponId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getActivityId(), getCouponId());
    }

    @Override
    public UnuesdActivityDto clone() {
        return new UnuesdActivityDto(activityId, couponId);
    }


    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getCouponId() {
        return couponId;
    }

    public void setCouponId(Long couponId) {
        this.couponId = couponId;
    }

}
