package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.enums;


import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.IExceptionEnum;

/**
 * 秒杀异常类
 * @author li.jundong
 * @date: 2019/6/26 16:33
 */
public enum SeckillErrorEnum implements IExceptionEnum {

    /**
     * 参数不存在
     */
    STOCK_NOT_ENOUGH("10016", "库存不足"),



    /**
     * 系统错误
     */
    SYSTEM_ERROR("500", "系统错误"),

    /**
     * 中台报错
     */
    CUBE_ERROR("5000", "中台报错"),
    ;

    private String code;

    private String message;

    SeckillErrorEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return message;
    }
}
