/**
 * @(#)ItemPurchaseLimit.java 1.0 2020/4/16
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.model;

/**
 * 商品购买数量限制
 *
 * @author wu.sheng
 * @date 2020/4/16 10:42
 */
public class ItemPurchaseLimit {

    /**
     * 商品id
     */
    private Long itemId;

    /**
     * 规格id
     */
    private Long skuId;

    /**
     * 店铺id
     */
    private Long shopId;

    /**
     * 每人每次限购数量
     */
    private Integer limitQuantitySingle;

    /**
     * 换购商品限制：1可换购一件，2可换购多件
     *
     */
    private Integer itemLimit;

    /**
     * 限制层级：0 SPU级别，1 SKU级别，默认0
     */
    private Integer limitLevel = 0;

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Integer getLimitQuantitySingle() {
        return limitQuantitySingle;
    }
    public void setLimitQuantitySingle(Integer limitQuantitySingle) {
        this.limitQuantitySingle = limitQuantitySingle;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Integer getItemLimit() {
        return itemLimit;
    }

    public void setItemLimit(Integer itemLimit) {
        this.itemLimit = itemLimit;
    }

    public Integer getLimitLevel() {
        return limitLevel;
    }

    public void setLimitLevel(Integer limitLevel) {
        this.limitLevel = limitLevel;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }
}
