/**
 * @(#)CacheKeyPrefix.java 1.0 2020/6/17
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 秒杀缓存key前缀
 *
 * @author wu.sheng
 * @date 2020/6/17 9:47
 */
@ApiModel(value = "SeckillKeyPrefix", description = "秒杀活动缓存key前缀")
public class SeckillKeyPrefix {

    /**
     * 活动每人参与次数条件 key-value
     */
    @ApiModelProperty(value = "活动每人参与次数限制条件 key-value（keyPrefix + activityId, limit）")
    public static final String ACTIVITY_LIMIT = "activity_limit";

    /**
     * 活动商品价格条件 hash结构
     */
    @ApiModelProperty(value = "活动商品价格条件 hash结构（keyPrefix + activityId, skuId, price）")
    public static final String ACTIVITY_ITEM_PRICE = "activity_item_price";

    /**
     * 活动商品限购数量条件 hash结构
     */
    @ApiModelProperty(value = "活动商品限购数量条件 hash结构（keyPrefix + activityId, itemId, num）")
    public static final String ACTIVITY_ITEM_LIMIT = "activity_item_limit";

    /**
     * 活动超时支付条件 key-value
     */
    @ApiModelProperty(value = "活动超时支付条件 key-value（keyPrefix + activityId, overtime）")
    public static final String OVERTIME_PAY = "activity_overtime_pay";

    /**
     * 活动人群条件会员等级
     */
    @ApiModelProperty(value = "活动人群条件会员等级 key-value（keyPrefix + activityId, List）")
    public static final String ACTIVITY_POPULATION_LEVEL = "activity_population_level";

    /**
     * 活动人群条件目标客户
     */
    @ApiModelProperty(value = "活动人群条件目标客户 key-value（keyPrefix + activityId, customer）")
    public static final String ACTIVITY_TARGET_CUSTOMER = "activity_target_customer";

    /**
     * 活动适用商城条件
     */
    @ApiModelProperty(value = "活动适用商城条件 key-value（keyPrefix + activityId, List）")
    public static final String ACTIVITY_TARGET_MALL = "activity_target_mall";

    /**
     * 活动每人每次抢购数量限制条件 key-value
     */
    @ApiModelProperty(value = "活动每人每次抢购数量限制条件 key-value（keyPrefix + activityId, limit）")
    public static final String ACTIVITY_PURCHASE_NUM_LIMIT = "activity_purchase_num_limit";
}
