package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.dto.request.JoinSeckillReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.dto.request.SeckillStockReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.dto.response.JoinSeckillRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author chen.fangliang
 * @date 2019/7/8 15:57
 */
@Api(tags = {"促销中心:营销API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-seckill-service-ISeckillActivityApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        url = "${yundt.cube.center.promotion.api:}",
        path = "/v2/activity/seckill/"
)
public interface ISeckillActivityApi {


    /**
     * 参与秒杀活动api
     * @param joinSeckillReqDto
     * @return
     */
    @PostMapping("join")
    @ApiOperation(value = "参与秒杀活动", notes = "参与秒杀活动")
    RestResponse<JoinSeckillRespDto> joinSeckill(@RequestBody JoinSeckillReqDto joinSeckillReqDto);
    /**
     * 扣减秒杀活动的库存api
     * @param seckillStockReqDto
     * @return
     */
    @PostMapping("stock/sub")
    @ApiOperation(value = "扣减秒杀活动的库存", notes = "扣减秒杀活动的库存")
    RestResponse<Void> subSeckillStock(@RequestBody SeckillStockReqDto seckillStockReqDto);
}
