/*
 * @(#)ISeckillActivityQueryApi.java 1.0 2020-06-18
 *
 * Copyright (c) 2020, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.service.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.seckill.dto.request.SeckillStockQueryReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;

/**
 * 秒杀库存查询
 * @author 简树
 * @since 2.0.0
 */
@Api(tags = {"促销中心:秒杀库存查询api"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-seckill-service-ISeckillActivityQueryApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        url = "${yundt.cube.center.promotion.api:}",
        path = "/v2/activity/seckill"
)
public interface ISeckillActivityQueryApi {
    /**
     * 查询秒杀活动库存
     * @param seckillStockQueryReqDto
     * @return
     */
    @GetMapping("/stock")
    @ApiOperation(value = "查询活动商品库存", notes = "查询活动商品库存")
    RestResponse<Long> querySeckillStock(@SpringQueryMap SeckillStockQueryReqDto seckillStockQueryReqDto);
}
