/*
 * *
 *  * @(#)ExpressionParser.java 2.0.0 18-12-21 上午11:05
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 表达式
 *
 * @author tuyun
 * @since 2.0.0
 */
public class ExpressionParser {

    private static final Pattern PATTERN_EXPRESSION = Pattern.compile("([0-9]+)");

    /**
     * "()|&=", 引号中的字符判断为操作符
     *
     * @param c 待判断内容
     * @return true: 操作符  false: 普通内容
     */
    public static boolean isOperation(char c) {
        if (c == '(' || c == ')' || c == '|' || c == '&' || c == '=') {
            return true;
        }
        return false;
    }

    /**
     * 分词
     *
     * @param expression 待分词的表达式
     * @return 使用操作符区分后的内容
     */
    public static List<String> splitWords(String expression) {
        List<String> words = new ArrayList<>();

        char[] chars = expression.toCharArray();

        StringBuilder stringBuilder = new StringBuilder();

        for (int i = 0; i < chars.length; i++) {
            char c = chars[i];

            if (isOperation(c)) {
                //遇到操作符,将前面的内容和操作符分别翻到内容列表,并重置缓冲
                if (stringBuilder.length() > 0) {
                    words.add(stringBuilder.toString());
                }
                words.add(String.valueOf(c));
                stringBuilder.delete(0, stringBuilder.length());
            } else {
                stringBuilder.append(c);

                if (i == chars.length - 1) {
                    if (stringBuilder.length() > 0) {
                        words.add(stringBuilder.toString());
                    }
                }
            }
        }
        return words;
    }

    /**
     * 判断是否是boolean
     *
     * @param str
     * @return
     */
    public static boolean isBoolean(String str) {
        if ("true".equals(str) || "false".equals(str)) {
            return true;
        }
        return false;
    }

    /**
     * 提取表达式中的所有数字 用于查找对应的condition
     *
     * @param expression
     * @return
     */
    public static List<Long> extractCondition(String expression) {
        Matcher matcher = PATTERN_EXPRESSION.matcher(expression);
        List<Long> result = new ArrayList<>();
        while (matcher.find()) {
            String conditionCode = matcher.group(0);
            Long conditionId = Long.parseLong(conditionCode);
            result.add(conditionId);
        }
        return result;
    }


    /**
     * 执行表达式
     *
     * @param expression         表达式定义
     * @param operandActionEvent 执行表达式注入的参数
     * @return
     */
    public static boolean execute(String expression, OperandActionEvent operandActionEvent) {
        // 分割单词
        List<String> words = splitWords(expression);
        // 操作符
        Stack<String> operatorStack = new Stack<>();
        // 操作数
        Stack<String> operandStack = new Stack<>();

        for (String word : words) {
            if (!isOperation(word.charAt(0))) {
                // 操作数
                operandStack.push(word);
            } else {
                // 操作符
                if ("(".equals(word)) {
                    operatorStack.push(word);
                } else if (")".equals(word)) {
                    while (!"(".equals(operatorStack.peek())) {
                        String operator = operatorStack.pop();
                        String operand2 = operandStack.pop();
                        String operand1 = operandStack.pop();

                        boolean result = false;
                        if ("|".equals(operator)) {
                            result = (isBoolean(operand1) ? Boolean.valueOf(operand1) : operandActionEvent.execute(operand1))
                                    || (isBoolean(operand2) ? Boolean.valueOf(operand2) : operandActionEvent.execute(operand2));
                        } else if ("&".equals(operator)) {
                            result = (isBoolean(operand1) ? Boolean.valueOf(operand1) : operandActionEvent.execute(operand1))
                                    && (isBoolean(operand2) ? Boolean.valueOf(operand2) : operandActionEvent.execute(operand2));
                        }
                        operandStack.push(String.valueOf(result));
                    }
                    operatorStack.pop();
                } else {
                    if (operatorStack.isEmpty() || operatorStack.peek().equals("(")) {
                        operatorStack.push(word);
                    } else {
                        if (operatorStack.peek().equals("=")) {
                            operatorStack.push(word);
                        } else {
                            String operator = operatorStack.pop();
                            String operand2 = operandStack.pop();
                            String operand1 = operandStack.pop();

                            boolean result = false;
                            if ("|".equals(operator)) {
                                result = (isBoolean(operand1) ? Boolean.valueOf(operand1) : operandActionEvent.execute(operand1))
                                        || (isBoolean(operand2) ? Boolean.valueOf(operand2) : operandActionEvent.execute(operand2));
                            } else if ("&".equals(operator)) {
                                result = (isBoolean(operand1) ? Boolean.valueOf(operand1) : operandActionEvent.execute(operand1))
                                        && (isBoolean(operand2) ? Boolean.valueOf(operand2) : operandActionEvent.execute(operand2));
                            }
                            operandStack.push(String.valueOf(result));
                            operatorStack.push(word);
                        }
                    }
                }
            }
        }

        int size = operatorStack.size();
        boolean result = false;
        for (int i = 0; i < size; i++) {
            String operator = operatorStack.pop();

            if ("=".equals(operator)) {
                String operand = operandStack.pop();
                return isBoolean(operand) ? Boolean.valueOf(operand) : operandActionEvent.execute(operand);
            } else {
                String operand2 = operandStack.pop();
                String operand1 = operandStack.pop();


                if ("|".equals(operator)) {
                    result = (isBoolean(operand1) ? Boolean.valueOf(operand1) : operandActionEvent.execute(operand1))
                            || (isBoolean(operand2) ? Boolean.valueOf(operand2) : operandActionEvent.execute(operand2));
                } else if ("&".equals(operator)) {
                    result = (isBoolean(operand1) ? Boolean.valueOf(operand1) : operandActionEvent.execute(operand1))
                            && (isBoolean(operand2) ? Boolean.valueOf(operand2) : operandActionEvent.execute(operand2));
                }
                operandStack.push(String.valueOf(result));
            }
        }

        return result;
    }
}
