package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.utils;

import org.apache.commons.lang3.StringUtils;

import java.time.*;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.regex.Pattern;

/**
 * 日期工具
 * @author : 萧玄
 * @Date: 15:13 2019/6/25
 */
public class MyDateUtil {

    public static int[] MONTH_MAX_DAY_ARRAY = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static Pattern TIME_PATTERN = Pattern.compile("[0-9]{1,2}:[0-9]{1,2}:[0-9]{1,2}|[0-9]{1,2}:[0-9]{1,2}");

    /**
     * 校验 yyyy-MM-dd
     */
    public static Pattern DATE_PATTERN = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))?$");


    public static final long ONE_SECOND =  1000;
    public static final long ONE_MINUTE =  60 * ONE_SECOND;
    public static final long ONE_HOUR = 60 * ONE_MINUTE;

    /**
     * 当天的当前时刻距离零点的毫秒数
     * @author : 萧玄
     * @Date   : 14:28 2019/8/27
     * @param
     * @return : long
     */
    public static long getCurrentTimeMillis2Zero(){
        long timeMillis = 0L;
        LocalTime localTime = LocalTime.now();
        timeMillis += localTime.getHour() * ONE_HOUR;
        timeMillis += localTime.getMinute() * ONE_MINUTE;
        timeMillis += localTime.getSecond() * ONE_SECOND;
        return timeMillis;
    }

    /**
     * 时分秒字符串转毫秒数
     * @author : 萧玄
     * @Date   : 14:19 2019/8/27
     * @param time 格式：HH:mm:ss或者HH:mm
     * @return : long
     */
    public static long getTimeMillis(String time){
        if(StringUtils.isEmpty(time)){
            return 0L;
        }
        if (TIME_PATTERN.matcher(time).matches()) {
            long timeMillis = 0L;
            String[] times = time.split(":");
            if (times.length > 0) {
                timeMillis += Integer.parseInt(times[0]) * ONE_HOUR;
            }
            if (times.length > 1) {
                timeMillis += Integer.parseInt(times[1]) * ONE_MINUTE;
            }
            if (times.length > 2) {
                timeMillis += Integer.parseInt(times[2]) * ONE_SECOND;
            }
            return timeMillis;
        }
        return 0L;
    }

    public static int maxDayOfMonth(int year, int month) {
        int feb_day_sub = 0;
        if (month == 2) {
            if ((year % 4 == 0 && year % 100 != 0) || year % 400 == 0) {
                feb_day_sub = -1;
            }
        }
        return MONTH_MAX_DAY_ARRAY[month - 1] + feb_day_sub;
    }

    public static LocalDateTime getLocalDateTimeFromDate(Date date){
        if(date == null){
            return null;
        }
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime lastUpdateDateTime = LocalDateTime.ofInstant(instant, zone);
        return lastUpdateDateTime;
    }

    public static LocalDate getLocalDateFromDate(Date date){
        return getLocalDateTimeFromDate(date).toLocalDate();
    }

    /**
     * 指定日期与当前日期是否为同一星期内
     * @author : 萧玄
     * @Date   : 10:35 2019/7/4
     * @param targetDate
     * @return : boolean
     */
    public static boolean inSameWeekWithCurrentDate(Date targetDate){
        if(targetDate == null){
            return false;
        }
        LocalDate targetLocalDate = MyDateUtil.getLocalDateFromDate(targetDate);
        LocalDate localDate = LocalDate.now();

        //判断是否同一个星期
        WeekFields weekFields = WeekFields.ISO;
        int currentWeek = localDate.get(weekFields.weekOfWeekBasedYear());
        int lastUpdateWeek = targetLocalDate.get(weekFields.weekOfWeekBasedYear());
        return currentWeek==lastUpdateWeek;
    }

    /**
     * 指定日期与当前日期是否为同年
     * @author : 萧玄
     * @Date   : 10:35 2019/7/4
     * @param targetDate
     * @return : boolean
     */
    public static boolean inSameYearWithCurrentDate(Date targetDate){
        if(targetDate == null){
            return false;
        }
        LocalDate targetLocalDate = getLocalDateFromDate(targetDate);
        LocalDate localDate = LocalDate.now();
        return targetLocalDate.getYear()==localDate.getYear();
    }
    /**
     * 指定日期与当前日期是否为同一个月份值：2019-08和2020-08为相同
     * @author : 萧玄
     * @Date   : 10:35 2019/7/4
     * @param targetDate
     * @return : boolean
     */
    public static boolean inSameMonthWithCurrentDate(Date targetDate){
        if(targetDate == null){
            return false;
        }
        LocalDate targetLocalDate = getLocalDateFromDate(targetDate);
        LocalDate localDate = LocalDate.now();
        return targetLocalDate.getMonth()==localDate.getMonth();
    }

    /**
     * 指定日期与当前日期是否为同一天：2019-01-01和2020-01-01均为一年的的第一天，故相同
     * @author : 萧玄
     * @Date   : 10:35 2019/7/4
     * @param targetDate
     * @return : boolean
     */
    public static boolean inSameDayOfYearWithCurrentDate(Date targetDate){
        if(targetDate == null){
            return false;
        }
        LocalDate targetLocalDate = getLocalDateFromDate(targetDate);
        LocalDate localDate = LocalDate.now();
        return targetLocalDate.getDayOfYear()==localDate.getDayOfYear();
    }

    /**
     * 指定日期与当前日期是否为同一个半年：2019-07-01和2020-07-01均为下半年
     * @author : 萧玄
     * @Date   : 10:35 2019/7/4
     * @param targetDate
     * @return : boolean
     */
    public static boolean inSameHalfYearWithCurrentDate(Date targetDate){
        if(targetDate == null){
            return false;
        }
        LocalDate targetLocalDate = getLocalDateFromDate(targetDate);
        LocalDate localDate = LocalDate.now();
        boolean upHalf1 = targetLocalDate.getMonth().getValue() <= Month.JUNE.getValue();
        boolean upHalf2 = localDate.getMonth().getValue() <= Month.JUNE.getValue();
        return upHalf1 == upHalf2;
    }

    public static boolean isDayFormat(String date) {
        return DATE_PATTERN.matcher(date).matches();
    }

}
