/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateBrandDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityCoupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ItemConditionTemplate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CouponBrandCondition
extends ItemConditionTemplate {
    private Logger logger = LoggerFactory.getLogger(CouponBrandCondition.class);
    public static final String COUPON_BRAND_CONDITION = "CouponBrandCondition.brands";
    @Autowired
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemActivityTagService itemActivityTagService;
    @Resource
    private IActivityService activityService;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T context, Map<String, ?> activityParams) {
        Param param = define.getParam(COUPON_BRAND_CONDITION);
        if (null == param) {
            throw new ProBizException("\u4f18\u60e0\u5238\u5546\u54c1\u54c1\u724c\u6761\u4ef6\u672a\u914d\u7f6e");
        }
        Collection brands = (Collection)ConditionTemplate.converter(activityParams.get(COUPON_BRAND_CONDITION), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)brands)) {
            return true;
        }
        List<Long> includeBrandIds = CouponBrandCondition.parseBrandIds(brands, false);
        context.getItems().removeIf(itemVo -> !CollectionUtils.containsAny((Collection)includeBrandIds, (Collection)itemVo.getItemBrands()));
        List<Long> excludeBrandIds = CouponBrandCondition.parseBrandIds(brands, true);
        context.getItems().removeIf(itemVo -> CollectionUtils.containsAny((Collection)excludeBrandIds, (Collection)itemVo.getItemBrands()));
        if (CollectionUtils.isEmpty((Collection)context.getItems())) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u54c1\u724c\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u5f53\u524d\u4f18\u60e0\u5238\u4e0d\u53ef\u7528"}));
        }
        ActivityCoupon activityCoupon = context.getCouponByActivityId(Long.valueOf(context.getActivityId()));
        if (activityCoupon != null) {
            activityCoupon.setItems(context.getItems());
        }
        return true;
    }

    public static List<CouponTemplateBrandDto> parseParams(String conditionParams) {
        if (StringUtils.isBlank((CharSequence)conditionParams)) {
            return Collections.emptyList();
        }
        JSONArray jsonArray = JSON.parseObject((String)conditionParams).getJSONArray(COUPON_BRAND_CONDITION);
        if (jsonArray == null) {
            return Collections.emptyList();
        }
        return jsonArray.toJavaList(CouponTemplateBrandDto.class);
    }

    public static List<Long> parseBrandIds(Collection<CouponTemplateBrandDto> brands, boolean isExclude) {
        List<Long> brandIds;
        if (CollectionUtils.isNotEmpty(brands) && CollectionUtils.isNotEmpty(brandIds = brands.stream().filter(param -> param.isExclude() == isExclude).map(CouponTemplateBrandDto::getBrandId).collect(Collectors.toList()))) {
            return brandIds;
        }
        return Lists.newArrayList();
    }

    @Override
    public boolean apply(TemplateDefine define, ConditionRespDto conditionRespDto, ItemVo itemVo) {
        List itemRespDtos = (List)this.itemQueryApi.queryByItemIds(itemVo.getItemId()).getData();
        if (CollectionUtils.isEmpty((Collection)itemRespDtos)) {
            return false;
        }
        ItemRespDto itemRespDto = (ItemRespDto)itemRespDtos.get(0);
        JSONObject configParams = JSON.parseObject((String)conditionRespDto.getConditionParams());
        ArrayList<ItemVo> items = new ArrayList<ItemVo>();
        ArrayList<Long> itemBrands = new ArrayList<Long>();
        itemBrands.add(itemRespDto.getBrandId());
        itemVo.setItemBrands(itemBrands);
        items.add(itemVo);
        EngineParams engineParams = new EngineParams();
        engineParams.setItems(items);
        try {
            this.execute(define, conditionRespDto, (EngineParams)engineParams, (Map<String, ?>)configParams);
        }
        catch (ProBizException e) {
            this.logger.info("\u6761\u4ef6\u68c0\u67e5\u4e0d\u901a\u8fc7", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public Set<ActivityItemDto> getItems(TemplateDefine define, ConditionRespDto conditionRespDto, Map<String, ?> configParams) {
        Param param = define.getParam(COUPON_BRAND_CONDITION);
        if (null == param) {
            throw new ProBizException("\u4f18\u60e0\u5238\u5546\u54c1\u54c1\u724c\u6761\u4ef6\u672a\u914d\u7f6e");
        }
        Collection brands = (Collection)ConditionTemplate.converter(configParams.get(COUPON_BRAND_CONDITION), param, define.getLoadClass());
        ActivityRespDto activityRespDto = this.activityService.queryById(conditionRespDto.getActivityId());
        if (null == activityRespDto) {
            return Collections.EMPTY_SET;
        }
        ItemShelfQueryReqDto queryReqDto = new ItemShelfQueryReqDto();
        queryReqDto.setInstanceId(activityRespDto.getInstanceId());
        queryReqDto.setTenantId(activityRespDto.getTenantId());
        queryReqDto.setSellerId(activityRespDto.getSellerId());
        queryReqDto.setShopId(activityRespDto.getShopId());
        if (!CollectionUtils.isEmpty((Collection)brands)) {
            List<Long> includeBrandIds = CouponBrandCondition.parseBrandIds(brands, false);
            queryReqDto.setBrandIds(includeBrandIds);
        }
        return this.itemActivityTagService.queryItemsForB2b(queryReqDto);
    }
}

