/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.yundt.cube.biz.member.api.basis.IMemberInfoBestoreApi;
import com.dtyunxi.yundt.cube.biz.member.api.basis.dto.request.TradeInfoReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.CheckPointEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ItemsRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityResultMessage;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityJoinLogExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IActivityExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.ITradeSyncService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.promotion.service.query.IItemsQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ActivityEngineClient;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="tradeSyncService")
public class TradeSyncServiceImpl
implements ITradeSyncService {
    private static final Logger logger = LoggerFactory.getLogger(TradeSyncServiceImpl.class);
    @Resource
    private IMemberInfoBestoreApi memberInfoBestoreApi;
    @Resource
    private ActivityEngineClient activityEngineClient;
    @Resource
    private IActivityExtService activityExtService;
    @Resource
    private IActivityJoinLogExtService activityJoinLogExtService;
    @Resource
    private IItemsQueryService itemsQueryService;
    @Resource
    private ICommonsMqService mqService;
    @Resource
    private IActivityExtQueryService activityExtQueryService;

    @Override
    public void commonJoinInActivityLog(TradeInfoReqDto tradeInfoReqDto, Long activityId) {
        logger.info("\u50a8\u5b58\u666e\u901a\u4fc3\u9500\u65e5\u5fd7\uff1a{}", (Object)JSON.toJSONString((Object)tradeInfoReqDto));
        EngineParams params = new EngineParams();
        params.setActivityId(activityId.longValue());
        try {
            this.fillParams(tradeInfoReqDto, params);
            this.activityJoinLogExtService.joinInActivityEnable(params);
        }
        catch (Exception e) {
            logger.error("{}", (Object)e.getMessage());
        }
    }

    @Override
    public Map<String, Object> specialJoinInActivity(TradeInfoReqDto tradeInfoReqDto) {
        logger.info("\u53c2\u4e0e\u6ee1\u8fd4\u6d3b\u52a8\uff1a{}", (Object)JSON.toJSONString((Object)tradeInfoReqDto));
        HashMap resultMap = Maps.newHashMap();
        List<ActivityEo> activityEos = this.activityExtQueryService.activateAcListByPayTime(ActivityType.FULL_RETURNING_ACTIVITY, tradeInfoReqDto.getPayTime());
        if (CollectionUtils.isNotEmpty(activityEos)) {
            ArrayList matchAc = Lists.newArrayList();
            for (ActivityEo activity2 : activityEos) {
                String memberSourceCode;
                if (StringUtils.isNotEmpty((CharSequence)activity2.getO2oChannel()) && !Objects.equals(memberSourceCode = tradeInfoReqDto.getMemberSourceCode(), activity2.getO2oChannel())) {
                    logger.info("\u53c2\u4e0e\u6ee1\u8fd4\u6d3b\u52a8[{}]\u5931\u8d25\uff0c\u7528\u6237o2o\u6e20\u9053[{}]\u4e0e\u914d\u7f6eo2o\u6e20\u9053[{}]\u4e0d\u76f8\u540c", new Object[]{activity2.getId(), memberSourceCode, activity2.getO2oChannel()});
                    continue;
                }
                EngineParams reviewParams = new EngineParams();
                this.fillParams(tradeInfoReqDto, reviewParams);
                reviewParams.setActivityId(activity2.getId().longValue());
                try {
                    this.activityEngineClient.defineCheckpoint(CheckPointEnum.REVIEW_ACTIVITY.toString()).executeNoValidate(reviewParams);
                    matchAc.add(activity2);
                }
                catch (Exception e) {
                    logger.warn("\u9884\u89c8\u6ee1\u8fd4\u6d3b\u52a8\u5f02\u5e38");
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
            Collection<ActivityEo> hitActivities = this.activityExtQueryService.mutex(matchAc);
            hitActivities.forEach(activity -> {
                EngineParams joinParams = new EngineParams();
                this.fillParams(tradeInfoReqDto, joinParams);
                joinParams.setActivityId(activity.getId().longValue());
                try {
                    logger.info("\u53c2\u4e0e\u6ee1\u8fd4EngineParams\uff1a{}", (Object)JSON.toJSONString((Object)joinParams));
                    this.activityEngineClient.defineCheckpoint(CheckPointEnum.JOIN_ACTIVITY.toString()).executeNoValidate(joinParams);
                    joinParams.getItems().forEach(itemVo -> {
                        String orderLineId = MapUtils.getString((Map)itemVo.getExtendsAttribute(), (Object)"orderLineId", (String)"");
                        if (StringUtils.isNotEmpty((CharSequence)itemVo.getItemId())) {
                            String orderFlag = orderLineId + "-" + MapUtils.getString((Map)itemVo.getExtendsAttribute(), (Object)"skuId", (String)itemVo.getItemId());
                            if (resultMap.get(orderFlag) != null) {
                                BigDecimal sourcePoints = (BigDecimal)MapUtils.getObject((Map)itemVo.getExtendsAttribute(), (Object)"returnPoints", (Object)BigDecimal.ZERO);
                                resultMap.put(orderFlag, sourcePoints.add((BigDecimal)resultMap.get(orderFlag)));
                            } else {
                                BigDecimal addPoint = BigDecimal.ZERO;
                                if (itemVo.getExtendsAttribute().get("returnPoints") != null) {
                                    addPoint = (BigDecimal)itemVo.getExtendsAttribute().get("returnPoints");
                                }
                                resultMap.put(orderFlag, addPoint);
                            }
                        }
                    });
                    ActivityResultMessage message = new ActivityResultMessage();
                    message.setOrderCode(joinParams.getOrderCode());
                    message.setParams(joinParams);
                    message.setSuccess(Boolean.valueOf(true));
                    logger.info("\u53c2\u4e0e\u6ee1\u8fd4\u6210\u529f\uff0c\u53d1\u9001\u6d3b\u52a8\u6fc0\u6d3bmq\u6d88\u606f\uff01");
                    this.mqService.sendDelaySingleMessage("JOIN_IN_ACTIVITY_RESULT", (Object)message, Long.valueOf(1L));
                }
                catch (Exception e) {
                    logger.warn("\u53c2\u4e0e\u6ee1\u8fd4\u6d3b\u52a8\u5f02\u5e38");
                    logger.warn(e.getMessage(), (Throwable)e);
                }
                logger.info("\u53c2\u4e0e\u6ee1\u8fd4\u8fd4\u56de\uff1a{}", (Object)JSON.toJSONString((Object)resultMap));
            });
        } else {
            logger.info("\u5185\u90e8\u8ba2\u5355\u53f7\u8ba2\u5355\uff1a{}\uff0c\u5916\u90e8\u8ba2\u5355\u53f7\uff1a{}\u6ca1\u6709\u6ee1\u8fd4\u6d3b\u52a8\u53ef\u53c2\u4e0e", (Object)tradeInfoReqDto.getInnerTradeCode(), (Object)tradeInfoReqDto.getTradeCode());
        }
        return resultMap;
    }

    private void fillParams(TradeInfoReqDto tradeInfoReqDto, EngineParams params) {
        ArrayList itemVos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)tradeInfoReqDto.getTradeItems())) {
            this.fillItemVos(tradeInfoReqDto.getTradeItems(), tradeInfoReqDto.getPlatCode(), itemVos, tradeInfoReqDto.getShopCode());
        }
        params.setItems((List)itemVos);
        Long memberId = (Long)this.memberInfoBestoreApi.queryMemberIdByMemberNo(tradeInfoReqDto.getMemberNo()).getData();
        params.setUserId(memberId);
        params.setTotalDiscountAmount(tradeInfoReqDto.getDiscountAmount());
        params.setFreight(tradeInfoReqDto.getFreight());
        if (ServiceContext.getContext().getRequestTenantId() != null) {
            params.setTenantId(ServiceContext.getContext().getRequestTenantId());
        }
        if (ServiceContext.getContext().getRequestInstanceId() != null) {
            params.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        }
        params.setOrderCode(tradeInfoReqDto.getInnerTradeCode());
        params.addExtAttribute("outerTradeCode", (Object)tradeInfoReqDto.getTradeCode());
        params.setShopId(tradeInfoReqDto.getShopCode());
        params.setProgramSrc(tradeInfoReqDto.getChannel());
        params.setSerialNumber(tradeInfoReqDto.getShopCode());
        params.addExtAttribute("platCode", (Object)tradeInfoReqDto.getPlatCode());
    }

    private void fillItemVos(List<TradeInfoReqDto.TradeItem> tradeItems, String platCode, List<ItemVo> itemVos, String shopCode) {
        for (TradeInfoReqDto.TradeItem tradeItem : tradeItems) {
            if (Objects.equals(tradeItem.getItemType(), "GIFT")) continue;
            ItemVo item = new ItemVo();
            if (StringUtils.isNotEmpty((CharSequence)tradeItem.getCKDName())) {
                item.setItemId(tradeItem.getCKDName());
            } else {
                item.setItemId(tradeItem.getItemCode());
            }
            item.setPrice(tradeItem.getItemPrice());
            ItemsRespDto itemDto = this.itemsQueryService.queryByCode(tradeItem.getItemCode());
            if (itemDto != null) {
                item.addExtendsAttribute("itemType", (Object)itemDto.getCategory());
            }
            item.setNum(tradeItem.getItemNum().setScale(0, 0).intValue());
            item.setSkuId(tradeItem.getItemSku());
            item.setShopId(shopCode);
            item.addExtendsAttribute("shopCode", (Object)shopCode);
            item.addExtendsAttribute("platCode", (Object)platCode);
            item.addExtendsAttribute("payAmt", (Object)tradeItem.getPayAmount());
            item.addExtendsAttribute("itemQuantity", (Object)tradeItem.getItemNum());
            item.addExtendsAttribute("orderLineId", (Object)tradeItem.getOrderLineId());
            item.addExtendsAttribute("skuId", (Object)tradeItem.getItemCode());
            item.addExtendsAttribute("CKDName", (Object)tradeItem.getCKDName());
            itemVos.add(item);
        }
    }
}

