/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityCreateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IActivityApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.action.AbstractActionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.action.ActionFactory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ActivityFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActivityService {
    private static Logger logger = LoggerFactory.getLogger(AbstractActivityService.class);

    public <T extends BaseActivityDto> Long addActivity(T activityReqDto) {
        this.validateTime(activityReqDto);
        ActivityCreateReqDto activityCreateReqDto = new ActivityCreateReqDto();
        IActivityApi activityApi = (IActivityApi)SpringBeanUtil.getBean((String)"activityApiImpl", IActivityApi.class);
        ActivityDto activityDto = new ActivityDto();
        CubeBeanUtils.copyProperties((Object)activityDto, activityReqDto, (String[])new String[0]);
        activityDto.setActivityTemplateId(Long.valueOf(activityReqDto.getActivityType().getId()));
        activityDto.setAuditStatusEnum(AuditStatusEnum.WAIT_AUDIT);
        activityDto.setActivityStatusEnum(ActivityStatusEnum.NEW);
        List<ActivityItemReqDto> activityItems = this.getActivityItems(activityReqDto);
        List conditions = ActivityFactory.getActivityTemplate(activityReqDto.getActivityType()).stream().map(conditionTemplate -> conditionTemplate.convertToCondition(activityReqDto)).collect(Collectors.toList());
        List actions = ActionFactory.getActionTemplate(activityReqDto.getActivityType()).stream().map(AbstractActionTemplate::getActionReqDto).collect(Collectors.toList());
        activityCreateReqDto.setActivityRelations(activityReqDto.getRelationReqDtos());
        activityCreateReqDto.setActivityDto(activityDto);
        activityCreateReqDto.setActivityItems(activityItems);
        activityCreateReqDto.setConditions(conditions);
        activityCreateReqDto.setActions(actions);
        RestResponse restResponse = activityApi.add(activityCreateReqDto);
        Long id = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        return id;
    }

    private <T extends BaseActivityDto> void validateTime(T activityReqDto) {
        if (activityReqDto.getBeginTime().compareTo(activityReqDto.getEndTime()) > -1) {
            throw new BizException("\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u9700\u5c0f\u4e8e\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
        }
        if (null != activityReqDto.getPreheatStartTime() && activityReqDto.getPreheatStartTime().compareTo(activityReqDto.getBeginTime()) > -1) {
            throw new BizException("\u6d3b\u52a8\u9884\u70ed\u65f6\u95f4\u9700\u5c0f\u4e8e\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4");
        }
    }

    protected abstract <T extends BaseActivityDto> List<ActivityItemReqDto> getActivityItems(T var1);
}

