/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.impl;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponItemService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponItemMappingDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponItemMappingEo;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="couponItemService")
public class CouponItemServiceImpl
implements ICouponItemService {
    @Autowired
    private CouponItemMappingDas couponItemMappingDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchInsert(long couponTemplateId, @NotEmpty String scopeType, @Nullable List<Long> objIds) {
        if (!CollectionUtils.isEmpty(objIds)) {
            CouponItemMappingEo forDel = CouponItemMappingEo.newInstance();
            forDel.setCouponTemplateId(Long.valueOf(couponTemplateId));
            forDel.setItemRange(scopeType);
            this.couponItemMappingDas.delete((BaseEo)forDel);
            List couponItemMappingEoList = objIds.stream().map(bizId -> {
                CouponItemMappingEo couponItemMappingEo = new CouponItemMappingEo();
                couponItemMappingEo.setItemRange(scopeType);
                couponItemMappingEo.setBizId(bizId);
                couponItemMappingEo.setCouponTemplateId(Long.valueOf(couponTemplateId));
                couponItemMappingEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
                couponItemMappingEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
                return couponItemMappingEo;
            }).collect(Collectors.toList());
            this.couponItemMappingDas.insertBatch(couponItemMappingEoList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long couponTemplateId) {
        CouponItemMappingEo couponItemMappingEo = CouponItemMappingEo.newInstance();
        couponItemMappingEo.setCouponTemplateId(Long.valueOf(couponTemplateId));
        couponItemMappingEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        couponItemMappingEo.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        this.couponItemMappingDas.logicDelete((BaseEo)couponItemMappingEo);
    }

    @Override
    public List<CouponItemMappingEo> queryByCouponTemplateId(long couponTemplateId) {
        CouponItemMappingEo eo = CouponItemMappingEo.newInstance();
        eo.setCouponTemplateId(Long.valueOf(couponTemplateId));
        return this.couponItemMappingDas.select((BaseEo)eo);
    }
}

