/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IConditionCacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdConditionEo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConditionCacheServiceImpl
implements IConditionCacheService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICacheService cacheService;

    public String getConditionCacheKey(Long activityId) {
        return "CACHE:" + ConditionEo.class.getName() + ":" + activityId;
    }

    @Override
    public void setConditionListCache(List<ConditionEo> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            Map<Long, List<ConditionEo>> conditionMap = list.stream().collect(Collectors.groupingBy(StdConditionEo::getActivityId));
            conditionMap.forEach((activityId, conditionEos) -> {
                if (conditionEos != null) {
                    String conditionCacheKey = this.getConditionCacheKey((Long)activityId);
                    this.cacheService.setCache(conditionCacheKey, conditionEos, 3600);
                }
            });
        }
    }

    @Override
    public List<ConditionEo> findConditionListCache(List<Long> activityIds) {
        ArrayList<ConditionEo> responseList = new ArrayList<ConditionEo>();
        if (CollectionUtils.isNotEmpty(activityIds)) {
            activityIds.forEach(activityId -> {
                String conditionCacheKey = this.getConditionCacheKey((Long)activityId);
                List cacheList = (List)this.cacheService.getCache(conditionCacheKey, List.class);
                if (null != cacheList) {
                    String json = JSON.toJSONString((Object)cacheList);
                    responseList.addAll(JSON.parseArray((String)json, ConditionEo.class));
                }
            });
        }
        return responseList;
    }

    @Override
    public void deleteConditionListCache(Long activityId) {
        String conditionCacheKey = this.getConditionCacheKey(activityId);
        try {
            this.cacheService.delCache(conditionCacheKey);
        }
        catch (Exception e) {
            this.logger.error("\u6e05\u9664\u7528\u6237\u6761\u4ef6\u7f13\u5b58\u51fa\u73b0\u5f02\u5e38, activityId={}, message={}", new Object[]{activityId, e.getMessage(), e});
        }
    }
}

