/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.BizExceptionHelper;
import com.dtyunxi.icommerce.utils.IExceptionCode;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.biz.member.api.basis.dto.response.MemberInfoDetailRespDto;
import com.dtyunxi.yundt.cube.biz.member.api.basis.query.IMemberInfoExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.member.api.common.condition.Criteria;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.ExchangeItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ConditionTemplateType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IActivityApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCategoryEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponHierarchyEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponItemRange;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponMutexTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateGenerateTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplatePurposeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateShopTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.GroupPurchaseTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponBatchSendReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponSendTemplateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateCreateExtReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponPushErrorDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponPushRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateBrandDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateShopDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ReceiveRuleDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.ICouponExtApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.ICouponTemplateExtApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.query.ICouponTemplateExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.ConditionAmount;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.ConditionBrand;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.ConditionItem;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.CouponTemplateExtDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponUseTimeDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.PopulationDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon.CouponBrandRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon.CouponDirRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon.CouponGrantReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon.CouponItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon.CouponShopBaseDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.coupon.CouponTemplateExtQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.CouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.CouponTemplateDetailRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IActivityAggService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.ICouponTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ActivityFactory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.coupon.CouponItemCondition;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.exchangecoupon.ReceiveCondition;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.constant.CouponTemplateConstant;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.constant.MarketingConstant;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.enums.CollectionMethodEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.enums.CouponRangeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.enums.ItemRangeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.enums.MarketingModuleExcpCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.enums.QueryCouponTpStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.MarketingModuleHelper;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.serializa.SerializeCouPonUseTimeValueDistribute;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.validate.ValidateCouPonUseTimeParamDistribute;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.util.PageInfoUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponTemplateImpl
implements ICouponTemplate {
    private static Logger logger = LoggerFactory.getLogger(CouponTemplateImpl.class);
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Resource
    private ICouponTemplateExtApi couponTemplateExtApi;
    @Resource(name="couponTemplateExtQueryApi")
    private ICouponTemplateExtQueryApi couponTemplateExtQueryApi;
    @Resource
    private IContext context;
    @Resource(name="couponExtApi")
    private ICouponExtApi couponExtApi;
    @Resource(name="couponEsQueryApi")
    private ICouponExtQueryApi couponExtQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IBrandQueryApi brandQueryApi;
    @Resource
    private IDirectoryQueryApi directoryQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Autowired
    private MarketingModuleHelper marketingModuleHelper;
    @Autowired
    private IMemberInfoExtQueryApi memberInfoExtQueryApi;
    @Resource(name="activityApiImpl")
    private IActivityApi activityApi;
    @Resource(name="activityQueryApiImpl")
    private IActivityQueryApi activityQueryApi;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IActivityAggService activityService;

    @Override
    public Long create(CouponTemplate couponTemplate) {
        this.validateParam(couponTemplate);
        CouponTemplateCreateExtReqDto createExtReqDto = this.getCouponTemplateCreateExtReqDto(couponTemplate);
        logger.debug("\u65b0\u589e\u4f18\u60e0\u5238\u53c2\u6570\uff1a{}", (Object)ObjectHelper.bean2Json((Object)createExtReqDto));
        RestResponse restResponse = this.couponTemplateExtApi.addCouponTemplate(createExtReqDto);
        Long templateId = (Long)RestResponseHelper.extractData((RestResponse)restResponse);
        return templateId;
    }

    private CouponTemplateCreateExtReqDto getCouponTemplateCreateExtReqDto(CouponTemplate couponTemplate) {
        Object sellerId = null;
        List<ActionReqDto> actionList = this.getActionList();
        List<ConditionReqDto> conditionList = this.getConditionList(couponTemplate);
        String couponCode = this.marketingModuleHelper.generateCode("YHQ");
        CouponTemplateCreateExtReqDto createExtReqDto = new CouponTemplateCreateExtReqDto();
        SerializeCouPonUseTimeValueDistribute.serialize(couponTemplate);
        CubeBeanUtils.copyProperties((Object)createExtReqDto, (Object)couponTemplate, (String[])new String[0]);
        createExtReqDto.setCouponCode(couponCode);
        createExtReqDto.setActivityStatusEnum(ActivityStatusEnum.NEW);
        createExtReqDto.setMarketingCode("");
        createExtReqDto.setConditions(conditionList);
        createExtReqDto.setActions(actionList);
        createExtReqDto.setActivityTemplateId(MarketingConstant.ACTIVITY_TP_ID);
        createExtReqDto.setAuditStatusEnum(AuditStatusEnum.WAIT_AUDIT);
        createExtReqDto.setCouponTemplateStatus(CouponTemplateStatusEnum.CREATE.getStatus());
        createExtReqDto.setIsGenerateCode(CouponTemplateGenerateTypeEnum.IS_NOT_GENERATE.getType());
        createExtReqDto.setIsGroupPurchase(GroupPurchaseTypeEnum.IS_NOT_GROUP.getType());
        createExtReqDto.setIsStoreMutex(Integer.valueOf(0));
        createExtReqDto.setIsDirectional(Integer.valueOf(0));
        if (CouponItemRange.SHOP.getKey().equals(couponTemplate.getItemRange())) {
            createExtReqDto.setShopType(CouponTemplateShopTypeEnum.CUSTOM_SHOP.getType());
        } else {
            createExtReqDto.setShopType(CouponTemplateShopTypeEnum.ALL_SHOP.getType());
        }
        if (CollectionMethodEnum.PRIVATE.getKey().equals(couponTemplate.getCollectionMethod())) {
            createExtReqDto.setCouponType(CouponTypeEnum.COUPON_PUSHED.getType());
        } else {
            createExtReqDto.setCouponType(CouponTypeEnum.COUPON.getType());
        }
        if (CouponCategoryEnum.EXTRACT.getCategory().equals(couponTemplate.getCouponCategory())) {
            createExtReqDto.setCouponRange(CouponRangeEnum.SELLER.getKey());
        }
        createExtReqDto.setHierarchy(CouponHierarchyEnum.GENERAL.getHierarchy());
        createExtReqDto.setMutexType(CouponMutexTypeEnum.NO_MUTEX.getMutex());
        createExtReqDto.setPurpose(CouponTemplatePurposeEnum.OTHER.getPurpose());
        createExtReqDto.setGroupPurchasePrice(BigDecimal.ZERO);
        createExtReqDto.setInstanceId(this.context.instanceId());
        createExtReqDto.setTenantId(this.context.tenantId());
        createExtReqDto.setEffectiveTime(couponTemplate.getCouponUseBeginTime());
        createExtReqDto.setInvalidTime(couponTemplate.getCouponUseEndTime());
        CouponTemplateExtDto extension = new CouponTemplateExtDto();
        BeanUtils.copyProperties((Object)couponTemplate, (Object)extension);
        createExtReqDto.setExtFields(ObjectHelper.bean2Map((Object)extension));
        createExtReqDto.setActivityRelations(couponTemplate.getRelationReqDtos());
        return createExtReqDto;
    }

    private void validateParam(CouponTemplate couponTemplate) {
        ValidateCouPonUseTimeParamDistribute.validateParam(couponTemplate);
        if (ItemRangeEnum.SHOP.getKey().equals(couponTemplate.getItemRange())) {
            if (CollectionUtils.isEmpty((Collection)couponTemplate.getShopIdList())) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.SHOP_NOT_EMPTY);
            }
        } else if (ItemRangeEnum.CATEGORY.getKey().equals(couponTemplate.getItemRange())) {
            if (CollectionUtils.isEmpty((Collection)couponTemplate.getDirIdList()) || CollectionUtils.isEmpty((Collection)couponTemplate.getBrandIdList())) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.DIT_OR_BRAND_NOT_EMPTY);
            }
        } else if (ItemRangeEnum.ITEM.getKey().equals(couponTemplate.getItemRange())) {
            if (CollectionUtils.isEmpty((Collection)couponTemplate.getCouponItems())) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.ITEM_NOT_EMPTY);
            }
            couponTemplate.getCouponItems().forEach(couponItemDto -> {
                if (null == couponItemDto.getShopId()) {
                    BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.ITEM_SHOP_ID_NOT_EMPTY);
                }
            });
        }
        if (CollectionMethodEnum.PUBLIC.getKey().equals(couponTemplate.getCollectionMethod()) && couponTemplate.getReceiveStartTime().after(couponTemplate.getReceiveEndTime())) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.RECEIVE_TIME_INVALID);
        }
        if (CouponCategoryEnum.DISCOUNT.getCategory().equals(couponTemplate.getCouponCategory()) && (couponTemplate.getCouponValue().compareTo(BigDecimal.ONE) < 0 || couponTemplate.getCouponValue().compareTo(BigDecimal.TEN) >= 0)) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.DISCOUNT_VALUE_INVALID);
        }
        if (CollectionMethodEnum.PUBLIC.getKey().equals(couponTemplate.getCollectionMethod())) {
            if (null == couponTemplate.getLimitNum() || null == couponTemplate.getDailyLimitNum()) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.LIMIT_NUM_NOT_EMPTY);
            }
            if ((long)couponTemplate.getLimitNum().intValue() > couponTemplate.getTotalIssueQuantity()) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.LIMIT_NUM_INVALID);
            }
            if ((long)couponTemplate.getDailyLimitNum().intValue() > couponTemplate.getTotalIssueQuantity()) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.DAILY_LIMIT_NUM_INVALID);
            }
        }
        if (CouponCategoryEnum.EXTRACT.getCategory().equals(couponTemplate.getCouponCategory())) {
            if (CollectionUtils.isEmpty((Collection)couponTemplate.getExchangeItems())) {
                throw new BizException("\u5151\u6362\u5546\u54c1\u4e0d\u80fd\u4e0d\u7a7a");
            }
            couponTemplate.getExchangeItems().forEach(item -> {
                if (CollectionUtils.isEmpty((Collection)item.getSkus())) {
                    throw new BizException("\u5151\u6362\u5546\u54c1\u89c4\u683c\u4e0d\u80fd\u4e3a\u7a7a");
                }
                item.getSkus().forEach(sku -> {
                    if (null == sku.getSkuId()) {
                        throw new BizException("\u5151\u6362\u5546\u54c1\u89c4\u683cID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                });
            });
            Set shopIds = couponTemplate.getExchangeItems().stream().map(CouponItemDto::getShopId).collect(Collectors.toSet());
            if (shopIds.size() > 1) {
                throw new BizException("\u5151\u6362\u5546\u54c1\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u5e97\u94fa\u4e0b\u7684\u5546\u54c1");
            }
        }
    }

    private List<ActionReqDto> getActionList() {
        ArrayList actionList = Lists.newArrayList();
        ActionReqDto receiveAction = new ActionReqDto();
        receiveAction.setActionParams("{}");
        receiveAction.setActionTemplateId(MarketingConstant.ACTION_RECEIVE_TP_ID);
        actionList.add(receiveAction);
        ActionReqDto emptyAction = new ActionReqDto();
        emptyAction.setActionParams("{}");
        emptyAction.setActionTemplateId(MarketingConstant.ACTION_EMPTY_TP_ID);
        actionList.add(emptyAction);
        ActionReqDto writeOffAction = new ActionReqDto();
        writeOffAction.setActionParams("{}");
        writeOffAction.setActionTemplateId(MarketingConstant.ACTION_WRITE_OFF_TP_ID);
        actionList.add(writeOffAction);
        ActionReqDto joinSuccess = new ActionReqDto();
        joinSuccess.setActionParams("{}");
        joinSuccess.setActionTemplateId(MarketingConstant.ACTION_JOIN_SUCCESS_ID);
        actionList.add(joinSuccess);
        return actionList;
    }

    private List<ConditionReqDto> getConditionList(CouponTemplate couponTemplate) {
        List itemList;
        ArrayList conditionList = Lists.newArrayList();
        ConditionReqDto limitCondition = new ConditionReqDto();
        HashMap limitConditionParam = Maps.newHashMap();
        if (null == couponTemplate.getLimitNum() || null == couponTemplate.getDailyLimitNum()) {
            couponTemplate.setLimitNum(Integer.valueOf(0));
            couponTemplate.setDailyLimitNum(Integer.valueOf(0));
        }
        limitConditionParam.put("CouponReceiveLimitCondition.limit", couponTemplate.getLimitNum());
        limitConditionParam.put("CouponReceiveLimitCondition.dayLimit", couponTemplate.getDailyLimitNum());
        limitCondition.setConditionParams(ObjectHelper.bean2Json((Object)limitConditionParam));
        limitCondition.setConditionTemplateId(MarketingConstant.CONDITION_LIMIT_TP_ID);
        conditionList.add(limitCondition);
        ConditionReqDto categoriesCondition = new ConditionReqDto();
        HashMap categoriesConditionParam = Maps.newHashMap();
        if (CollectionUtils.isEmpty((Collection)couponTemplate.getDirIdList())) {
            couponTemplate.setDirIdList((List)Lists.newArrayList());
        }
        categoriesConditionParam.put("CouponCategoryCondition.categories", couponTemplate.getDirIdList());
        categoriesCondition.setConditionParams(JSON.toJSONString((Object)categoriesConditionParam));
        categoriesCondition.setConditionTemplateId(MarketingConstant.CONDITION_DIR_TP_ID);
        conditionList.add(categoriesCondition);
        ConditionReqDto brandCondition = new ConditionReqDto();
        ArrayList brandList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)couponTemplate.getBrandIdList())) {
            couponTemplate.getBrandIdList().forEach(branId -> {
                ConditionBrand brand = new ConditionBrand();
                brand.setBrandId(branId);
                brandList.add(brand);
            });
        }
        HashMap brandConditionParam = Maps.newHashMap();
        brandConditionParam.put("CouponBrandCondition.brands", brandList);
        brandCondition.setConditionParams(JSON.toJSONString((Object)brandConditionParam));
        brandCondition.setConditionTemplateId(MarketingConstant.CONDITION_BRAND_TP_ID);
        conditionList.add(brandCondition);
        ConditionReqDto shopCondition = new ConditionReqDto();
        ArrayList shopList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)couponTemplate.getShopIdList())) {
            couponTemplate.getShopIdList().forEach(shopId -> {
                CouponTemplateShopDto shop = new CouponTemplateShopDto();
                shop.setShopCode(shopId.toString());
                shop.setEffective(Boolean.valueOf(true));
                shopList.add(shop);
            });
        }
        HashMap shopConditionParam = Maps.newHashMap();
        shopConditionParam.put("CouponShopCondition.shopIds", shopList);
        Integer shopRangeType = CollectionUtils.isEmpty((Collection)shopList) ? 10 : 60;
        shopConditionParam.put("CouponShopCondition.shopRangeType", shopRangeType);
        shopCondition.setConditionTemplateId(MarketingConstant.CONDITION_SHOP_TP_ID);
        shopCondition.setConditionParams(JSON.toJSONString((Object)shopConditionParam));
        conditionList.add(shopCondition);
        ConditionReqDto disCountAmount = new ConditionReqDto();
        disCountAmount.setConditionTemplateId(MarketingConstant.CONDITION_COUPON_COUNT_ID);
        disCountAmount.setConditionParams("{}");
        conditionList.add(disCountAmount);
        ConditionReqDto itemCondition = new ConditionReqDto();
        if (CollectionUtils.isNotEmpty((Collection)couponTemplate.getCouponItems())) {
            itemList = couponTemplate.getCouponItems().stream().map(couponItemDto -> {
                ConditionItem item = new ConditionItem();
                item.setItemCode(couponItemDto.getItemId().toString());
                item.setShopId(couponItemDto.getShopId());
                return item;
            }).collect(Collectors.toList());
        } else {
            List<ItemShelfQueryRespDto> items = this.activityService.queryAllItem();
            itemList = items.stream().map(itemShelfQueryRespDto -> {
                ConditionItem item = new ConditionItem();
                item.setItemCode(itemShelfQueryRespDto.getItemId().toString());
                item.setShopId(itemShelfQueryRespDto.getShopId());
                return item;
            }).collect(Collectors.toList());
        }
        HashMap itemConditionParam = Maps.newHashMap();
        itemConditionParam.put("CouponItemsCondition.items", itemList);
        itemCondition.setConditionTemplateId(MarketingConstant.CONDITION_ITEM_TP_ID);
        itemCondition.setConditionParams(JSON.toJSONString((Object)itemConditionParam));
        conditionList.add(itemCondition);
        ConditionReqDto trueCondition = new ConditionReqDto();
        trueCondition.setConditionTemplateId(MarketingConstant.CONDITION_TRUE_ID);
        trueCondition.setConditionParams("{}");
        conditionList.add(trueCondition);
        BigDecimal discountValue = null;
        if (CouponCategoryEnum.DISCOUNT.getCategory().equals(couponTemplate.getCouponCategory())) {
            BigDecimal discountRate = couponTemplate.getCouponValue().divide(BigDecimal.TEN, 2, 4);
            discountValue = BigDecimal.ONE.subtract(discountRate);
        } else {
            discountValue = couponTemplate.getCouponValue();
            if (null == couponTemplate.getAmount()) {
                couponTemplate.setAmount(BigDecimal.ZERO);
            }
        }
        ConditionReqDto amountCondition = new ConditionReqDto();
        HashMap amountConditionParam = Maps.newHashMap();
        ConditionAmount amount = new ConditionAmount();
        amount.setLimitAmount(couponTemplate.getAmount());
        amount.setDiscountValue(discountValue);
        amountConditionParam.put("CouponMoneyOffCondition.type", couponTemplate.getCouponCategory());
        amountConditionParam.put("CouponMoneyOffCondition.condition", amount);
        amountCondition.setConditionTemplateId(MarketingConstant.CONDITION_AMOUNT_TP_ID);
        amountCondition.setConditionParams(JSON.toJSONString((Object)amountConditionParam));
        conditionList.add(amountCondition);
        ConditionReqDto effectiveCondition = new ConditionReqDto();
        effectiveCondition.setConditionTemplateId(MarketingConstant.CONDITION_EFFECTIVE_TP_ID);
        effectiveCondition.setConditionParams("{}");
        conditionList.add(effectiveCondition);
        ConditionReqDto memberCondition = new ConditionReqDto();
        memberCondition.setConditionTemplateId(Long.valueOf(ConditionTemplateType.TARGET_POPULATION.getId()));
        HashMap param = Maps.newHashMap();
        PopulationDto populationDto = couponTemplate.getPopulation();
        if (null == populationDto || null == populationDto.getType()) {
            populationDto = new PopulationDto();
            populationDto.setType(Integer.valueOf(0));
        }
        param.put("PopulationCondition.type", populationDto.getType());
        param.put("PopulationCondition.value", populationDto.getLevelIds());
        memberCondition.setConditionParams(JSON.toJSONString((Object)param));
        conditionList.add(memberCondition);
        ConditionReqDto exchangeItemCondition = new ConditionReqDto();
        ArrayList exchangeItems = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)couponTemplate.getExchangeItems())) {
            couponTemplate.getExchangeItems().forEach(exchangeItem -> exchangeItem.getSkus().forEach(sku -> {
                ExchangeItemDto exItem = new ExchangeItemDto();
                exItem.setItemId(exchangeItem.getItemId());
                exItem.setShopId(exchangeItem.getShopId());
                exItem.setSkuId(sku.getSkuId());
                exItem.setExchangeNum(sku.getExchangeNum());
                exchangeItems.add(exItem);
            }));
        }
        HashMap exchangeItemConditionParam = Maps.newHashMap();
        exchangeItemConditionParam.put("ExchangeItemCondition.items", exchangeItems);
        exchangeItemCondition.setConditionTemplateId(MarketingConstant.EXCHANGE_ITEM_TP_ID);
        exchangeItemCondition.setConditionParams(JSON.toJSONString((Object)exchangeItemConditionParam));
        conditionList.add(exchangeItemCondition);
        ConditionReqDto receiveCondition = new ConditionReqDto();
        HashMap receiveConditionParam = Maps.newHashMap();
        ReceiveRuleDto receiveRuleDto = new ReceiveRuleDto();
        receiveRuleDto.setPoint(couponTemplate.getSendPoint());
        receiveRuleDto.setType(Integer.valueOf(couponTemplate.getSendPoint() == null ? 0 : 1));
        receiveConditionParam.put("ReceiveCondition.rule", receiveRuleDto);
        receiveCondition.setConditionTemplateId(MarketingConstant.RECEIVE_TP_ID);
        receiveCondition.setConditionParams(JSON.toJSONString((Object)receiveConditionParam));
        conditionList.add(receiveCondition);
        ConditionReqDto couponGift = new ConditionReqDto();
        couponGift.setConditionTemplateId(Long.valueOf(1096944771412880289L));
        couponGift.setConditionParams("{}");
        ConditionReqDto couponPieceGift = new ConditionReqDto();
        couponPieceGift.setConditionTemplateId(Long.valueOf(1096944771412880290L));
        couponPieceGift.setConditionParams("{}");
        conditionList.add(couponGift);
        conditionList.add(couponPieceGift);
        ConditionReqDto mutex = new ConditionReqDto();
        mutex.setConditionTemplateId(Long.valueOf(1196944771412880280L));
        mutex.setConditionParams("{}");
        conditionList.add(mutex);
        return conditionList;
    }

    @Override
    public PageInfo<CouponTemplate> query(CouponTemplate couponTemplate, Integer pageNum, Integer pageSize) {
        PageInfo result = new PageInfo();
        List<SqlFilter> sqlFilters = this.getSqlFilters(couponTemplate);
        Criteria criteria = new Criteria();
        criteria.setFilters(sqlFilters);
        criteria.setInstanceId(this.context.instanceId());
        criteria.setTenantId(this.context.tenantId());
        criteria.setOrderByDesc("createTime");
        String filter = JSON.toJSONString((Object)criteria);
        logger.info("\u67e5\u8be2\u4f18\u60e0\u5238\u6a21\u677f\u53c2\u6570\uff1a{}", (Object)filter);
        PageInfo pageInfo = (PageInfo)this.couponTemplateExtQueryApi.queryByPage(filter, pageNum, pageSize).getData();
        if (null == pageInfo) {
            return result;
        }
        BeanUtils.copyProperties((Object)pageInfo, (Object)result);
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return result;
        }
        List list = pageInfo.getList().stream().map(couponTemplateExtRespDto -> {
            CouponTemplate template = new CouponTemplate();
            BeanUtils.copyProperties((Object)couponTemplateExtRespDto, (Object)template);
            template.setCouponUseBeginTime(couponTemplateExtRespDto.getEffectiveTime());
            template.setCouponUseEndTime(couponTemplateExtRespDto.getInvalidTime());
            CouponTemplateExtDto couponTemplateExtDto = (CouponTemplateExtDto)ObjectHelper.Json2Bean((String)couponTemplateExtRespDto.getExtension(), CouponTemplateExtDto.class);
            if (null != couponTemplateExtDto) {
                template.setCollectionMethod(couponTemplateExtDto.getCollectionMethod());
                template.setForPeople(couponTemplateExtDto.getForPeople());
            }
            String tag = this.getTag(couponTemplateExtRespDto.getActivityId());
            template.setTag(tag);
            return template;
        }).collect(Collectors.toList());
        result.setList(list);
        return result;
    }

    private void trans2UseTimeDtoList(List<CouponTemplate> list) {
        if (null == list || list.isEmpty()) {
            return;
        }
        list.stream().forEach(o -> this.trans2UseTimeDto((CouponTemplate)o));
    }

    private void trans2UseTimeDto(CouponTemplate couponTemplate) {
        SerializeCouPonUseTimeValueDistribute.deserialization(couponTemplate);
    }

    @Override
    public PageInfo<CouponTemplate> queryWithActivity(CouponTemplate couponTemplate, Integer pageNum, Integer pageSize) {
        CouponTemplateQueryReqDto queryReqDto = new CouponTemplateQueryReqDto();
        if (null != couponTemplate) {
            CubeBeanUtils.copyProperties((Object)queryReqDto, (Object)couponTemplate, (String[])new String[0]);
            QueryCouponTpStatusEnum couponTpStatusEnum = QueryCouponTpStatusEnum.getByStatus(couponTemplate.getCouponTemplateStatus());
            if (null != couponTpStatusEnum) {
                queryReqDto.setCouponTemplateStatus(couponTpStatusEnum.getCouponTemplateStatus());
                queryReqDto.setAuditStatus(couponTpStatusEnum.getAuditStatus());
            }
            if (CollectionMethodEnum.PUBLIC.getKey().equals(couponTemplate.getCollectionMethod())) {
                queryReqDto.setCouponType(CouponTypeEnum.COUPON.getType());
            } else if (CollectionMethodEnum.PRIVATE.getKey().equals(couponTemplate.getCollectionMethod())) {
                queryReqDto.setCouponType(CouponTypeEnum.COUPON_PUSHED.getType());
            }
            if (couponTemplate.getCouponCategory() == null) {
                ArrayList categoryList = Lists.newArrayList((Object[])new Integer[]{CouponCategoryEnum.QUOTA_CASH.getCategory(), CouponCategoryEnum.DISCOUNT.getCategory()});
                queryReqDto.setCouponCategoryList((List)categoryList);
            }
        }
        queryReqDto.setInstanceId(this.context.instanceId());
        queryReqDto.setTenantId(this.context.tenantId());
        PageInfo pageInfo = (PageInfo)this.couponTemplateExtQueryApi.queryWithActivity(queryReqDto, pageNum, pageSize).getData();
        PageInfo result = new PageInfo();
        List<Object> list = Lists.newArrayList();
        if (PageInfoUtil.isNotEmpty(pageInfo)) {
            list = pageInfo.getList().stream().map(template -> {
                ActivityRespDto activityRespDto;
                CouponTemplate couponTp = new CouponTemplate();
                CubeBeanUtils.copyProperties((Object)couponTp, (Object)template, (String[])new String[0]);
                couponTp.setCouponUseBeginTime(template.getEffectiveTime());
                couponTp.setCouponUseEndTime(template.getInvalidTime());
                couponTp.setCouponTemplateStatus(QueryCouponTpStatusEnum.getStatus(template.getCouponTemplateStatus(), template.getAuditStatus()));
                if (CouponTypeEnum.COUPON.getType().equals(template.getCouponType())) {
                    couponTp.setCollectionMethod(CollectionMethodEnum.PUBLIC.getKey());
                } else if (CouponTypeEnum.COUPON_PUSHED.getType().equals(template.getCouponType())) {
                    couponTp.setCollectionMethod(CollectionMethodEnum.PRIVATE.getKey());
                }
                if (CouponCategoryEnum.EXTRACT.getCategory().equals(template.getCouponCategory()) && null != (activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(template.getActivityId().longValue()).getData())) {
                    ReceiveCondition receiveCondition = new ReceiveCondition();
                    CouponTemplateDetailRespDto detail = new CouponTemplateDetailRespDto();
                    receiveCondition.parseCondition(activityRespDto.getConditionDtos(), detail);
                    couponTp.setSendPoint(detail.getSendPoint());
                }
                return couponTp;
            }).collect(Collectors.toList());
        }
        BeanUtils.copyProperties((Object)pageInfo, (Object)result);
        this.trans2UseTimeDtoList(list);
        result.setList((List)list);
        return result;
    }

    private String getTag(Long activityId) {
        try {
            ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityDetail(activityId.longValue()).getData();
            return activityRespDto.getTag();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List<SqlFilter> getSqlFilters(CouponTemplate couponTemplate) {
        ArrayList sqlFilterList = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)couponTemplate.getCouponTemplateStatus())) {
            sqlFilterList.add(SqlFilter.eq((String)"coupon_template_status", (Object)couponTemplate.getCouponTemplateStatus()));
        }
        if (null != couponTemplate.getCollectionMethod()) {
            String couponType = null;
            if (CollectionMethodEnum.PUBLIC.getKey().equals(couponTemplate.getCollectionMethod())) {
                couponType = CouponTypeEnum.COUPON.getType();
            } else if (CollectionMethodEnum.PRIVATE.getKey().equals(couponTemplate.getCollectionMethod())) {
                couponType = CouponTypeEnum.COUPON_PUSHED.getType();
            }
            sqlFilterList.add(SqlFilter.eq((String)"coupon_type", (Object)couponType));
        }
        if (StringUtils.isNotBlank((CharSequence)couponTemplate.getCouponName())) {
            sqlFilterList.add(SqlFilter.like((String)"coupon_name", (Object)(couponTemplate.getCouponName() + "%")));
        }
        if (StringUtils.isNotBlank((CharSequence)couponTemplate.getCouponCode())) {
            sqlFilterList.add(SqlFilter.like((String)"coupon_code", (Object)(couponTemplate.getCouponCode() + "%")));
        }
        if (null != couponTemplate.getCouponRange()) {
            sqlFilterList.add(SqlFilter.like((String)"coupon_range", (Object)couponTemplate.getCouponRange()));
        }
        if (null != couponTemplate.getCouponCategory()) {
            sqlFilterList.add(SqlFilter.eq((String)"coupon_category", (Object)couponTemplate.getCouponCategory()));
        } else {
            ArrayList categoryList = Lists.newArrayList((Object[])new Integer[]{CouponCategoryEnum.QUOTA_CASH.getCategory(), CouponCategoryEnum.DISCOUNT.getCategory()});
            sqlFilterList.add(SqlFilter.in((String)"coupon_category", (Object)categoryList));
        }
        return sqlFilterList;
    }

    @Override
    public CouponTemplateDetailRespDto getDetail(Long id) {
        List brandIdList;
        Object brandIds;
        List brandRespDtoList;
        String dirIds;
        List dirList;
        Set shopIds;
        List shopDtoList;
        CouponTemplateExtRespDto couponTemplateExtRespDto = (CouponTemplateExtRespDto)RestResponseHelper.extractData((RestResponse)this.couponTemplateExtQueryApi.queryById(id));
        if (null == couponTemplateExtRespDto) {
            return null;
        }
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(couponTemplateExtRespDto.getActivityId().longValue()).getData();
        if (activityRespDto == null) {
            return null;
        }
        CouponTemplateDetailRespDto detail = new CouponTemplateDetailRespDto();
        BeanUtils.copyProperties((Object)couponTemplateExtRespDto, (Object)detail);
        detail.setCouponUseBeginTime(couponTemplateExtRespDto.getEffectiveTime());
        detail.setCouponUseEndTime(couponTemplateExtRespDto.getInvalidTime());
        CouponTemplateExtDto couponTemplateExtDto = (CouponTemplateExtDto)JSON.parseObject((String)couponTemplateExtRespDto.getExtension(), CouponTemplateExtDto.class);
        detail.setSharedDiscountList(couponTemplateExtDto.getSharedDiscountList());
        detail.setForPeople(couponTemplateExtDto.getForPeople());
        detail.setCollectionMethod(couponTemplateExtDto.getCollectionMethod());
        detail.setDailyLimitNum(couponTemplateExtDto.getDailyLimitNum());
        detail.setLimitNum(couponTemplateExtDto.getLimitNum());
        if (CollectionUtils.isNotEmpty((Collection)couponTemplateExtRespDto.getCouponShopList()) && CollectionUtils.isNotEmpty((Collection)(shopDtoList = (List)this.shopQueryApi.queryBaseListByIds(shopIds = couponTemplateExtRespDto.getCouponShopList().stream().map(couponTemplateShopDto -> Long.valueOf(couponTemplateShopDto.getShopCode())).collect(Collectors.toSet())).getData()))) {
            ArrayList shopList = new ArrayList();
            CubeBeanUtils.copyCollection(shopList, (Collection)shopDtoList, CouponShopBaseDto.class);
            detail.setShopList(shopList);
        }
        if (CollectionUtils.isNotEmpty((Collection)couponTemplateExtRespDto.getCouponTemplateCatalogDtoList()) && CollectionUtils.isNotEmpty((Collection)(dirList = (List)this.directoryQueryApi.queryDirByIds(dirIds = StringUtils.join((Iterable)couponTemplateExtRespDto.getCouponTemplateCatalogDtoList(), (String)",")).getData()))) {
            ArrayList couponDirRespDtos = new ArrayList();
            CubeBeanUtils.copyCollection(couponDirRespDtos, (Collection)dirList, CouponDirRespDto.class);
            detail.setDirList(couponDirRespDtos);
        }
        if (CollectionUtils.isNotEmpty((Collection)couponTemplateExtRespDto.getCouponTemplateBrandDtoList()) && CollectionUtils.isNotEmpty((Collection)(brandRespDtoList = (List)this.brandQueryApi.queryByIds((String)(brandIds = StringUtils.join(brandIdList = couponTemplateExtRespDto.getCouponTemplateBrandDtoList().stream().map(CouponTemplateBrandDto::getBrandId).collect(Collectors.toList()), (String)","))).getData()))) {
            ArrayList brandList = new ArrayList();
            CubeBeanUtils.copyCollection(brandList, (Collection)brandRespDtoList, CouponBrandRespDto.class);
            detail.setBrandList(brandList);
        }
        List<ConditionTemplate> templateList = ActivityFactory.getActivityTemplate(ActivityType.COUPON_ACTIVITY);
        for (ConditionTemplate conditionTemplate : templateList) {
            if (conditionTemplate instanceof CouponItemCondition && !CouponItemRange.ITEM.getKey().equals(couponTemplateExtRespDto.getItemRange())) break;
            conditionTemplate.parseCondition(activityRespDto.getConditionDtos(), detail);
        }
        CouponReqDto couponReqDto = new CouponReqDto();
        couponReqDto.setCouponTemplateId(id);
        Integer receivedQuantity = (Integer)this.couponExtQueryApi.countCouponNum(couponReqDto).getData();
        couponReqDto.setCouponStatus(CouponStatusEnum.STOP.getStatus());
        Integer usedQuantity = (Integer)this.couponExtQueryApi.countCouponNum(couponReqDto).getData();
        detail.setReceivedQuantity(receivedQuantity);
        detail.setUsedQuantity(usedQuantity);
        String tag = this.getTag(couponTemplateExtRespDto.getActivityId());
        detail.setTag(tag);
        detail.setOrganizationIds((List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryAllSuperiorOrgIdList()));
        this.trans2UseTimeDto((CouponTemplate)detail);
        return detail;
    }

    @Override
    public void enable(Long id) {
        CouponTemplateExtRespDto couponTemplateExtRespDto = (CouponTemplateExtRespDto)this.couponTemplateExtQueryApi.queryById(id).getData();
        if (null == couponTemplateExtRespDto) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_TP_NOT_EXIST);
        }
        RestResponse restResponse = null;
        restResponse = CouponTemplateStatusEnum.CREATE.getStatus().equals(couponTemplateExtRespDto.getCouponTemplateStatus()) ? this.couponTemplateExtApi.batchActivate((List)Lists.newArrayList((Object[])new Long[]{id})) : this.couponTemplateExtApi.setStatus(id, CouponTemplateStatusEnum.ACTIVATE.getStatus());
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
    }

    @Override
    public void disable(Long id) {
        RestResponse restResponse = this.couponTemplateExtApi.setStatus(id, CouponTemplateStatusEnum.STOP.getStatus());
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
    }

    @Override
    public void invalid(String ids) {
        String[] idArr = StringUtils.split((String)ids.trim(), (String)",");
        for (int i = 0; i < idArr.length; ++i) {
            RestResponse restResponse = this.couponTemplateExtApi.invalid(Long.valueOf(idArr[i]));
            RestResponseHelper.checkOrThrow((RestResponse)restResponse);
        }
    }

    @Override
    public void grant(CouponGrantReqDto couponGrantReqDto) {
        if (CollectionUtils.isEmpty((Collection)couponGrantReqDto.getMemberIdList())) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.GRANT_MEMBER_NOT_NULL);
        }
        RestResponse templateResponse = this.couponTemplateExtQueryApi.queryById(couponGrantReqDto.getTemplateId());
        CouponTemplateExtRespDto template = (CouponTemplateExtRespDto)RestResponseHelper.extractData((RestResponse)templateResponse);
        Integer grantTotalNum = couponGrantReqDto.getGrantNum() * couponGrantReqDto.getMemberIdList().size();
        if ((long)grantTotalNum.intValue() > template.getRemainingQuantity()) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.GRANT_NUM_GT_THAN_STOCK);
        }
        CouponSendTemplateReqDto couponSendTemplateReqDto = new CouponSendTemplateReqDto();
        couponSendTemplateReqDto.setCouponTemplateId(couponGrantReqDto.getTemplateId());
        couponSendTemplateReqDto.setSendNum(couponGrantReqDto.getGrantNum());
        CouponBatchSendReqDto couponBatchSendReqDto = new CouponBatchSendReqDto();
        couponBatchSendReqDto.setMemberIds(couponGrantReqDto.getMemberIdList());
        couponBatchSendReqDto.setIsValidate(false);
        couponBatchSendReqDto.setCheckPointCode("IC_RECEIVE_COUPON");
        couponBatchSendReqDto.setTemplates((List)Lists.newArrayList((Object[])new CouponSendTemplateReqDto[]{couponSendTemplateReqDto}));
        RestResponse restResponse = this.couponExtApi.pushCoupon(couponBatchSendReqDto);
        CouponPushRespDto couponPushRespDto = (CouponPushRespDto)RestResponseHelper.extractData((RestResponse)restResponse);
        if (couponPushRespDto.getFailNum() > 0) {
            CouponPushErrorDto errMsg = couponPushRespDto.getFailData().stream().filter(couponPushErrorDto -> couponGrantReqDto.getTemplateId().equals(couponPushErrorDto.getCouponTemplateId())).findFirst().orElseGet(() -> null);
            if (null == errMsg) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.GRANT_COUPON_FAIL);
            } else {
                BizExceptionHelper.throwBizException((String)errMsg.getErrorCode(), (String)errMsg.getErrorMsg());
            }
        }
    }

    @Override
    public PageInfo<CouponExtRespDto> queryReceiveRecord(CouponReqDto couponReqDto, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo = new PageInfo();
        ArrayList sqlFilterList = Lists.newArrayList();
        String phone = couponReqDto.getUserPhone();
        if (StringUtils.isNotBlank((CharSequence)phone)) {
            MemberInfoDetailRespDto memberInfoDetailDto = (MemberInfoDetailRespDto)this.memberInfoExtQueryApi.queryMemberInfoDetailByPhone(couponReqDto.getUserPhone()).getData();
            if (null == memberInfoDetailDto) {
                return pageInfo;
            }
            sqlFilterList.add(SqlFilter.eq((String)"user_id", (Object)memberInfoDetailDto.getId()));
        }
        if (null != couponReqDto.getReceiveTimeBegin()) {
            String receiveTimeBegin = DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)couponReqDto.getReceiveTimeBegin());
            sqlFilterList.add(SqlFilter.ge((String)"receive_time", (Object)receiveTimeBegin));
        }
        if (null != couponReqDto.getReceiveTimeEnd()) {
            String receiveTimeEnd = DateUtil.formatDate((DatePattern)DatePattern.DATETIME_PATTERN, (Date)couponReqDto.getReceiveTimeEnd());
            sqlFilterList.add(SqlFilter.le((String)"receive_time", (Object)receiveTimeEnd));
        }
        if (StringUtils.isNotBlank((CharSequence)couponReqDto.getCouponStatus())) {
            sqlFilterList.add(SqlFilter.eq((String)"coupon_status", (Object)couponReqDto.getCouponStatus()));
        }
        sqlFilterList.add(SqlFilter.eq((String)"coupon_template_id", (Object)couponReqDto.getCouponTemplateId()));
        Criteria criteria = new Criteria();
        criteria.setFilters((List)sqlFilterList);
        String filter = ObjectHelper.bean2Json((Object)criteria);
        pageInfo = (PageInfo)this.couponExtQueryApi.queryByPage(filter, pageNum, pageSize).getData();
        if (null == pageInfo || CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return pageInfo;
        }
        pageInfo.getList().forEach(couponExtRespDto -> {
            if (StringUtils.isBlank((CharSequence)phone)) {
                MemberInfoDetailRespDto memberInfoDetailRespDto = (MemberInfoDetailRespDto)this.memberInfoExtQueryApi.queryMemberInfoDetail(couponExtRespDto.getUserId()).getData();
                if (null != memberInfoDetailRespDto) {
                    couponExtRespDto.setReceivePhone(memberInfoDetailRespDto.getMemberInfoRespDto().getPhone());
                }
            } else {
                couponExtRespDto.setReceivePhone(phone);
            }
        });
        return pageInfo;
    }

    @Override
    public PageInfo<CouponTemplate> platFormcouponGather(CouponTemplateExtQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        Criteria criteria = this.getCouponTemplateReqDto(queryReqDto);
        PageInfo couponTemplatePage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.couponTemplateExtQueryApi.queryByPage(JSON.toJSONString((Object)criteria), pageNum, pageSize));
        PageInfo<CouponTemplate> pageInfo = this.convertToCouponTemplatePage((PageInfo<CouponTemplateExtRespDto>)couponTemplatePage);
        this.trans2UseTimeDtoList(pageInfo.getList());
        return pageInfo;
    }

    private Criteria getCouponTemplateReqDto(CouponTemplateExtQueryReqDto queryReqDto) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.eq((String)"coupon_template_status", (Object)"20"));
        if (queryReqDto.getCouponRange() != null) {
            sqlFilterList.add(SqlFilter.eq((String)"coupon_range", (Object)queryReqDto.getCouponRange()));
        }
        sqlFilterList.add(SqlFilter.ge((String)"receive_end_time", (Object)dateFormat.format(new Date())));
        logger.info("\u67e5\u8be2\u4f18\u60e0\u5238\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)queryReqDto));
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getCouponTemplateIds())) {
            String[] idArr = StringUtils.split((String)queryReqDto.getCouponTemplateIds().trim(), (String)",");
            sqlFilterList.add(SqlFilter.in((String)"id", (Object)idArr));
        }
        Criteria criteria = new Criteria();
        criteria.setFilters(sqlFilterList);
        criteria.setInstanceId(this.context.instanceId());
        criteria.setTenantId(this.context.tenantId());
        return criteria;
    }

    private PageInfo<CouponTemplate> convertToCouponTemplatePage(PageInfo<CouponTemplateExtRespDto> couponTemplatePage) {
        PageInfo pageInfo = new PageInfo();
        BeanUtils.copyProperties(couponTemplatePage, (Object)pageInfo);
        CouponTemplate couponTemplate = null;
        ArrayList<CouponTemplate> couponTemplateList = new ArrayList<CouponTemplate>();
        if (CollectionUtils.isNotEmpty((Collection)couponTemplatePage.getList())) {
            ArrayList activityIds = Lists.newArrayList();
            for (CouponTemplateExtRespDto templateExtRespDto : couponTemplatePage.getList()) {
                couponTemplate = new CouponTemplate();
                CubeBeanUtils.copyProperties((Object)couponTemplate, (Object)templateExtRespDto, (String[])new String[0]);
                couponTemplate.setCouponUseBeginTime(templateExtRespDto.getEffectiveTime());
                couponTemplate.setCouponUseEndTime(templateExtRespDto.getInvalidTime());
                couponTemplate.setTag(templateExtRespDto.getActivityTag());
                activityIds.add(templateExtRespDto.getActivityId());
                couponTemplateList.add(couponTemplate);
            }
        }
        pageInfo.setList(couponTemplateList);
        return pageInfo;
    }

    @Override
    public List<CouponTemplate> couponGather(String shopId) {
        ShopBaseDto shopDto = (ShopBaseDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryBaseById(Long.valueOf(shopId)));
        if (shopDto == null) {
            throw new BizException("\u67e5\u8be2\u4e0d\u5230\u5e97\u94fa\u4fe1\u606f");
        }
        CouponTemplate couponTemplate = null;
        ArrayList<CouponTemplate> resultList = new ArrayList<CouponTemplate>();
        CouponTemplateExtQueryReqDto queryReqDto = new CouponTemplateExtQueryReqDto();
        queryReqDto.setCouponRange(CouponTemplateConstant.SHOP_COUPON);
        Criteria criteria = this.getCouponTemplateReqDto(queryReqDto);
        criteria.getFilters().add(SqlFilter.eq((String)"seller_id", (Object)shopDto.getSellerId()));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.couponTemplateExtQueryApi.queryByPage(JSON.toJSONString((Object)criteria), Integer.valueOf(1), Integer.valueOf(1)));
        int total = (int)pageInfo.getTotal();
        int count = total % 100 == 0 ? total / 100 : total / 100 + 1;
        for (int pageNum = 1; pageNum <= count; ++pageNum) {
            pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.couponTemplateExtQueryApi.queryByPage(JSON.toJSONString((Object)criteria), Integer.valueOf(pageNum), Integer.valueOf(100)));
            if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) continue;
            for (CouponTemplateExtRespDto couponExtDto : pageInfo.getList()) {
                if (!this.validBelongShop(shopId, couponExtDto.getId())) continue;
                couponTemplate = new CouponTemplate();
                CubeBeanUtils.copyProperties((Object)couponTemplate, (Object)couponExtDto, (String[])new String[0]);
                couponTemplate.setCouponUseBeginTime(couponExtDto.getEffectiveTime());
                couponTemplate.setCouponUseEndTime(couponExtDto.getInvalidTime());
                resultList.add(couponTemplate);
            }
        }
        this.trans2UseTimeDtoList(resultList);
        return resultList;
    }

    private boolean validBelongShop(String shopId, Long templateId) {
        CouponTemplateExtRespDto templateExtRespDto = (CouponTemplateExtRespDto)RestResponseHelper.extractData((RestResponse)this.couponTemplateExtQueryApi.queryById(templateId));
        if (templateExtRespDto != null && CollectionUtils.isNotEmpty((Collection)templateExtRespDto.getCouponShopList())) {
            for (CouponTemplateShopDto templateShopDto : templateExtRespDto.getCouponShopList()) {
                if (!shopId.equals(templateShopDto.getShopCode())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PageInfo<CouponRespDto> queryCouponPage(Integer pageNum, Integer pageSize) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        Long memberId = this.marketingModuleHelper.getMemberIdByContext();
        sqlFilterList.add(SqlFilter.eq((String)"user_id", (Object)memberId));
        sqlFilterList.add(SqlFilter.ge((String)"invalid_time", (Object)dateFormat.format(new Date())));
        sqlFilterList.add(SqlFilter.eq((String)"coupon_status", (Object)"10"));
        Criteria criteria = new Criteria();
        criteria.setFilters(sqlFilterList);
        criteria.setInstanceId(this.context.instanceId());
        criteria.setTenantId(this.context.tenantId());
        criteria.setOrderByDesc("id");
        PageInfo couponExtPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.couponExtQueryApi.queryByPage(JSON.toJSONString((Object)criteria), pageNum, pageSize));
        if (CollectionUtils.isNotEmpty((Collection)couponExtPageInfo.getList())) {
            couponExtPageInfo.setList(couponExtPageInfo.getList().stream().filter(couponExtRespDto -> !couponExtRespDto.getCouponTemplate().getCouponTemplateStatus().equals("40")).collect(Collectors.toList()));
        }
        PageInfo<CouponRespDto> pageInfo = this.convertToCouponPage((PageInfo<CouponExtRespDto>)couponExtPageInfo);
        return pageInfo;
    }

    private void setCouponUseTimeDto(CouponRespDto couponRespDto, CouponExtRespDto couponExtRespDto) {
        if (couponRespDto == null) {
            return;
        }
        if (couponExtRespDto == null) {
            return;
        }
        CouponUseTimeDto couponUseTimeDto = new CouponUseTimeDto();
        JSONObject value = new JSONObject();
        value.put("couponUseBeginTime", (Object)couponRespDto.getCouponUseBeginTime());
        value.put("couponUseEndTime", (Object)couponExtRespDto.getInvalidTime());
        couponUseTimeDto.setValue((Object)value);
        if (couponExtRespDto.getValidityType() == CouponValidityTypeEnum.FOREVER_DATE.getType()) {
            couponUseTimeDto.setType(Integer.valueOf(3));
        } else {
            couponUseTimeDto.setType(Integer.valueOf(0));
        }
        couponRespDto.setCouponUseTimeDto(couponUseTimeDto);
    }

    private PageInfo<CouponRespDto> convertToCouponPage(PageInfo<CouponExtRespDto> couponExtPageInfo) {
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, couponExtPageInfo, (String[])new String[]{"navigatepageNums", "list"});
        CouponRespDto couponRespDto = null;
        ArrayList<CouponRespDto> couponList = new ArrayList<CouponRespDto>();
        List couuponExtList = couponExtPageInfo.getList();
        if (CollectionUtils.isNotEmpty((Collection)couuponExtList)) {
            for (CouponExtRespDto couponExtRespDto : couuponExtList) {
                CouponTemplateExtRespDto template = couponExtRespDto.getCouponTemplate();
                if (template == null) continue;
                couponRespDto = new CouponRespDto();
                CubeBeanUtils.copyProperties((Object)couponRespDto, (Object)template, (String[])new String[]{"id"});
                couponRespDto.setId(couponExtRespDto.getId());
                couponRespDto.setCouponTemplateId(couponExtRespDto.getCouponTemplateId());
                couponRespDto.setCouponCategory(template.getCouponCategory());
                couponRespDto.setCouponUseBeginTime(couponExtRespDto.getEffectiveTime());
                couponRespDto.setCouponUseEndTime(couponExtRespDto.getInvalidTime());
                this.setCouponUseTimeDto(couponRespDto, couponExtRespDto);
                couponRespDto.setTag(template.getActivityTag());
                couponList.add(couponRespDto);
            }
        }
        pageInfo.setList(couponList);
        return pageInfo;
    }

    @Override
    public CouponPushRespDto receiveCoupon(Long couponTemplateId) {
        CouponPushRespDto couponPushDto;
        CouponBatchSendReqDto example = new CouponBatchSendReqDto();
        example.setIsValidate(false);
        ArrayList<Long> memberIds = new ArrayList<Long>();
        memberIds.add(this.marketingModuleHelper.getMemberIdByContext());
        example.setMemberIds(memberIds);
        ArrayList<CouponSendTemplateReqDto> couponSendReqDtoList = new ArrayList<CouponSendTemplateReqDto>();
        CouponSendTemplateReqDto couponSendDto = new CouponSendTemplateReqDto();
        couponSendDto.setCouponTemplateId(couponTemplateId);
        couponSendDto.setSendNum(Integer.valueOf(1));
        couponSendReqDtoList.add(couponSendDto);
        example.setTemplates(couponSendReqDtoList);
        example.setCheckPointCode("IC_RECEIVE_COUPON");
        example.setReturnSucess(Integer.valueOf(1));
        RestResponse restResponse = this.couponExtApi.reviceCoupon2C(example);
        if (restResponse.getResultCode().equals(CouponTemplateErrorEnum.COUPON_TEMPLATE_NOT_ACTIVATE.getCode())) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_INVENTORY_LACK);
        }
        if ((couponPushDto = (CouponPushRespDto)RestResponseHelper.extractData((RestResponse)restResponse)) != null && CollectionUtils.isNotEmpty((Collection)couponPushDto.getFailData())) {
            CouponPushErrorDto errorDto = (CouponPushErrorDto)couponPushDto.getFailData().get(0);
            if (CouponTemplateErrorEnum.COUPON_TEMPLATE_NOT_ACTIVATE.getCode().equals(errorDto.getErrorCode())) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.COUPON_INVENTORY_LACK);
            } else if (CouponTemplateErrorEnum.OUPON_TEMPLATE_RECEIVE_NUM_INSUFFICIENT.getCode().equals(errorDto.getErrorCode())) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.RECEIVE_NUM_LIMIT);
            } else if (CouponTemplateErrorEnum.COUPON_TEMPLATE_IS_EXPIRE.getCode().equals(errorDto.getErrorCode())) {
                BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.RECEIVE_TIME_INVALID);
            } else {
                if (CouponTemplateErrorEnum.COUPON_BEFORE_RECEIVE_START_TIME.getCode().equals(errorDto.getErrorCode())) {
                    String msg = "\u8fd8\u672a\u5230\u9886\u53d6\u65f6\u95f4";
                    throw new BizException(msg);
                }
                throw new BizException(errorDto.getErrorCode(), errorDto.getErrorMsg());
            }
        }
        return couponPushDto;
    }

    private CouponTemplateExtRespDto validReceiveTime(Long couponTemplateId) {
        CouponTemplateExtRespDto templateExtRespDto = (CouponTemplateExtRespDto)RestResponseHelper.extractData((RestResponse)this.couponTemplateExtQueryApi.queryById(couponTemplateId));
        Date startTime = templateExtRespDto.getReceiveStartTime();
        Date endTime = templateExtRespDto.getReceiveEndTime();
        if (endTime.compareTo(new Date()) < 0) {
            BizExceptionHelper.throwBizException((IExceptionCode)MarketingModuleExcpCode.RECEIVE_TIME_INVALID);
        }
        return templateExtRespDto;
    }

    @Override
    public List<CouponTemplate> queryByActivityIds(List<Long> activityIds) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.ge((String)"receive_end_time", (Object)dateFormat.format(new Date())));
        sqlFilterList.add(SqlFilter.in((String)"activity_id", activityIds));
        sqlFilterList.add(SqlFilter.eq((String)"coupon_type", (Object)CouponTypeEnum.COUPON.getType()));
        Criteria criteria = new Criteria();
        criteria.setFilters(sqlFilterList);
        criteria.setInstanceId(this.context.instanceId());
        criteria.setTenantId(this.context.tenantId());
        PageInfo couponTpPage = (PageInfo)this.couponTemplateExtQueryApi.queryByPage(JSON.toJSONString((Object)criteria), Integer.valueOf(1), Integer.valueOf(activityIds.size())).getData();
        PageInfo<CouponTemplate> pageInfo = this.convertToCouponTemplatePage((PageInfo<CouponTemplateExtRespDto>)couponTpPage);
        this.trans2UseTimeDtoList(pageInfo.getList());
        return pageInfo.getList();
    }

    @Override
    public List<CouponTemplate> queryByIds(List<Long> ids) {
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"id", ids));
        Criteria criteria = new Criteria();
        criteria.setFilters(sqlFilterList);
        criteria.setInstanceId(this.context.instanceId());
        criteria.setTenantId(this.context.tenantId());
        PageInfo couponTpPage = (PageInfo)this.couponTemplateExtQueryApi.queryByPage(JSON.toJSONString((Object)criteria), Integer.valueOf(1), Integer.valueOf(ids.size())).getData();
        PageInfo<CouponTemplate> pageInfo = this.convertToCouponTemplatePage((PageInfo<CouponTemplateExtRespDto>)couponTpPage);
        this.trans2UseTimeDtoList(pageInfo.getList());
        return pageInfo.getList();
    }
}

