/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.combination.condition;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.ComItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.combination.model.CombinationRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.DiscountAmount;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.utils.CalcUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinationCondition
extends ConditionTemplate {
    private static Logger logger = LoggerFactory.getLogger(CombinationCondition.class);
    private static final String PARAMS_NAME = "CombinationCondition.rule";
    @Resource
    private IActivityService activityService;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T params, Map<String, ?> activityParams) {
        boolean meet = false;
        logger.info("\u4f18\u60e0\u5957\u88c5\u6d3b\u52a8execute:{}", (Object)JSON.toJSONString(params));
        Param param = define.getParam(PARAMS_NAME);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u4f18\u60e0\u5957\u88c5\u6d3b\u52a8\u6761\u4ef6\u672a\u914d\u7f6e"}));
        }
        CombinationRule combinationRule = (CombinationRule)ConditionTemplate.converter(activityParams.get(PARAMS_NAME), param, define.getLoadClass());
        List comItemDtos = combinationRule.getComRuleContent().getCombinationItems();
        List<ItemVo> combinationItems = params.getItems().stream().filter(itemVo -> itemVo.getIsCombinedPackage() == 1).filter(itemVo -> itemVo.getCombinedPackageActivityId().longValue() == params.getActivityId()).collect(Collectors.toList());
        boolean isCheck = this.matchCombination(comItemDtos, combinationItems);
        logger.info("\u53c2\u4e0e\u6d3b\u52a8:{},\u89c4\u5219\u548c\u5546\u54c1\u5339\u914d\u7ed3\u679c:{}", (Object)params.getActivityId(), (Object)isCheck);
        logger.info("\u4f18\u60e0\u5957\u88c5\u89c4\u5219\u4fe1\u606f:{},\u4f18\u60e0\u5957\u88c5\u5339\u914d\u5546\u54c1:{}", (Object)JSON.toJSONString((Object)combinationRule), (Object)JSON.toJSONString(combinationItems));
        if (!isCheck) {
            return false;
        }
        if (CollectionUtils.isNotEmpty(combinationItems)) {
            BigDecimal discountAmountNum = BigDecimal.ZERO;
            if (combinationRule.getThresholdType() == 0) {
                ComItemDto comItemDto = (ComItemDto)comItemDtos.stream().findFirst().get();
                ItemVo item = combinationItems.stream().filter(vo -> vo.getItemId().equals(comItemDto.getItemId().toString())).findFirst().orElse(null);
                if (Objects.nonNull(item)) {
                    BigDecimal num = new BigDecimal(item.getNum()).divide(new BigDecimal(comItemDto.getCombinationNum()));
                    BigDecimal originalAmount = combinationItems.stream().map(itemVo -> itemVo.getOrigPrice().multiply(new BigDecimal(itemVo.getNum()))).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal combinationPrice = combinationRule.getComRuleContent().getTotalPrice().multiply(num);
                    discountAmountNum = originalAmount.subtract(combinationPrice);
                    logger.info("\u8ba1\u7b97\u4f18\u60e0\u91d1\u989d\u524d:{}", (Object)params.getTotalDiscountAmount());
                    params.setTotalDiscountAmount(params.getTotalDiscountAmount().add(discountAmountNum));
                    logger.info("\u8ba1\u7b97\u4f18\u60e0\u91d1\u989d\u540e:{}", (Object)params.getTotalDiscountAmount());
                    params.getActivityDiscountMap().put(String.valueOf(params.getActivityId()), discountAmountNum);
                    CalcUtil.calculateDiscount(params.getActivityId(), combinationItems, discountAmountNum, null, null);
                } else {
                    logger.info("\u4e00\u53e3\u4ef7\u5339\u914d\u53c2\u6570\u5931\u8d25\uff1a{}", (Object)comItemDto);
                }
            } else {
                logger.info("\u5355\u54c1\u4ef7\u53c2\u6570:{}", (Object)JSON.toJSONString(combinationItems));
                for (ItemVo item : combinationItems) {
                    ComItemDto comItemDto = comItemDtos.stream().filter(i -> i.getItemId().toString().equals(item.getItemId())).findFirst().orElse(null);
                    if (Objects.nonNull(comItemDto)) {
                        logger.info("\u4f18\u60e0\u5957\u88c5\u5355\u54c1\u4ef7[{}]\u53c2\u6570,\u5546\u54c1\u540d\u79f0:{},\u4fee\u6539\u524d\u4ef7\u683c:{}", new Object[]{params.getActivityId(), comItemDto.getItemName(), JSON.toJSONString((Object)item)});
                        BigDecimal discountPrice = comItemDto.getCombinationPrice();
                        BigDecimal skuDiscountAmount = BigDecimal.valueOf(item.getNum()).multiply(item.getPrice().subtract(comItemDto.getCombinationPrice()));
                        item.setDiscountPrice(discountPrice);
                        item.setPrice(discountPrice);
                        params.setTotalDiscountAmount(params.getTotalDiscountAmount().add(skuDiscountAmount));
                        discountAmountNum = discountAmountNum.add(skuDiscountAmount);
                        DiscountAmount discountAmount = new DiscountAmount();
                        discountAmount.setActivityId(conditionRespDto.getActivityId());
                        discountAmount.setAmount(skuDiscountAmount);
                        item.getActivityDiscountAmount().add(discountAmount);
                        continue;
                    }
                    logger.info("\u5355\u54c1\u4ef7\u5339\u914d\u53c2\u6570\u5931\u8d25\uff1a{}", (Object)item);
                }
                params.getActivityDiscountMap().put(String.valueOf(params.getActivityId()), discountAmountNum);
            }
            meet = true;
        }
        if (meet) {
            if (CollectionUtils.isNotEmpty((Collection)params.getCombinationActivityIds())) {
                params.getCombinationActivityIds().add(params.getActivityId());
            } else {
                ArrayList activityIds = Lists.newArrayList();
                activityIds.add(params.getActivityId());
                params.setCombinationActivityIds((List)activityIds);
            }
        }
        return meet;
    }

    public <T extends EngineParams> void clearCombinationActivity(T params) {
        List<ActivityRespDto> activitys = this.activityService.queryActivityListByIds(params.getActivityIds());
        List allCombinationIds = activitys.stream().filter(activity -> activity.getActivityTemplateId().equals(ActivityType.COMBINATION_ACTIVITY.getId())).map(ActivityRespDto::getId).collect(Collectors.toList());
        List itemCombinationIds = params.getItems().stream().map(ItemVo::getCombinedPackageActivityId).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList activityIds = Lists.newArrayList();
        for (ActivityRespDto activity2 : activitys) {
            if (allCombinationIds.contains(activity2.getId()) && !itemCombinationIds.contains(activity2.getId())) continue;
            activityIds.add(activity2.getId());
        }
        logger.info("\u8fc7\u6ee4\u6389\u5355\u4e70\u7684\u4f18\u60e0\u5957\u88c5\u5546\u54c1\uff1a{}", (Object)activityIds);
        params.setActivityIds((List)activityIds);
    }

    public Boolean matchCombination(List<ComItemDto> comItemDtos, List<ItemVo> combinationItems) {
        if (CollectionUtils.isEmpty(comItemDtos) || CollectionUtils.isEmpty(combinationItems)) {
            return false;
        }
        for (ComItemDto comItemDto : comItemDtos) {
            boolean isCheck = false;
            for (ItemVo itemVo : combinationItems) {
                if (!comItemDto.getItemId().toString().equals(itemVo.getItemId())) continue;
                isCheck = true;
            }
            if (isCheck) continue;
            return false;
        }
        return true;
    }
}

