/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.condition;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityRelationService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PointDeductMutexCondition
extends ConditionTemplate {
    @Resource
    private IActivityRelationService activityRelationService;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T params, Map<String, ?> activityParams) {
        if (BizActivityType.POINT_DEDUCT_ACTIVITY.getId() != params.getActivityId()) {
            return true;
        }
        Set<String> bizIds = this.getRuleBizIds(params);
        if (CollectionUtils.isEmpty(bizIds)) {
            return true;
        }
        this.check(bizIds, params);
        return false;
    }

    private <T extends EngineParams> Set<String> getRuleBizIds(T params) {
        TreeSet<String> bizIds = new TreeSet<String>();
        params.getItems().forEach(itemVo -> {
            if (itemVo.getShopPointDeductRule() == 1) {
                String shelfId = itemVo.getShelfId();
                bizIds.add(shelfId);
            }
            if (StringUtils.isNotBlank((CharSequence)itemVo.getShopPointDeductRuleId()) && !"0".equals(itemVo.getShopPointDeductRuleId()) && itemVo.getShopPointDeductRule() == 0) {
                bizIds.add(itemVo.getShopPointDeductRuleId());
            }
        });
        return bizIds;
    }

    private <T extends EngineParams> boolean check(Set<String> bizIds, T params) {
        int index;
        Long currentActivityId = params.getActivityId();
        ArrayList removeIds = Lists.newArrayList();
        block0: for (int i = index = params.getActivityIds().indexOf(currentActivityId) + 1; i < params.getActivityIds().size(); ++i) {
            Long nextActivityId = (Long)params.getActivityIds().get(i);
            for (String bizId : bizIds) {
                boolean result = this.activityRelationService.overlap((Long)Long.parseLong(bizId), nextActivityId);
                if (result) continue;
                removeIds.add(nextActivityId);
                String message = "\u4eb2\uff0c\u60a8\u5df2\u9009\u62e9\u79ef\u5206\u62b5\u6263";
                params.getActivityReasonMap().put(nextActivityId.toString(), message);
                continue block0;
            }
        }
        params.getActivityIds().removeAll(removeIds);
        return true;
    }

    public <T extends EngineParams> boolean checkNextIsPointDeduct(long activityId, long nextActivityId, T params) {
        if (BizActivityType.POINT_DEDUCT_ACTIVITY.getId() != nextActivityId) {
            return false;
        }
        Set<String> bizIds = this.getRuleBizIds(params);
        if (CollectionUtils.isEmpty(bizIds)) {
            return false;
        }
        boolean mutex = false;
        for (String bizId : bizIds) {
            boolean result = this.activityRelationService.overlap((Long)activityId, Long.parseLong(bizId));
            if (result) continue;
            mutex = true;
            break;
        }
        return mutex;
    }
}

