/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.member.api.common.condition.Criteria;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponMoneyOffDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateQueryRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.PersonalizedCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IConditionExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.config.CouponConfig;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateCacheService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateStockService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.CouponGifCondition;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.CouponPieceGiftCondition;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.PersonalizedCouponItemCondition;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.CouponBrandCondition;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.CouponCategoryCondition;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.CouponItemsCondition;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.CouponMoneyOffCondition;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.CouponReceiveLimitCondition;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore.CouponShopCondition;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.utils.CouponSupplierUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.DateUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponTemplateDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponTemplateEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.vo.CouponTemplateVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CouponTemplateExtQueryServiceImpl
implements ICouponTemplateExtQueryService {
    private static Logger logger = LoggerFactory.getLogger(CouponTemplateExtQueryServiceImpl.class);
    @Autowired
    private CouponTemplateDas couponTemplateDas;
    @Autowired
    private ICouponTemplateStockService couponTemplateStockService;
    @Autowired
    private IConditionExtQueryService conditionExtQueryService;
    @Autowired
    private CouponConfig couponConfig;
    @Autowired
    private ICouponExtQueryService couponExtQueryService;
    @Autowired
    private ICouponTemplateCacheService couponTemplateCacheService;
    @Autowired
    private IActivityService activityService;
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private CouponDas couponDas;

    @Override
    public PageInfo<CouponTemplateExtRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        List<Long> activityIds;
        Map<Long, String> tagMap;
        List eoList;
        CouponTemplateEo query = new CouponTemplateEo();
        Criteria criteria = null;
        try {
            criteria = (Criteria)ObjectHelper.Json2Bean((String)filter, Criteria.class);
            if (null != criteria) {
                query.setSqlFilters(criteria.getFilters());
                query.setOrderBy(criteria.getOrderBy());
                query.setOrderByDesc(criteria.getOrderByDesc());
            }
            if (StringUtils.isEmpty((CharSequence)criteria.getOrderBy()) && StringUtils.isEmpty((CharSequence)criteria.getOrderByDesc())) {
                query.setOrderByDesc("create_time");
            }
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        PageInfo responseInfo = new PageInfo();
        if (null != pageNum && pageSize != null) {
            PageInfo pageInfo = this.couponTemplateDas.selectPage((BaseEo)query, pageNum, pageSize);
            BeanUtils.copyProperties((Object)pageInfo, (Object)responseInfo);
            eoList = pageInfo.getList();
        } else {
            eoList = this.couponTemplateDas.select((BaseEo)query);
        }
        List<CouponTemplateExtRespDto> list = BeanCopyUtil.copyCollections(eoList, CouponTemplateExtRespDto.class, new String[0]);
        if (list != null && !list.isEmpty() && (tagMap = this.queryActivityListByIds(activityIds = list.stream().map(CouponTemplateExtRespDto::getActivityId).collect(Collectors.toList()))) != null && !tagMap.isEmpty()) {
            list.forEach(couponTemplateExtRespDto -> {
                if (tagMap.containsKey(couponTemplateExtRespDto.getActivityId())) {
                    couponTemplateExtRespDto.setActivityTag((String)tagMap.get(couponTemplateExtRespDto.getActivityId()));
                }
            });
        }
        for (CouponTemplateExtRespDto couponTemplateExtRespDto2 : list) {
            if (CollectionUtils.isNotEmpty((Collection)criteria.getFields())) {
                couponTemplateExtRespDto2.setMemberId(Long.valueOf((String)criteria.getFields().get(0)));
            }
            this.convertCouponTemplate(couponTemplateExtRespDto2);
        }
        responseInfo.setList(list);
        return responseInfo;
    }

    private Map<Long, String> queryActivityListByIds(List<Long> activityIds) {
        List<ActivityRespDto> activityRespDtoList;
        HashMap<Long, String> tagMap = new HashMap<Long, String>();
        ArrayList<Long> notcacheList = new ArrayList<Long>();
        activityIds.forEach(id -> {
            String tag = this.activityService.getActivityTag((Long)id);
            if (StringUtils.isEmpty((CharSequence)tag)) {
                notcacheList.add((Long)id);
            } else {
                tagMap.put((Long)id, tag);
            }
        });
        if (!notcacheList.isEmpty() && (activityRespDtoList = this.activityService.queryActivityListByIds(notcacheList)) != null) {
            activityRespDtoList.forEach(activityRespDto -> {
                if (activityRespDto.getTag() == null) {
                    activityRespDto.setTag("");
                }
                tagMap.put(activityRespDto.getId(), activityRespDto.getTag());
                this.activityService.setActivityTagCache(activityRespDto.getId(), activityRespDto.getTag());
            });
        }
        return tagMap;
    }

    @Override
    public CouponTemplateExtRespDto queryById(Long id) {
        if (null == id || id == 0L) {
            return null;
        }
        CouponTemplateEo couponTemplateExtEo = (CouponTemplateEo)this.couponTemplateDas.selectByPrimaryKey(id);
        CouponTemplateExtRespDto couponTemplateExtRespDto = BeanCopyUtil.copyProperties(CouponTemplateExtRespDto.class, couponTemplateExtEo, new String[0]);
        Assert.notNull((Object)couponTemplateExtRespDto, (String)"\u627e\u4e0d\u5230\u4f18\u60e0\u5238\u6a21\u677f\u4fe1\u606f");
        if (null != couponTemplateExtRespDto) {
            this.convertCouponTemplate(couponTemplateExtRespDto);
        }
        return couponTemplateExtRespDto;
    }

    @Override
    public CouponTemplateEo queryEoById(Long id) {
        if (null == id || id == 0L) {
            return null;
        }
        return (CouponTemplateEo)this.couponTemplateDas.selectByPrimaryKey(id);
    }

    @Override
    public CouponTemplateExtRespDto queryByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        CouponTemplateEo couponTemplateExtEo = (CouponTemplateEo)this.couponTemplateDas.selectByLogicKey((Object)code);
        if (null == couponTemplateExtEo) {
            return null;
        }
        CouponTemplateExtRespDto couponTemplateExtRespDto = BeanCopyUtil.copyProperties(CouponTemplateExtRespDto.class, couponTemplateExtEo, new String[0]);
        if (null != couponTemplateExtRespDto) {
            this.convertCouponTemplate(couponTemplateExtRespDto);
        }
        return couponTemplateExtRespDto;
    }

    @Override
    public Long queryTempIdByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        CouponTemplateEo couponTemplateExtEo = (CouponTemplateEo)this.couponTemplateDas.selectByLogicKey((Object)code);
        if (null == couponTemplateExtEo) {
            return null;
        }
        return couponTemplateExtEo.getId();
    }

    @Override
    public List<CouponTemplateExtRespDto> listByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        List<CouponTemplateExtRespDto> couponTemplateExtRespDtos = this.couponTemplateCacheService.findCouponTemplateListCache(ids);
        if (CollectionUtils.isNotEmpty(couponTemplateExtRespDtos)) {
            List existIds = couponTemplateExtRespDtos.stream().map(CouponTemplateExtRespDto::getId).collect(Collectors.toList());
            ids = Lists.newArrayList(ids);
            ids.removeIf(id -> existIds.contains(id));
            if (CollectionUtils.isNotEmpty((Collection)ids)) {
                couponTemplateExtRespDtos.addAll(this.queryByIds(ids));
            }
        } else {
            couponTemplateExtRespDtos = this.queryByIds(ids);
        }
        List<Long> activityIds = couponTemplateExtRespDtos.stream().map(CouponTemplateExtRespDto::getActivityId).distinct().collect(Collectors.toList());
        Map<Long, List<ConditionEo>> conditionMap = this.conditionExtQueryService.listByActivityIds2Map(activityIds);
        couponTemplateExtRespDtos.forEach(couponTemplateExtRespDto -> this.convertCouponTemplate((CouponTemplateExtRespDto)couponTemplateExtRespDto));
        return couponTemplateExtRespDtos;
    }

    public List<CouponTemplateExtRespDto> queryByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        CouponTemplateEo query = new CouponTemplateEo();
        query.setSqlFilters(Arrays.asList(SqlFilter.in((String)"id", ids)));
        List list = this.couponTemplateDas.select((BaseEo)query);
        List<CouponTemplateExtRespDto> couponTemplateExtRespDtos = BeanCopyUtil.copyCollections(list, CouponTemplateExtRespDto.class, new String[0]);
        couponTemplateExtRespDtos.forEach(couponTemplateExtRespDto -> this.convertCouponTemplate((CouponTemplateExtRespDto)couponTemplateExtRespDto));
        this.couponTemplateCacheService.setCouponTemplateListCache(couponTemplateExtRespDtos);
        return couponTemplateExtRespDtos;
    }

    @Override
    public Map<Long, CouponTemplateExtRespDto> listByIds2Map(List<Long> ids) {
        List<CouponTemplateExtRespDto> list = this.listByIds(ids);
        return list.stream().collect(Collectors.toMap(CouponTemplateExtRespDto::getId, Function.identity()));
    }

    @Override
    public List<CouponTemplateEo> listAllEffective() {
        CouponTemplateEo query = new CouponTemplateEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.gt((String)"remainingQuantity", (Object)0));
        return this.couponTemplateDas.select((BaseEo)query);
    }

    @Override
    public CouponTemplateExtRespDto queryByCodeSimple(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        CouponTemplateEo query = new CouponTemplateEo();
        query.setCouponCode(code);
        CouponTemplateEo couponTemplateExtEo = (CouponTemplateEo)this.couponTemplateDas.selectOne((BaseEo)query);
        if (null == couponTemplateExtEo) {
            return null;
        }
        return BeanCopyUtil.copyProperties(CouponTemplateExtRespDto.class, couponTemplateExtEo, new String[0]);
    }

    private void packageCondition(CouponTemplateExtRespDto couponTemplateExtRespDto) {
        if (null != couponTemplateExtRespDto) {
            List<ConditionEo> conditionEoList = this.conditionExtQueryService.listByActivityId(couponTemplateExtRespDto.getActivityId());
            this.packageCondition(couponTemplateExtRespDto, conditionEoList);
        }
    }

    @Override
    public void packageCondition(CouponTemplateExtRespDto couponTemplateExtRespDto, List<ConditionEo> conditionEoList) {
        if (null != couponTemplateExtRespDto && CollectionUtils.isNotEmpty(conditionEoList)) {
            ArrayList couponShopList = new ArrayList();
            ArrayList couponItemList = new ArrayList();
            ArrayList couponPieceGiftRespDtos = new ArrayList();
            ArrayList catelogIds = Lists.newArrayList();
            ArrayList brandDtoList = Lists.newArrayList();
            conditionEoList.forEach(condition -> {
                try {
                    CouponMoneyOffDto couponMoneyOffDto;
                    couponShopList.addAll(CouponShopCondition.parseParams(condition.getConditionParams()));
                    couponItemList.addAll(CouponItemsCondition.parseParams(condition.getConditionParams()));
                    brandDtoList.addAll(CouponBrandCondition.parseParams(condition.getConditionParams()));
                    catelogIds.addAll(CouponCategoryCondition.parseParams(condition.getConditionParams()));
                    couponPieceGiftRespDtos.addAll(CouponPieceGiftCondition.parseParams(condition.getConditionParams()));
                    Integer shopRangeType = CouponShopCondition.parseShopRangeType(condition.getConditionParams());
                    if (shopRangeType != null) {
                        couponTemplateExtRespDto.setShopRangeType(shopRangeType);
                    }
                    Integer limitQty = CouponReceiveLimitCondition.parseParams(condition.getConditionParams(), "CouponReceiveLimitCondition.limit");
                    Integer dayLimitQty = CouponReceiveLimitCondition.parseParams(condition.getConditionParams(), "CouponReceiveLimitCondition.dayLimit");
                    if (limitQty != null) {
                        couponTemplateExtRespDto.setLimitQty(limitQty);
                        if (Objects.nonNull(couponTemplateExtRespDto.getMemberId())) {
                            Integer received = this.getHasSendNum(couponTemplateExtRespDto.getMemberId(), couponTemplateExtRespDto.getId());
                            couponTemplateExtRespDto.setRemainingLimitQty(Integer.valueOf(limitQty - received));
                        }
                    }
                    if (dayLimitQty != null) {
                        couponTemplateExtRespDto.setDayLimitQty(dayLimitQty);
                        if (Objects.nonNull(couponTemplateExtRespDto.getMemberId())) {
                            Integer dayReceive = this.getHasSendNumByDay(couponTemplateExtRespDto.getMemberId(), couponTemplateExtRespDto.getId());
                            couponTemplateExtRespDto.setRemainingDayLimitQty(Integer.valueOf(dayLimitQty - dayReceive));
                        }
                    }
                    if ((couponMoneyOffDto = CouponMoneyOffCondition.parseParams(condition.getConditionParams())) != null) {
                        couponTemplateExtRespDto.setCouponMoneyOffDto(couponMoneyOffDto);
                    }
                    Integer isBuyType = CouponGifCondition.parseParams(condition.getConditionParams(), "CouponGifCondition.isBuyType");
                    String buyAmount = null == CouponGifCondition.parseParams(condition.getConditionParams(), "CouponGifCondition.amount") ? "" : CouponGifCondition.parseParams(condition.getConditionParams(), "CouponGifCondition.amount") + "";
                    Integer isGif = CouponGifCondition.parseParams(condition.getConditionParams(), "CouponGifCondition.isGif");
                    couponTemplateExtRespDto.setIsBuyType(Integer.valueOf(null != isBuyType ? isBuyType : 0));
                    couponTemplateExtRespDto.setBuyAmount(StringUtils.isBlank((CharSequence)buyAmount) ? "0" : buyAmount);
                    couponTemplateExtRespDto.setIsGif(Integer.valueOf(null != isGif ? isGif : 0));
                    PersonalizedCouponRespDto personalizedCouponRespDto = PersonalizedCouponItemCondition.parseParams(condition.getConditionParams());
                    if (null != personalizedCouponRespDto) {
                        couponTemplateExtRespDto.setPersonalizedCouponRespDto(personalizedCouponRespDto);
                    }
                }
                catch (Exception e) {
                    logger.warn("\u8bbe\u7f6e\u53ef\u7528\u5e97\u94fa\u6216\u53ef\u7528\u5546\u54c1\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6b63\u786e\u6027\uff0ccouponTemplateExtRespDto\uff1a{}\uff0ccondition\uff1a{}", (Object)JSON.toJSONString((Object)couponTemplateExtRespDto), (Object)JSON.toJSONString((Object)condition));
                    logger.error(e.getMessage(), (Throwable)e);
                }
            });
            couponTemplateExtRespDto.setCouponShopList(couponShopList);
            couponTemplateExtRespDto.setCouponItemList(couponItemList);
            couponTemplateExtRespDto.setCouponPieceGiftRespDtos(couponPieceGiftRespDtos);
            couponTemplateExtRespDto.setCouponTemplateBrandDtoList((List)brandDtoList);
            couponTemplateExtRespDto.setCouponTemplateCatalogDtoList((List)catelogIds);
        }
    }

    private Integer getHasSendNum(Long memberId, Long couponTemplateId) {
        String sendKey = "coupon_send_num_" + couponTemplateId + "_" + memberId;
        Integer hasSendNum = (Integer)this.cacheService.getCache(sendKey, Integer.class);
        if (null == hasSendNum) {
            CouponEo select = new CouponEo();
            select.setUserId(memberId);
            select.setCouponTemplateId(couponTemplateId);
            hasSendNum = this.couponDas.count((BaseEo)select);
            this.cacheService.setCache(sendKey, (Object)hasSendNum, 86400);
        }
        return hasSendNum;
    }

    private Integer getHasSendNumByDay(Long memberId, Long couponTemplateId) {
        String sendKey = "coupon_send_num_day_" + couponTemplateId + "_" + memberId;
        Integer hasSendNum = (Integer)this.cacheService.getCache(sendKey, Integer.class);
        if (null == hasSendNum) {
            Date now = new Date();
            Date startDate = DateUtil.getStartTimeOfDay(now);
            Date endDate = DateUtil.getEndTimeOfDay(now);
            CouponEo select = new CouponEo();
            List<SqlFilter> sqlFilterList = SqlFilterBuilder.newInstance().buildEqualsSqlFilter("userId", memberId).buildEqualsSqlFilter("couponTemplateId", couponTemplateId).buildBetweenSqlFilter("receiveTime", DateFormatUtils.format((Date)startDate, (String)DatePattern.DATETIME_PATTERN.getPattern()), DateFormatUtils.format((Date)endDate, (String)DatePattern.DATETIME_PATTERN.getPattern())).get();
            select.setSqlFilters(sqlFilterList);
            hasSendNum = this.couponDas.count((BaseEo)select);
            int timeInterval = (int)((endDate.getTime() - now.getTime()) / 1000L);
            this.cacheService.setCache(sendKey, (Object)hasSendNum, timeInterval);
        }
        return hasSendNum;
    }

    private void convertCouponTemplate(CouponTemplateExtRespDto couponTemplateExtRespDto) {
        Long availableStock = this.couponTemplateStockService.getAvailableStock(couponTemplateExtRespDto.getId());
        couponTemplateExtRespDto.setRemainingQuantity(availableStock);
        if (StringUtils.isNotEmpty((CharSequence)couponTemplateExtRespDto.getExtension())) {
            JSONObject jsonObject = JSON.parseObject((String)couponTemplateExtRespDto.getExtension());
            couponTemplateExtRespDto.setExtFields((Map)jsonObject.toJavaObject(Map.class));
        }
        this.packageCondition(couponTemplateExtRespDto);
        couponTemplateExtRespDto.setSupplier(CouponSupplierUtil.getSupplier(couponTemplateExtRespDto.getSupplier()));
    }

    @Override
    public PageInfo<CouponTemplateQueryRespDto> queryWithActivity(CouponTemplateQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        CouponTemplateVo couponTemplateVo = new CouponTemplateVo();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)couponTemplateVo);
        PageHelper.startPage((int)pageNum, (int)pageSize);
        if (CollectionUtils.isNotEmpty((Collection)couponTemplateVo.getCouponCategoryList())) {
            couponTemplateVo.setCouponCategory(null);
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getCouponRanges())) {
            String[] couponRangeArr = StringUtils.split((String)queryReqDto.getCouponRanges(), (String)",");
            List couponRanges = Arrays.stream(couponRangeArr).map(Integer::valueOf).collect(Collectors.toList());
            couponTemplateVo.setCouponRanges(couponRanges);
            couponTemplateVo.setCouponRange(null);
        }
        PageInfo pageInfo = this.couponTemplateDas.queryByActivity(couponTemplateVo, pageNum, pageSize);
        ArrayList list = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), (Collection)list, CouponTemplateQueryRespDto.class);
        PageInfo result = new PageInfo();
        BeanUtils.copyProperties((Object)pageInfo, (Object)result);
        result.setList((List)list);
        return result;
    }
}

