/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.opensearch.api.ISearchIndexService;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.scheduler.api.ITaskApi;
import com.dtyunxi.yundt.cube.center.scheduler.api.dto.request.TaskAndBizCreateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityAuditReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityCreateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemListReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityTaskReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityTemplateQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityItemRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityRespExtDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ConditionTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ItemActivityPriceMkRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityTaskTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.CheckPointEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.listener.event.ActivityModifyEvent;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IEngineApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityTemplateRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.tag.dto.ActivityStatusChangeMessage;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityRelationService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityRuleItemService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.IActivityTaskService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IActivityExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.query.ICouponExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActionService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemRuleService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityItemService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityJoinLogService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityPolicyMappingService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityUserMappingService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IConditionService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IConditionTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl.IQueryActivityInfoFilter;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.impl.TransactionCallBackService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponTemplateService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ILoadConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BeanCopyUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.DateUtil;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.conf.param.ActivityStockTypeParam;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityAuditDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityPolicyMappingDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.coupon.das.CouponTemplateDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityAuditEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityUserMappingEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdActivityUserMappingEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponTemplateEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Primary
@Service
public class ActivityServiceImpl
implements IActivityService {
    private static Logger logger = LoggerFactory.getLogger(ActivityServiceImpl.class);
    @Resource
    private ActivityDas activityDas;
    @Resource
    private IActivityRuleItemService activityRuleItemService;
    @Resource
    private ActivityAuditDas activityAuditDas;
    @Autowired
    private IActivityTemplateService activityTemplateService;
    @Autowired
    private IConditionService conditionService;
    @Resource
    private IItemActivityTagService itemActivityTagService;
    @Autowired
    private IActionService actionService;
    @Autowired
    private ActivityPolicyMappingDas activityPolicyMappingDas;
    @Autowired
    private IActivityPolicyMappingService activityPolicyMappingService;
    @Autowired
    private IActivityItemService activityItemService;
    @Autowired
    private IActivityUserMappingService activityUserMappingService;
    @Autowired
    private IActivityJoinLogService activityJoinLogService;
    @Autowired
    private ICouponService couponService;
    @Autowired
    private CouponTemplateDas couponTemplateDas;
    @Autowired
    private ICouponTemplateService iCouponTemplateService;
    @Autowired
    private IActivityItemRuleService activityItemRuleService;
    @Autowired
    private IActivityExtQueryService activityExtQueryService;
    @Resource
    private IEngineApi engineApiImpl;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IConditionTemplateService conditionTemplateService;
    @Resource
    private ICacheService cacheService;
    @CubeResource
    private ActivityStockTypeParam activityStockTypeParam;
    @Autowired
    private TransactionCallBackService transactionCallBackService;
    @Resource
    private ITaskApi taskApi;
    @Value(value="${scheduler.client.app_code}")
    private String appCode;
    @Resource
    private IActivityRelationService activityRelationService;
    @Resource
    private ICouponExtQueryService couponExtQueryService;
    @Resource
    private ISearchIndexService searchIndexService;
    @Value(value="${cube.global.profile:}")
    private String globalProfile;
    @Value(value="${single.item.delay.item: 5}")
    private long singleItemDelayTime;
    @Autowired
    private ApplicationEventPublisher publisher;
    @Autowired
    private IActivityTaskService activityTaskService;
    @Autowired
    private ICouponTemplateExtService couponTemplateExtService;
    @Resource
    private IActivityExtService activityExtService;

    private void validateActivityByOneStepParams(ActivityCreateReqDto activityCreateReqDto, String operation) {
        ActivityDto activityDto;
        if ("create".equals(operation)) {
            if (CollectionUtils.isEmpty((Collection)activityCreateReqDto.getConditions())) {
                throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u6761\u4ef6\u5b9e\u4f8b\u4e0d\u80fd\u4e3a\u7a7a"}));
            }
            if (CollectionUtils.isEmpty((Collection)activityCreateReqDto.getActions())) {
                throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u52a8\u4f5c\u5b9e\u4f8b\u4e0d\u80fd\u4e3a\u7a7a"}));
            }
        } else if ("modify".equals(operation) && (activityDto = activityCreateReqDto.getActivityDto()) != null) {
            this.validateTime(activityDto);
            if (activityDto.getId() == null) {
                throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"}));
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long createActivityByOneStep(ActivityCreateReqDto activityCreateReqDto) {
        ActivityEo waitAuditActivityEo;
        this.validateActivityByOneStepParams(activityCreateReqDto, "create");
        ActivityDto activityDto = activityCreateReqDto.getActivityDto();
        Integer count = this.activityTemplateService.isExists(activityDto.getActivityTemplateId());
        if (count == null || count == 0) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u6d3b\u52a8\u6a21\u677f\uff1a{}\u4e0d\u5b58\u5728"}).format(new String[]{"" + activityDto.getId()}));
        }
        if (activityDto.getOriginalActivityId() != null && (waitAuditActivityEo = (ActivityEo)((ExtQueryChainWrapper)this.activityDas.filter().select(new String[]{"id", "activity_code"}).eq((Object)"original_activity_id", (Object)activityDto.getOriginalActivityId())).one()) != null) {
            throw new BizException("\u8be5\u8fdb\u884c\u4e2d\u7684\u6d3b\u52a8\u5b58\u5728\u88ab\u4fee\u7684\u6d3b\u52a8\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u4fee\u6539,\u6d3b\u52a8\uff1a" + waitAuditActivityEo.getActivityCode());
        }
        if (this.activityItemService.checkIsSubItemVirStock(activityDto.getActivityTemplateId())) {
            this.activityItemService.subItemVirStock(activityDto.getActivityName(), activityCreateReqDto.getActivityItems());
        } else {
            logger.info("\u6d3b\u52a8\u6a21\u677f{}\u4e0d\u6263\u51cf\u6d3b\u52a8\u5e93\u5b58", (Object)activityDto.getActivityTemplateId());
        }
        ActivityEo activityEo = BeanCopyUtil.copyProperties(ActivityEo.class, activityDto, new String[0]);
        activityEo.setAuditStatus(activityDto.getAuditStatusEnum().getKey());
        activityEo.setActivityStatus(activityDto.getActivityStatusEnum().getKey());
        this.activityDas.insert((BaseEo)activityEo);
        if (activityEo.getFirstActivityId() == null) {
            ActivityEo updateEo = new ActivityEo();
            updateEo.setId(activityEo.getId());
            updateEo.setFirstActivityId(activityEo.getId());
            this.activityDas.updateSelective((BaseEo)updateEo);
        }
        this.conditionService.insertConditionBatch(activityEo.getId(), activityEo.getActivityTemplateId(), activityCreateReqDto.getConditions());
        this.actionService.insertBatchActions(activityEo.getId(), activityEo.getActivityTemplateId(), activityCreateReqDto.getActions());
        this.activityItemService.insertBatchItem(activityEo.getId(), activityCreateReqDto.getActivityItems());
        this.activityRuleItemService.insertBatchItem(activityEo.getId(), activityCreateReqDto.getActivityRuleItems());
        BizActivityType bizType = activityCreateReqDto.getBizActivityType();
        this.activityRelationService.add(activityEo.getId(), bizType == null ? activityEo.getActivityTemplateId().longValue() : bizType.getId(), activityCreateReqDto.getActivityRelations());
        return activityEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyActivityByOneStep(long id, ActivityCreateReqDto activityCreateReqDto) {
        this.validateActivityByOneStepParams(activityCreateReqDto, "modify");
        ActivityEo eo = (ActivityEo)this.activityDas.selectByPrimaryKey(Long.valueOf(id));
        if (eo == null) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u8be5\u6d3b\u52a8id\u5bf9\u5e94\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728"}).format(new String[]{"" + id}));
        }
        if (!eo.getInstanceId().equals(ServiceContext.getContext().getRequestInstanceId()) || !eo.getTenantId().equals(ServiceContext.getContext().getRequestTenantId())) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u8be5id\u5bf9\u5e94\u8bb0\u5f55\u7684instanceId\u6216tenantId\u4e0d\u5339\u914d"}).format(new String[]{"" + id}));
        }
        if (eo.getAuditStatus().equals(AuditStatusEnum.WAIT_AUDIT.getKey()) || eo.getAuditStatus().equals(AuditStatusEnum.AUDIT_REFUSE.getKey()) || eo.getActivityTemplateId().equals(ActivityType.EXCHANGE_ACTIVITY.getId())) {
            ActivityDto activityDto = activityCreateReqDto.getActivityDto();
            if (activityDto != null) {
                ActivityEo activityEo = BeanCopyUtil.copyProperties(ActivityEo.class, activityDto, new String[0]);
                activityEo.setId(Long.valueOf(id));
                if (!ActivityStatusEnum.ACTIVATE.getKey().equals(eo.getActivityStatus())) {
                    activityEo.setActivityStatus(ActivityStatusEnum.NEW.getKey());
                    activityEo.setAuditStatus(AuditStatusEnum.WAIT_AUDIT.getKey());
                }
                this.activityDas.updateSelective((BaseEo)activityEo);
            }
        } else {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u6d3b\u52a8\u4e0d\u5141\u8bb8\u4fee\u6539"}));
        }
        this.clearConditionList(id);
        this.conditionService.deleteByActivityId(id);
        this.conditionService.insertConditionBatch(id, eo.getActivityTemplateId(), activityCreateReqDto.getConditions());
        this.clearActionList(id);
        this.actionService.deleteByActivityId(id);
        this.actionService.insertBatchActions(id, eo.getActivityTemplateId(), activityCreateReqDto.getActions());
        this.activityItemService.deleteByActId(id);
        this.activityItemService.insertBatchItem(id, activityCreateReqDto.getActivityItems());
        this.activityRuleItemService.deleteByActivityId(id);
        this.activityRuleItemService.insertBatchItem(id, activityCreateReqDto.getActivityRuleItems());
        this.activityRelationService.deleteActivityRelationByBizId(id);
        BizActivityType bizType = activityCreateReqDto.getBizActivityType();
        this.activityRelationService.add(id, bizType == null ? eo.getActivityTemplateId().longValue() : bizType.getId(), activityCreateReqDto.getActivityRelations());
        this.publisher.publishEvent((Object)new ActivityModifyEvent(Long.valueOf(id)));
    }

    private void validateTime(ActivityDto activityDto) {
        if (activityDto.getBeginTime().compareTo(activityDto.getEndTime()) > -1) {
            throw new BizException("\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u9700\u5c0f\u4e8e\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4");
        }
        if (null != activityDto.getPreheatStartTime() && activityDto.getPreheatStartTime().compareTo(activityDto.getBeginTime()) > -1) {
            throw new BizException("\u6d3b\u52a8\u9884\u70ed\u65f6\u95f4\u9700\u5c0f\u4e8e\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4");
        }
    }

    @Override
    @Cacheable(key="'activity_tag_' + #activityId", value={"activityTagCache"}, unless="#result == null")
    public String getActivityTag(Long activityId) {
        return "";
    }

    @Override
    @CachePut(key="'activity_tag_' + #activityId", value={"activityTagCache"}, unless="#tag == null")
    public String setActivityTagCache(Long activityId, String tag) {
        return tag;
    }

    @Override
    public ActivityRespDto getActivity(Long activityId) {
        ActivityEo activityEo = (ActivityEo)this.activityDas.selectByPrimaryKey(activityId);
        if (null == activityEo) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u6d3b\u52a8ID\u4e0d\u5b58\u5728"}));
        }
        ActivityRespDto activityDto = BeanCopyUtil.copyProperties(ActivityRespDto.class, activityEo, new String[0]);
        activityDto.setConditionDtos(this.queryConditionList(activityId));
        activityDto.setActionDtos(this.queryActionList(activityId));
        List<Long> policyIds = this.getPolicyIdsByActivityTemplateId(activityEo.getActivityTemplateId());
        activityDto.setPolicyIds(policyIds);
        return activityDto;
    }

    public void assembleCustomerInfo(Long activityId, ActivityRespDto activityDto) {
        List<ActivityUserMappingEo> activityUserMappingEos = this.activityUserMappingService.queryByActivityId(activityId);
        if (!CollectionUtils.isEmpty(activityUserMappingEos)) {
            List userIds = activityUserMappingEos.stream().map(StdActivityUserMappingEo::getUserId).collect(Collectors.toList());
            activityDto.setUserIds(userIds);
            if (activityUserMappingEos.size() == 1) {
                ActivityUserMappingEo activityUserMappingEo = activityUserMappingEos.get(0);
                activityDto.setCustomerTypeIds(activityUserMappingEo.getCustomerTypeId());
                activityDto.setCustomerAreaCodes(activityUserMappingEo.getCustomerAreaCode());
            }
        }
    }

    public List<ActionRespDto> queryActionList(Long activityId) {
        return this.actionService.queryActionListByActivityId(activityId);
    }

    public void clearActionList(Long activityId) {
        this.actionService.clearActionListByActivityId(activityId);
    }

    public List<Long> getPolicyIdsByActivityTemplateId(Long activityTemplateId) {
        List<Long> policyIds = this.activityPolicyMappingService.getPolicyIdsByActivityTemplateId(activityTemplateId);
        return policyIds;
    }

    public List<ConditionRespDto> queryConditionList(Long activityId) {
        return this.conditionService.queryConditionListByActivityId(activityId);
    }

    public void clearConditionList(Long activityId) {
        this.conditionService.clearConditionListByActivityId(activityId);
    }

    @Override
    public List<Long> queryActuatingByCp(String checkPoint) {
        return this.activityDas.countActuatingByCp(checkPoint, ActivityStatusEnum.ACTIVATE.getKey(), ServiceContext.getContext().getRequestTenantId(), ServiceContext.getContext().getRequestInstanceId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void audit(Long id, ActivityAuditReqDto activityAuditReqDto) {
        String auditStatus = activityAuditReqDto.getAuditStatus();
        if (!AuditStatusEnum.AUDIT_PASS.getKey().equals(auditStatus) && !AuditStatusEnum.AUDIT_REFUSE.getKey().equals(auditStatus)) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR);
        }
        ActivityEo activityEo = (ActivityEo)this.activityDas.selectByPrimaryKey(id);
        if (activityEo == null) {
            throw new ProBizException(ProExceptionCode.RECORD_NOT_EXIST);
        }
        String activityAuditStatus = activityEo.getAuditStatus();
        if (activityAuditStatus.equals(AuditStatusEnum.AUDIT_PASS.getKey()) || activityAuditStatus.equals(AuditStatusEnum.AUDIT_REFUSE.getKey())) {
            throw new ProBizException(ProExceptionCode.ACTIVITY_ALREADY_AUDIT);
        }
        ActivityEo updateEo = ActivityEo.newInstance();
        updateEo.setId(id);
        updateEo.setAuditStatus(auditStatus);
        this.activityDas.updateSelective((BaseEo)updateEo);
        ActivityAuditEo auditEo = BeanCopyUtil.copyProperties(ActivityAuditEo.class, activityAuditReqDto, new String[0]);
        auditEo.setActivityId(id);
        if (AuditStatusEnum.AUDIT_REFUSE.getKey().equals(auditStatus)) {
            this.activityItemService.rollbackStock(id);
            if (Objects.equals(ActivityType.EXCHANGE_ACTIVITY.getId(), activityEo.getActivityTemplateId())) {
                this.itemActivityTagService.deleteSingleItem(id);
            }
        }
        this.activityAuditDas.insert((BaseEo)auditEo);
    }

    private void createActivityTask(ActivityEo activityEo, String bizName, String bizCode, Date date, ActivityTaskTypeEnum activityTaskTypeEnum) {
        TaskAndBizCreateReqDto dto = new TaskAndBizCreateReqDto();
        dto.setAppCode(this.appCode);
        dto.setBizCode(bizCode);
        dto.setBizName(bizName);
        dto.setParams("" + activityEo.getId());
        dto.setScheduleExpression(DateUtil.date2Cron(date));
        dto.setShardType("SINGLE");
        dto.setTaskBatchId(null);
        dto.setTaskDesc("");
        dto.setTaskName(bizName + "(" + activityEo.getId() + ")");
        dto.setInstanceId(activityEo.getInstanceId());
        dto.setTenantId(activityEo.getTenantId());
        RestResponse addResult = this.taskApi.addWithBiz(dto);
        this.taskApi.enableById((Long)addResult.getData(), "{}");
        this.activityTaskService.addActivityTask(activityEo.getId(), (Long)addResult.getData(), activityTaskTypeEnum);
    }

    private void addActivityTask(Long activityId, Long taskId, ActivityTaskTypeEnum activityTaskTypeEnum) {
        ActivityTaskReqDto activityTaskReqDto = new ActivityTaskReqDto();
        activityTaskReqDto.setActivityId(activityId);
        activityTaskReqDto.setTaskId(taskId);
        activityTaskReqDto.setTaskType(activityTaskTypeEnum.getType());
        this.activityTaskService.addActivityTask(activityTaskReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void activate(Long id) {
        ActivityEo eo = (ActivityEo)this.activityDas.selectByPrimaryKey(id);
        if (eo == null) {
            throw new BusinessRuntimeException("11002", "\u6d3b\u52a8ID\u4e0d\u5b58\u5728");
        }
        if (!ActivityStatusEnum.READY.getKey().equals(eo.getActivityStatus()) && !ActivityStatusEnum.PAUSE.getKey().equals(eo.getActivityStatus())) {
            throw new BusinessRuntimeException("\u6d3b\u52a8\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        ActivityEo updateEo = ActivityEo.newInstance();
        updateEo.setId(id);
        updateEo.setActivityStatus(ActivityStatusEnum.ACTIVATE.getKey());
        this.activityItemRuleService.load(eo);
        this.couponService.activate(id);
        this.activityDas.updateSelective((BaseEo)updateEo);
        this.transactionCallBackService.execute(() -> {
            logger.info("[\u6362\u8d2d\u5546\u54c1\u540c\u6b65\u6d3b\u52a8\u72b6\u6001mq\u6d88\u606f],\u5f00\u59cb\u53d1\u9001:{}", (Object)id);
            MessageResponse messageResponse = this.commonsMqService.sendDelaySingleMessage("change_single_item_activity_status_tag", (Object)id, Long.valueOf(this.singleItemDelayTime));
            logger.info("[\u6362\u8d2d\u5546\u54c1\u540c\u6b65\u6d3b\u52a8\u72b6\u6001mq\u6d88\u606f],\u53d1\u9001\u6210\u529f:{}", (Object)JSON.toJSONString((Object)messageResponse));
        });
    }

    @Override
    public void finishing(Long id) {
        ActivityEo eo = (ActivityEo)this.activityDas.selectByPrimaryKey(id);
        if (!ActivityStatusEnum.ACTIVATE.getKey().equals(eo.getActivityStatus()) && !ActivityStatusEnum.PAUSE.getKey().equals(eo.getActivityStatus())) {
            throw new BusinessRuntimeException("\u6d3b\u52a8\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        ActivityEo updateEo = ActivityEo.newInstance();
        updateEo.setId(id);
        updateEo.setActivityStatus(ActivityStatusEnum.FINISHING.getKey());
        this.activityDas.updateSelective((BaseEo)updateEo);
        this.activityDas.removeCache((Object)id);
    }

    @Override
    public void errorFinish(Long id) {
        ActivityEo updateEo = ActivityEo.newInstance();
        updateEo.setId(id);
        updateEo.setActivityStatus(ActivityStatusEnum.ERROR_FINISH.getKey());
        this.activityDas.updateSelective((BaseEo)updateEo);
        this.activityDas.removeCache((Object)id);
    }

    @Override
    public void finished(Long id) {
        ActivityEo eoEntity = (ActivityEo)this.activityDas.selectByPrimaryKey(id);
        Date manualFinishDate = new Date();
        ActivityEo updateEo = ActivityEo.newInstance();
        updateEo.setId(id);
        updateEo.setActivityStatus(ActivityStatusEnum.FINISH.getKey());
        if (eoEntity.getEndTime() != null && eoEntity.getEndTime().compareTo(manualFinishDate) > 0 && eoEntity.getBeginTime() != null && eoEntity.getBeginTime().compareTo(manualFinishDate) < 0) {
            updateEo.setEndTime(manualFinishDate);
        }
        this.activityDas.updateSelective((BaseEo)updateEo);
        this.activityDas.removeCache((Object)id);
    }

    @Override
    public void finish(Long id) {
        this.finishing(id);
        EngineParams params = new EngineParams();
        params.setActivityId(id.longValue());
        params.setUserId(1L);
        params.setIfValidActivityStatus(Boolean.valueOf(false));
        ActivityEo eo = (ActivityEo)this.activityDas.selectByPrimaryKey(id);
        if (eo.getActivityTemplateId().equals(ActivityType.GROUP_ACTIVITY.getId()) || eo.getActivityTemplateId().equals(ActivityType.SECKILL_ACTIVITY.getId()) || eo.getActivityTemplateId().equals(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId()) || eo.getActivityTemplateId().equals(ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId()) || eo.getActivityTemplateId().equals(ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId()) || eo.getActivityTemplateId().equals(ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.getId()) || eo.getActivityTemplateId().equals(ActivityType.SECKILL_TOB_ACTIVITY.getId())) {
            this.engineApiImpl.execute(CheckPointEnum.FINISH_ACTIVITY.name(), params);
        }
        if ("success".equals(params.getActivityOptResult())) {
            this.finished(id);
        } else {
            logger.info("\u6d3b\u52a8\u5e93\u5b58\u6263\u51cf\u5931\u8d25");
            this.errorFinish(id);
        }
        this.couponService.finish(id);
        this.sendMqMessage(id, ActivityStatusEnum.FINISH);
    }

    @Override
    public void finishActivityForReady(Long id) {
        ActivityEo eo = (ActivityEo)this.activityDas.selectByPrimaryKey(id);
        if (!ActivityStatusEnum.READY.getKey().equals(eo.getActivityStatus())) {
            throw new BusinessRuntimeException("\u6d3b\u52a8\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        this.finished(id);
        this.sendMqMessage(id, ActivityStatusEnum.FINISH);
    }

    @Override
    public Object queryActivityList(ActivityDto queryDto, int pageNum, int pageSize) {
        ActivityEo eo = new ActivityEo();
        BeanUtil.copyProperties((Object)queryDto, (Object)eo, (String[])new String[]{"activityStatusEnum", "auditStatusEnum"});
        eo.setOrderByDesc("createTime");
        if (null != queryDto.getActivityStatusEnum()) {
            eo.setActivityStatus(queryDto.getActivityStatusEnum().getKey());
        }
        if (null != queryDto.getAuditStatusEnum()) {
            eo.setAuditStatus(queryDto.getAuditStatusEnum().getKey());
        }
        this.fillTemplateQuery(queryDto, eo);
        if (pageNum > 0) {
            PageInfo pageInfo = this.activityDas.selectPage((BaseEo)eo, Integer.valueOf(pageNum), Integer.valueOf(pageSize));
            pageInfo.setList(BeanCopyUtil.copyCollections(pageInfo.getList(), ActivityRespDto.class, new String[0]));
            return pageInfo;
        }
        List select = this.activityDas.select((BaseEo)eo);
        return BeanCopyUtil.copyCollections(select, ActivityRespDto.class, new String[0]);
    }

    @Override
    public List<ActivityRespDto> queryActivityListByIds(List<Long> activityIds) {
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityIds(activityIds);
        return (List)this.queryActivityList(activityDto, 0, 0);
    }

    @Cacheable(key="'query_activity_list_' + #paramMD5", value={"cacheActivityList"}, unless="#result == null")
    public Object queryActivityListByIds(List<Long> activityIds, String paramMD5) {
        ActivityDto activityDto = new ActivityDto();
        activityDto.setActivityIds(activityIds);
        return this.queryActivityList(activityDto, 0, 0);
    }

    private void fillTemplateQuery(ActivityDto queryDto, ActivityEo eo) {
        ArrayList sqlFilters = Lists.newArrayList();
        if (!StringUtils.isEmpty((Object)queryDto.getActivityType())) {
            ActivityTemplateQueryReqDto reqDto = new ActivityTemplateQueryReqDto();
            reqDto.setActivityType(queryDto.getActivityType());
            List<ActivityTemplateRespDto> activityTemplateRespDtos = this.activityTemplateService.queryActivityTemplateList(reqDto);
            if (CollectionUtils.isEmpty(activityTemplateRespDtos)) {
                throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d3b\u52a8\u7c7b\u578b"}));
            }
            List collect = activityTemplateRespDtos.stream().map(ActivityTemplateRespDto::getId).collect(Collectors.toList());
            sqlFilters.add(SqlFilter.in((String)"activityTemplateId", collect));
        }
        if (!CollectionUtils.isEmpty((Collection)queryDto.getActivityStatus())) {
            sqlFilters.add(SqlFilter.in((String)"activityStatus", (Object)queryDto.getActivityStatus()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryDto.getActivityTemplateIds())) {
            sqlFilters.add(SqlFilter.in((String)"activityTemplateId", (Object)queryDto.getActivityTemplateIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryDto.getActivityIds())) {
            sqlFilters.add(SqlFilter.in((String)"id", (Object)queryDto.getActivityIds()));
        }
        eo.setSqlFilters((List)sqlFilters);
    }

    @Override
    public void joinSuccess(long userId, long activityId, String orderCode) {
        this.activityJoinLogService.enable(userId, activityId, null, orderCode);
    }

    @Override
    public void joinFailure(long userId, long activityId) {
        this.activityJoinLogService.disable(userId, activityId, null);
    }

    @Override
    public void enableById(long id) {
        ActivityStatusEnum changedStatusEnum;
        Date now;
        ActivityEo activityEo = (ActivityEo)this.activityDas.selectByPrimaryKey(Long.valueOf(id));
        if (activityEo == null) {
            throw new ProBizException(ProExceptionCode.RECORD_NOT_EXIST);
        }
        if (!ActivityStatusEnum.NEW.getKey().equals(activityEo.getActivityStatus()) && !ActivityStatusEnum.PAUSE.getKey().equals(activityEo.getActivityStatus())) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u6d3b\u52a8\u5904\u4e8e\u65b0\u5efa\u72b6\u6001\u624d\u80fd\u8fdb\u884c\u542f\u7528\u64cd\u4f5c"}));
        }
        if (activityEo.getOriginalActivityId() != null && !ActivityStatusEnum.PAUSE.getKey().equals(activityEo.getActivityStatus())) {
            this.handleOriginalActivity(activityEo.getOriginalActivityId());
        }
        Date beginTime = activityEo.getBeginTime();
        Date endTime = activityEo.getEndTime();
        if (endTime.before(now = new Date())) {
            changedStatusEnum = ActivityStatusEnum.FINISH;
            this.updateActivityStatus(id, changedStatusEnum);
        } else {
            if (ActivityStatusEnum.PAUSE.getKey().equals(activityEo.getActivityStatus())) {
                this.activityExtService.deleteActivityTask(id);
            }
            changedStatusEnum = ActivityStatusEnum.READY;
            this.updateActivityStatus(id, changedStatusEnum);
            if (beginTime.before(now)) {
                this.activate(id);
                this.createActivityTask(activityEo, "\u8425\u9500\u4e2d\u5fc3\uff1a\u6d3b\u52a8\u7ed3\u675f", "activityFinishTask", endTime, ActivityTaskTypeEnum.END_TASK);
            } else {
                this.createActivityTask(activityEo, "\u8425\u9500\u4e2d\u5fc3\uff1a\u6d3b\u52a8\u5f00\u59cb", "activityActivateTask", beginTime, ActivityTaskTypeEnum.BEGIN_TASK);
                this.createActivityTask(activityEo, "\u8425\u9500\u4e2d\u5fc3\uff1a\u6d3b\u52a8\u7ed3\u675f", "activityFinishTask", endTime, ActivityTaskTypeEnum.END_TASK);
            }
        }
        this.load(id);
        this.loadTobActivity(id);
        this.sendMqMessage(id, changedStatusEnum);
    }

    private void handleOriginalActivity(Long originalActivityId) {
        if (originalActivityId != null) {
            ActivityEo originalActivity = (ActivityEo)this.activityDas.selectByPrimaryKey(originalActivityId);
            if (Objects.equals(ActivityType.COUPON_TOB_ACTIVITY.getId(), originalActivity.getActivityTemplateId())) {
                CouponTemplateEo couponTemplateEo = new CouponTemplateEo();
                couponTemplateEo.setActivityId(originalActivityId);
                CouponTemplateEo templateEo = (CouponTemplateEo)this.couponTemplateDas.selectOne((BaseEo)couponTemplateEo);
                if (templateEo != null && !CouponTemplateStatusEnum.LOG.getStatus().equals(templateEo.getStatus())) {
                    this.couponTemplateExtService.log(templateEo.getId());
                }
            } else if (ActivityStatusEnum.READY.getKey().equals(originalActivity.getActivityStatus())) {
                this.finishActivityForReady(originalActivity.getId());
            } else if (ActivityStatusEnum.ACTIVATE.getKey().equals(originalActivity.getActivityStatus())) {
                this.finish(originalActivity.getId());
            }
            ActivityEo updateEo = new ActivityEo();
            updateEo.setId(originalActivity.getId());
            updateEo.setActivityStatus(ActivityStatusEnum.LOG.getKey());
            this.activityDas.updateSelective((BaseEo)updateEo);
        }
    }

    private void loadTobActivity(long activityId) {
        ActivityRespDto activityRespDto = this.getActivity(activityId);
        if (!(activityRespDto.getActivityTemplateId().equals(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId()) || activityRespDto.getActivityTemplateId().equals(ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId()) || activityRespDto.getActivityTemplateId().equals(ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId()) || activityRespDto.getActivityTemplateId().equals(ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.getId()) || activityRespDto.getActivityTemplateId().equals(ActivityType.COUPON_TOB_ACTIVITY.getId()) || activityRespDto.getActivityTemplateId().equals(ActivityType.COMBINATION_ACTIVITY.getId()) || activityRespDto.getActivityTemplateId().equals(ActivityType.EXCHANGE_ACTIVITY.getId()))) {
            logger.info("\u3010activityId={}\u3011\u975eTob\u6d3b\u52a8\u4e0d\u52a0\u8f7d\u7f13\u5b58", (Object)activityId);
            return;
        }
        long expireTime = activityRespDto.getEndTime().getTime() - System.currentTimeMillis();
        int seconds = (int)(expireTime / 1000L);
        List<ConditionTemplateRespDto> conditionTpDtos = this.conditionTemplateService.queryConditionTemplateBatch(Lists.newArrayList((Object[])new Long[]{1196944771412880293L, 5196944771412880296L}));
        logger.info("\u3010activityId={}\u3011Tob\u6d3b\u52a8\u76ee\u6807\u5ba2\u6237\u6761\u4ef6\u548c\u76ee\u6807\u5546\u57ce\u7c7b\u578b\u6761\u4ef6\u7f13\u5b58\u52a0\u8f7d\u5f00\u59cb=====", (Object)activityId);
        conditionTpDtos.forEach(conditionTpDto -> {
            for (ConditionRespDto conditionDto : activityRespDto.getConditionDtos()) {
                if (!conditionDto.getConditionTemplateId().equals(conditionTpDto.getId())) continue;
                ConditionTemplate conditionTemplate = ConditionTemplate.getCondition(conditionTpDto);
                if (!(conditionTemplate instanceof ILoadConditionTemplate)) break;
                JSONObject activityParams = JSON.parseObject((String)conditionDto.getConditionParams());
                TemplateDefine define = (TemplateDefine)JSON.parseObject((String)conditionTpDto.getConditionDefine(), TemplateDefine.class);
                ILoadConditionTemplate loadConditionTemplate = (ILoadConditionTemplate)((Object)conditionTemplate);
                loadConditionTemplate.load(define, conditionDto, (Map<String, ?>)activityParams, seconds);
                break;
            }
        });
        logger.info("\u3010activityId={}\u3011Tob\u6d3b\u52a8\u76ee\u6807\u5ba2\u6237\u6761\u4ef6\u548c\u76ee\u6807\u5546\u57ce\u7c7b\u578b\u6761\u4ef6\u7f13\u5b58\u52a0\u8f7d\u7ed3\u675f=====", (Object)activityId);
    }

    @Override
    public void reloadTobActivity(long activityId) {
        ActivityRespDto activityRespDto = this.getActivity(activityId);
        if (!(activityRespDto.getActivityTemplateId().equals(ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId()) || activityRespDto.getActivityTemplateId().equals(ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId()) || activityRespDto.getActivityTemplateId().equals(ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId()) || activityRespDto.getActivityTemplateId().equals(ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.getId()) || activityRespDto.getActivityTemplateId().equals(ActivityType.COUPON_TOB_ACTIVITY.getId()) || activityRespDto.getActivityTemplateId().equals(ActivityType.COMBINATION_ACTIVITY.getId()) || activityRespDto.getActivityTemplateId().equals(ActivityType.EXCHANGE_ACTIVITY.getId()))) {
            logger.info("[\u91cd\u65b0\u52a0\u8f7d\u6d3b\u52a8\u6761\u4ef6],\u975eTob\u6d3b\u52a8\u4e0d\u52a0\u8f7d\u7f13\u5b58\uff0c\u6d3b\u52a8ID:{}", (Object)activityId);
            return;
        }
        long expireTime = activityRespDto.getEndTime().getTime() - System.currentTimeMillis();
        int seconds = (int)(expireTime / 1000L);
        List<ConditionTemplateRespDto> conditionTpDtos = this.conditionTemplateService.queryConditionTemplateBatch(Lists.newArrayList((Object[])new Long[]{1196944771412880293L, 5196944771412880296L}));
        logger.info("[\u91cd\u65b0\u52a0\u8f7d\u6d3b\u52a8\u6761\u4ef6],Tob\u6d3b\u52a8\u76ee\u6807\u5ba2\u6237\u6761\u4ef6\u548c\u76ee\u6807\u5546\u57ce\u7c7b\u578b\u6761\u4ef6\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d\u5f00\u59cb\uff0c\u6d3b\u52a8ID:{}", (Object)activityId);
        conditionTpDtos.forEach(conditionTpDto -> {
            for (ConditionRespDto conditionDto : activityRespDto.getConditionDtos()) {
                if (!conditionDto.getConditionTemplateId().equals(conditionTpDto.getId())) continue;
                ConditionTemplate conditionTemplate = ConditionTemplate.getCondition(conditionTpDto);
                if (!(conditionTemplate instanceof ILoadConditionTemplate)) break;
                JSONObject activityParams = JSON.parseObject((String)conditionDto.getConditionParams());
                TemplateDefine define = (TemplateDefine)JSON.parseObject((String)conditionTpDto.getConditionDefine(), TemplateDefine.class);
                ILoadConditionTemplate loadConditionTemplate = (ILoadConditionTemplate)((Object)conditionTemplate);
                loadConditionTemplate.reload(define, conditionDto, (Map<String, ?>)activityParams, seconds);
                break;
            }
        });
        logger.info("[\u91cd\u65b0\u52a0\u8f7d\u6d3b\u52a8\u6761\u4ef6],Tob\u6d3b\u52a8\u76ee\u6807\u5ba2\u6237\u6761\u4ef6\u548c\u76ee\u6807\u5546\u57ce\u7c7b\u578b\u6761\u4ef6\u7f13\u5b58\u91cd\u65b0\u52a0\u8f7d\u7ed3\u675f\uff0c\u6d3b\u52a8ID:{}", (Object)activityId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateActivityStatus(long acId, ActivityStatusEnum status) {
        ActivityEo updateEo = ActivityEo.newInstance();
        updateEo.setId(Long.valueOf(acId));
        updateEo.setActivityStatus(status.getKey());
        this.activityDas.updateSelective((BaseEo)updateEo);
    }

    private void sendMqMessage(Long activityId, ActivityStatusEnum activityStatusEnum) {
        String bizId = IdGenrator.getDistributedId() + "";
        ActivityStatusChangeMessage message = new ActivityStatusChangeMessage();
        message.setBizId(bizId);
        message.setActivityId(activityId);
        message.setActivityStatus(activityStatusEnum);
        logger.info("\u53d1\u9001\u6d3b\u52a8\u72b6\u6001\u53d8\u66f4\u6d88\u606f{}", (Object)JSON.toJSONString((Object)message));
        this.commonsMqService.sendDelaySingleMessage("ACTIVITY_STATUS_CHANGE", (Object)message, Long.valueOf(1L));
    }

    @Override
    public void pauseById(long id) {
        ActivityEo activityEo = (ActivityEo)this.activityDas.selectByPrimaryKey(Long.valueOf(id));
        if (activityEo == null) {
            throw new ProBizException(ProExceptionCode.RECORD_NOT_EXIST);
        }
        if (!activityEo.getActivityStatus().equals(ActivityStatusEnum.ACTIVATE.getKey())) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u6d3b\u52a8\u72b6\u6001\u4e0d\u5141\u8bb8\u6682\u505c\u6d3b\u52a8"}));
        }
        activityEo.setActivityStatus(ActivityStatusEnum.PAUSE.getKey());
        this.activityDas.updateSelective((BaseEo)activityEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(long id) {
        ActivityEo activityEo = (ActivityEo)this.activityDas.selectByPrimaryKey(Long.valueOf(id));
        if (activityEo.getAuditStatus().equals(AuditStatusEnum.AUDIT_PASS.getKey())) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u6d3b\u52a8\u4e0d\u5141\u8bb8\u5220\u9664"}));
        }
        this.activityDas.logicDelete((BaseEo)activityEo);
        this.conditionService.deleteByActivityId(id);
        this.actionService.deleteByActivityId(id);
        this.activityItemService.deleteByActId(id);
        this.activityUserMappingService.deleteActivityUserMapping(id);
        ActivityAuditEo activityAuditEo = ActivityAuditEo.newInstance();
        activityAuditEo.setActivityId(Long.valueOf(id));
        activityAuditEo.setInstanceId(activityEo.getInstanceId());
        activityAuditEo.setTenantId(activityEo.getTenantId());
        this.activityAuditDas.logicDelete((BaseEo)activityAuditEo);
        this.activityRelationService.deleteActivityRelationByBizId(id);
        CouponTemplateEo couponTemplateEo = CouponTemplateEo.newInstance();
        couponTemplateEo.setActivityId(Long.valueOf(id));
        couponTemplateEo.setInstanceId(activityEo.getInstanceId());
        couponTemplateEo.setTenantId(activityEo.getTenantId());
        List couponTemplateEoList = this.couponTemplateDas.select((BaseEo)couponTemplateEo);
        for (CouponTemplateEo eo : couponTemplateEoList) {
            this.iCouponTemplateService.removeCouponTemplate(eo.getId());
        }
        if (Objects.equals(ActivityType.EXCHANGE_ACTIVITY.getId(), activityEo.getActivityTemplateId())) {
            this.itemActivityTagService.deleteSingleItem(id);
        }
    }

    @Override
    public List<ItemActivityPriceMkRespDto> queryItemActivityPrice(ActivityItemListReqDto activityItemListReqDto) {
        ActivityItemReqDto activityItemReqDto;
        List<ItemActivityTagDto> tagDtos;
        List itemIds = activityItemListReqDto.getActivityItemReqDtoList().stream().map(ActivityItemReqDto::getItemId).collect(Collectors.toList());
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setDimensionList((List)Lists.newArrayList((Object[])new Integer[]{ActivityDimensionEnum.ITEM.getKey()}));
        queryReqDto.setInstanceId(activityItemListReqDto.getInstanceId());
        queryReqDto.setTenantId(activityItemListReqDto.getTenantId());
        queryReqDto.setItemIdList(itemIds);
        queryReqDto.setPreheatStartTime(new Date());
        List<ItemActivityTagDto> tags = this.itemActivityTagService.queryList(queryReqDto);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(tags)) {
            return new ArrayList<ItemActivityPriceMkRespDto>(1);
        }
        ArrayList<ItemActivityPriceMkRespDto> itemActivityPriceRespDtos = new ArrayList<ItemActivityPriceMkRespDto>();
        Map<Long, List<ItemActivityTagDto>> itemTagsMap = tags.stream().collect(Collectors.groupingBy(ItemActivityTagDto::getItemId));
        Iterator iterator = activityItemListReqDto.getActivityItemReqDtoList().iterator();
        while (iterator.hasNext() && !org.apache.commons.collections.CollectionUtils.isEmpty(tagDtos = itemTagsMap.get((activityItemReqDto = (ActivityItemReqDto)iterator.next()).getItemId()))) {
            ItemActivityPriceMkRespDto activityPrice = this.getItemActivityPriceRespDto(activityItemReqDto.getSkuId(), activityItemReqDto.getItemId(), tagDtos.get(0));
            if (activityPrice == null) {
                activityPrice = new ItemActivityPriceMkRespDto();
            }
            activityPrice.setSkuId(activityItemReqDto.getSkuId());
            itemActivityPriceRespDtos.add(activityPrice);
        }
        return itemActivityPriceRespDtos;
    }

    private ItemActivityPriceMkRespDto getItemActivityPriceRespDto(Long skuId, Long itemId, ItemActivityTagDto tagDto) {
        Long activityId = tagDto.getActivityId();
        List<ActivityItemRespDto> activityItems = this.activityItemService.queryActivityItems(activityId, itemId);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(activityItems)) {
            return null;
        }
        try {
            ActivityEo activityEo = (ActivityEo)this.activityDas.selectByPrimaryKey(activityId);
            if (activityEo.getActivityTemplateId().equals(ActivityType.GROUP_ACTIVITY.getId())) {
                return null;
            }
            for (ActivityItemRespDto activityItemRespDto : activityItems) {
                if (skuId == null || activityItemRespDto.getSkuId() == null || !activityItemRespDto.getSkuId().equals(skuId)) continue;
                ItemActivityPriceMkRespDto itemActivityPriceRespDto = new ItemActivityPriceMkRespDto();
                itemActivityPriceRespDto.setSkuId(skuId);
                itemActivityPriceRespDto.setActivityPrice(activityItemRespDto.getActivityPrice());
                itemActivityPriceRespDto.setActivityType(ActivityType.getByType((Long)activityEo.getActivityTemplateId()));
                itemActivityPriceRespDto.setActivityId(activityEo.getId());
                return itemActivityPriceRespDto;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return null;
    }

    @Override
    public List<ActivityAuditEo> queryAuditData(long activityId) {
        ActivityAuditEo queryEo = ActivityAuditEo.newInstance();
        queryEo.setActivityId(Long.valueOf(activityId));
        return this.activityAuditDas.select((BaseEo)queryEo);
    }

    @Override
    public List<ActivityRespExtDto> inverseQuery(long itemId, long userId, boolean validStatus) {
        if (itemId < 1L && userId < 1L) {
            return Lists.newLinkedList();
        }
        Set<Object> participatory = Sets.newHashSet();
        List<Long> itemMappingAcIds = this.activityItemService.queryByItemId(itemId);
        List<Long> userMappingAcIds = this.activityUserMappingService.queryByUserId(userId);
        if (itemId > 0L && userId > 0L) {
            org.apache.commons.collections.CollectionUtils.intersection(itemMappingAcIds, userMappingAcIds);
        } else {
            participatory = itemId > 0L ? itemMappingAcIds.stream().collect(Collectors.toSet()) : userMappingAcIds.stream().collect(Collectors.toSet());
        }
        LinkedList<ActivityRespExtDto> result = new LinkedList<ActivityRespExtDto>();
        for (Long acId : participatory) {
            ActivityRespDto temp = this.getActivity(acId);
            if (validStatus && !temp.getActivityStatus().equals(ActivityStatusEnum.ACTIVATE.getKey()) && !temp.getActivityStatus().equals(ActivityStatusEnum.READY.getKey())) continue;
            ActivityRespExtDto activity = BeanCopyUtil.copyProperties(ActivityRespExtDto.class, temp, new String[0]);
            result.add(activity);
            Set filterEntrySet = SpringBeanUtil.getApplicationContext().getBeansOfType(IQueryActivityInfoFilter.class).entrySet();
            for (Map.Entry entry : filterEntrySet) {
                IQueryActivityInfoFilter filter = (IQueryActivityInfoFilter)entry.getValue();
                if (!filter.support(activity.getActivityTemplateId())) continue;
                filter.filter(activity);
            }
        }
        return result;
    }

    @Override
    public ActivityRespDto getById(Long activityId) {
        ActivityEo activityEo = (ActivityEo)this.activityDas.selectByPrimaryKey(activityId);
        if (null == activityEo) {
            throw new ProBizException(ProExceptionCode.PARAMS_ERR.format(new String[]{"\u6d3b\u52a8ID\u4e0d\u5b58\u5728"}));
        }
        ActivityRespDto activityDto = BeanCopyUtil.copyProperties(ActivityRespDto.class, activityEo, new String[0]);
        ActivityTemplateRespDto tmeplateDto = this.activityTemplateService.queryActivityTemplateDetail(activityEo.getActivityTemplateId());
        activityDto.setActivityTemplate(tmeplateDto);
        return activityDto;
    }

    @Override
    public ActivityRespDto queryById(Long activityId) {
        ActivityEo activityEo = (ActivityEo)this.activityDas.selectByPrimaryKey(activityId);
        if (null == activityEo) {
            return null;
        }
        ActivityRespDto activityDto = BeanCopyUtil.copyProperties(ActivityRespDto.class, activityEo, new String[0]);
        return activityDto;
    }

    @Override
    public List<ActivityRespDto> queryAllActsByStatus(List<String> statusList) {
        ArrayList result = Lists.newArrayList();
        PageInfo<ActivityRespDto> pageInfo = this.activityExtQueryService.queryActivityByActivityStatus(statusList, null, 1, 1);
        long total = pageInfo.getTotal();
        int count = total % 100L == 0L ? (int)(total / 100L) : (int)(total / 100L + 1L);
        for (int i = 1; i <= count; ++i) {
            pageInfo = this.activityExtQueryService.queryActivityByActivityStatus(statusList, null, i, 100);
            if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) continue;
            result.addAll(pageInfo.getList());
        }
        return result;
    }

    @Override
    public void load(Long activityId) {
        ActivityRespDto activityRespDto = this.getActivity(activityId);
        if (!activityRespDto.getActivityTemplateId().equals(ActivityType.SECKILL_ACTIVITY.getId()) && !activityRespDto.getActivityTemplateId().equals(ActivityType.SECKILL_TOB_ACTIVITY.getId())) {
            logger.info("\u3010activityId={}\u3011\u975e\u79d2\u6740\u6d3b\u52a8\u4e0d\u52a0\u8f7d\u7f13\u5b58", (Object)activityId);
            return;
        }
        long expireTime = activityRespDto.getEndTime().getTime() - System.currentTimeMillis();
        int seconds = (int)(expireTime / 1000L);
        List<Long> conditionTpIds = activityRespDto.getConditionDtos().stream().map(ConditionRespDto::getConditionTemplateId).collect(Collectors.toList());
        List<ConditionTemplateRespDto> conditionTpDtos = this.conditionTemplateService.queryConditionTemplateBatch(conditionTpIds);
        logger.info("\u3010activityId={}\u3011\u79d2\u6740\u6d3b\u52a8\u7f13\u5b58\u52a0\u8f7d\u5f00\u59cb=====", (Object)activityId);
        conditionTpDtos.forEach(conditionTpDto -> {
            for (ConditionRespDto conditionDto : activityRespDto.getConditionDtos()) {
                ConditionTemplate conditionTemplate;
                if (!conditionDto.getConditionTemplateId().equals(conditionTpDto.getId()) || !((conditionTemplate = ConditionTemplate.getCondition(conditionTpDto)) instanceof ILoadConditionTemplate)) continue;
                JSONObject activityParams = JSON.parseObject((String)conditionDto.getConditionParams());
                TemplateDefine define = (TemplateDefine)JSON.parseObject((String)conditionTpDto.getConditionDefine(), TemplateDefine.class);
                ILoadConditionTemplate loadConditionTemplate = (ILoadConditionTemplate)((Object)conditionTemplate);
                loadConditionTemplate.load(define, conditionDto, (Map<String, ?>)activityParams, seconds);
            }
        });
        logger.info("\u3010activityId={}\u3011\u79d2\u6740\u6d3b\u52a8\u7f13\u5b58\u52a0\u8f7d\u7ed3\u675f=====", (Object)activityId);
    }

    @Override
    public List<Long> queryByIds(List<Long> ids, List<String> statusList, List<Long> templateId) {
        ActivityEo param = new ActivityEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"id", ids));
        sqlFilters.add(SqlFilter.in((String)"activity_status", statusList));
        sqlFilters.add(SqlFilter.in((String)"activity_template_id", templateId));
        param.setSqlFilters((List)sqlFilters);
        List activityEos = this.activityDas.select((BaseEo)param);
        return activityEos.stream().map(BaseEo::getId).collect(Collectors.toList());
    }

    @Override
    public List<ActivityRespDto> queryByIds(List<Long> activityIds) {
        ActivityEo param = new ActivityEo();
        ArrayList sqlFilters = Lists.newArrayList();
        param.setSqlFilters((List)sqlFilters);
        sqlFilters.add(SqlFilter.in((String)"id", activityIds));
        List activityEos = this.activityDas.select((BaseEo)param);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)activityEos, ActivityRespDto.class);
        return list;
    }

    @Override
    public List<Long> queryActivityTemIdsByIds(Set<Long> activityIds) {
        if (CollectionUtils.isEmpty(activityIds)) {
            return Lists.newArrayList();
        }
        return this.activityDas.queryActivityTemIdsByIds(activityIds);
    }

    @Override
    public void pauseExtById(Long id) {
        this.pauseById(id);
        this.sendMqMessage(id, ActivityStatusEnum.PAUSE);
    }
}

