/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.exchange.account.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ExchangeBalanceTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeAccountUseReq;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceAccountReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceRollBackReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ManualAdjustReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.response.ExchangeBalanceAccountRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.ExchangeAdjustTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.ExchangeStatementChangeTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.TurnoverChangeTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExcRuleContentDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExchangeRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.exchange.account.service.IExchangeBalanceAccountService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.enums.UnitEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ConditionDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceAccountDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceStatementDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceTurnoverDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.eo.ExchangeBalanceAccountEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.eo.ExchangeBalanceStatementEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.eo.ExchangeBalanceTurnoverEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ExchangeBalanceAccountServiceImpl
implements IExchangeBalanceAccountService {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeBalanceAccountServiceImpl.class);
    @Autowired
    private IActivityService activityService;
    @Resource
    private ExchangeBalanceAccountDas exchangeBalanceAccountDas;
    @Resource
    private ILockService lockService;
    @Autowired
    private ExchangeBalanceTurnoverDas exchangeBalanceTurnoverDas;
    @Autowired
    private ExchangeBalanceStatementDas exchangeBalanceStatementDas;
    @Autowired
    private ConditionDas conditionDas;
    private static final Long TEMPLATE_ID = 1196944771412880296L;
    @Resource
    public PlatformTransactionManager platformTransactionManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addExchangeBalanceAccount(ExchangeBalanceAccountReqDto addReqDto) {
        ExchangeBalanceAccountEo exchangeBalanceAccountEo = new ExchangeBalanceAccountEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)exchangeBalanceAccountEo);
        this.exchangeBalanceAccountDas.insert((BaseEo)exchangeBalanceAccountEo);
        return exchangeBalanceAccountEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyExchangeBalanceAccount(ExchangeBalanceAccountReqDto modifyReqDto) {
        ExchangeBalanceAccountEo exchangeBalanceAccountEo = new ExchangeBalanceAccountEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)exchangeBalanceAccountEo);
        this.exchangeBalanceAccountDas.updateSelective((BaseEo)exchangeBalanceAccountEo);
    }

    @Override
    public ExchangeBalanceAccountRespDto queryById(Long id) {
        ExchangeBalanceAccountEo exchangeBalanceAccountEo = (ExchangeBalanceAccountEo)this.exchangeBalanceAccountDas.selectByPrimaryKey(id);
        ExchangeBalanceAccountRespDto exchangeBalanceAccountRespDto = new ExchangeBalanceAccountRespDto();
        DtoHelper.eo2Dto((BaseEo)exchangeBalanceAccountEo, (BaseVo)exchangeBalanceAccountRespDto);
        this.setExtDto(exchangeBalanceAccountRespDto, BigDecimal.ZERO);
        return exchangeBalanceAccountRespDto;
    }

    private void setExtDto(ExchangeBalanceAccountRespDto exchangeBalanceAccountRespDto, BigDecimal orderNum) {
        BigDecimal totalAvailableBalance;
        exchangeBalanceAccountRespDto.setAvailableBalance(this.ofBigDecimalZero(exchangeBalanceAccountRespDto.getAvailableBalance()));
        exchangeBalanceAccountRespDto.setUsedBalance(this.ofBigDecimalZero(exchangeBalanceAccountRespDto.getUsedBalance()));
        exchangeBalanceAccountRespDto.setAdvanceTotalBalance(this.ofBigDecimalZero(exchangeBalanceAccountRespDto.getAdvanceTotalBalance()));
        exchangeBalanceAccountRespDto.setAdvanceSurplusBalance(this.ofBigDecimalZero(exchangeBalanceAccountRespDto.getAdvanceSurplusBalance()).add(orderNum));
        BigDecimal reduce = this.getFreeze(exchangeBalanceAccountRespDto.getId());
        exchangeBalanceAccountRespDto.setFreeze(reduce);
        String orderAttachment = ServiceContext.getContext().getAttachment("order_freeze_" + exchangeBalanceAccountRespDto.getId());
        if (StringUtils.isNotBlank((CharSequence)orderAttachment)) {
            exchangeBalanceAccountRespDto.setFreeze(new BigDecimal(orderAttachment));
            exchangeBalanceAccountRespDto.setAvailableBalance(exchangeBalanceAccountRespDto.getAvailableBalance().add(exchangeBalanceAccountRespDto.getFreeze()));
        }
        exchangeBalanceAccountRespDto.setAdvanceUsedBalance(exchangeBalanceAccountRespDto.getAdvanceTotalBalance().subtract(exchangeBalanceAccountRespDto.getAdvanceSurplusBalance()));
        exchangeBalanceAccountRespDto.setTotalBalance(exchangeBalanceAccountRespDto.getAvailableBalance().add(exchangeBalanceAccountRespDto.getUsedBalance()));
        BigDecimal allUseBalance = exchangeBalanceAccountRespDto.getUsedBalance().add(exchangeBalanceAccountRespDto.getAdvanceUsedBalance());
        if (exchangeBalanceAccountRespDto.getTotalBalance().compareTo(allUseBalance) > 0) {
            logger.info("\u7d2f\u79ef\u989d\u5ea6-\u9884\u652f\u5df2\u7528\u989d\u5ea6-\u8ba2\u5355\u5df2\u7528\u989d\u5ea6\uff09>0 {}", (Object)exchangeBalanceAccountRespDto.getId());
            totalAvailableBalance = exchangeBalanceAccountRespDto.getTotalBalance().add(exchangeBalanceAccountRespDto.getAdvanceSurplusBalance()).subtract(exchangeBalanceAccountRespDto.getUsedBalance());
            if (exchangeBalanceAccountRespDto.getAvailableBalance().compareTo(exchangeBalanceAccountRespDto.getAdvanceTotalBalance()) >= 0 && exchangeBalanceAccountRespDto.getAdvanceSurplusBalance().compareTo(BigDecimal.ZERO) <= 0) {
                totalAvailableBalance = totalAvailableBalance.subtract(exchangeBalanceAccountRespDto.getAdvanceUsedBalance());
            }
        } else {
            logger.info("\u7d2f\u79ef\u989d\u5ea6-\u9884\u652f\u5df2\u7528\u989d\u5ea6-\u8ba2\u5355\u5df2\u7528\u989d\u5ea6\uff09<=0 {}", (Object)exchangeBalanceAccountRespDto.getId());
            if (exchangeBalanceAccountRespDto.getAdvanceSurplusBalance().compareTo(BigDecimal.ZERO) <= 0) {
                logger.info("\u4e14\u9884\u652f\u5269\u4f59\u989d\u5ea6\u5c0f\u4e8e\u7b49\u4e8e0 {}", (Object)exchangeBalanceAccountRespDto.getId());
                totalAvailableBalance = exchangeBalanceAccountRespDto.getAvailableBalance().subtract(exchangeBalanceAccountRespDto.getAdvanceUsedBalance());
            } else {
                logger.info("\u4e14\u9884\u652f\u5269\u4f59\u989d\u5ea6\u5927\u4e8e0 {}", (Object)exchangeBalanceAccountRespDto.getId());
                totalAvailableBalance = exchangeBalanceAccountRespDto.getAdvanceSurplusBalance();
            }
        }
        exchangeBalanceAccountRespDto.setTotalAvailableBalance(totalAvailableBalance);
        if (exchangeBalanceAccountRespDto.getAvailableBalance().compareTo(exchangeBalanceAccountRespDto.getAdvanceTotalBalance()) >= 0 && exchangeBalanceAccountRespDto.getAdvanceSurplusBalance().compareTo(BigDecimal.ZERO) <= 0) {
            exchangeBalanceAccountRespDto.setAdvanceReturn(Boolean.TRUE.booleanValue());
        } else {
            exchangeBalanceAccountRespDto.setAdvanceReturn(Boolean.FALSE.booleanValue());
        }
    }

    @NotNull
    private BigDecimal getFreeze(Long accountId) {
        List exchangeBalanceTurnoverEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.exchangeBalanceTurnoverDas.filter().eq((Object)"balance_account_id", (Object)accountId)).eq((Object)"balance_type", (Object)ExchangeBalanceTypeEnum.FREEZE.getKey())).list();
        return exchangeBalanceTurnoverEos.stream().map(ExchangeBalanceTurnoverEo::getChangeBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal getOrderFreeze(Long accountId, String orderNo) {
        List exchangeBalanceTurnoverEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.exchangeBalanceTurnoverDas.filter().eq((Object)"balance_account_id", (Object)accountId)).eq((Object)"balance_type", (Object)ExchangeBalanceTypeEnum.FREEZE.getKey())).eq((Object)"order_no", (Object)orderNo)).eq((Object)"status", (Object)0)).list();
        return exchangeBalanceTurnoverEos.stream().map(ExchangeBalanceTurnoverEo::getChangeBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Override
    public ExchangeBalanceAccountRespDto queryByActivityIdAndCustomerId(Long activityId, Long customerId) {
        ExchangeBalanceAccountRespDto exchangeBalanceAccountRespDto = null;
        if (activityId == null || customerId == null) {
            return exchangeBalanceAccountRespDto;
        }
        ExchangeBalanceAccountEo eo = new ExchangeBalanceAccountEo();
        eo.setActivityId(activityId);
        eo.setCustomerId(customerId);
        eo = (ExchangeBalanceAccountEo)this.exchangeBalanceAccountDas.selectOne((BaseEo)eo);
        if (eo != null) {
            exchangeBalanceAccountRespDto = new ExchangeBalanceAccountRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)exchangeBalanceAccountRespDto);
            this.setExtDto(exchangeBalanceAccountRespDto, BigDecimal.ZERO);
        }
        return exchangeBalanceAccountRespDto;
    }

    @Override
    public ExchangeBalanceAccountRespDto queryByActivityIdAndCustomerIdAndIgnoreOrder(Long activityId, Long customerId, BigDecimal orderNum) {
        ExchangeBalanceAccountRespDto exchangeBalanceAccountRespDto = null;
        if (activityId != null && customerId != null) {
            ExchangeBalanceAccountEo eo = new ExchangeBalanceAccountEo();
            eo.setActivityId(activityId);
            eo.setCustomerId(customerId);
            eo = (ExchangeBalanceAccountEo)this.exchangeBalanceAccountDas.selectOne((BaseEo)eo);
            if (eo != null) {
                exchangeBalanceAccountRespDto = new ExchangeBalanceAccountRespDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)exchangeBalanceAccountRespDto);
                this.setExtDto(exchangeBalanceAccountRespDto, orderNum);
            }
            return exchangeBalanceAccountRespDto;
        }
        return exchangeBalanceAccountRespDto;
    }

    @Override
    public PageInfo<ExchangeBalanceAccountRespDto> queryByPage(ExchangeBalanceAccountReqDto exchangeBalanceAccountReqDto) {
        ExchangeBalanceAccountEo exchangeBalanceAccountEo = new ExchangeBalanceAccountEo();
        DtoHelper.dto2Eo((BaseVo)exchangeBalanceAccountReqDto, (BaseEo)exchangeBalanceAccountEo);
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.exchangeBalanceAccountDas.filter().setEntity((Object)exchangeBalanceAccountEo)).in(CollectionUtils.isNotEmpty((Collection)exchangeBalanceAccountReqDto.getCustomerIds()), (Object)"customer_id", (Collection)exchangeBalanceAccountReqDto.getCustomerIds())).page(exchangeBalanceAccountReqDto.getPageNum(), exchangeBalanceAccountReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ExchangeBalanceAccountRespDto.class);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            dtoList.stream().forEach(dto -> this.setExtDto((ExchangeBalanceAccountRespDto)dto, BigDecimal.ZERO));
        }
        dtoPageInfo.setList(dtoList);
        if (exchangeBalanceAccountReqDto.isNeedDiscountUnit() && CollectionUtils.isNotEmpty(dtoList)) {
            Set activityIds = dtoList.stream().map(ExchangeBalanceAccountRespDto::getActivityId).collect(Collectors.toSet());
            LambdaQueryWrapper conditionWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)conditionWrapper.eq(StdConditionEo::getConditionTemplateId, (Object)TEMPLATE_ID)).eq(BaseEo::getDr, (Object)0)).in(StdConditionEo::getActivityId, activityIds);
            List conditionEos = this.conditionDas.getMapper().selectList((Wrapper)conditionWrapper);
            Map<Long, ExchangeRule> conditionParamMap = conditionEos.stream().collect(Collectors.toMap(StdConditionEo::getActivityId, this::converter, (e1, e2) -> e1));
            for (ExchangeBalanceAccountRespDto exchangeBalanceAccountRespDto : dtoList) {
                ExchangeRule exchangeRule = conditionParamMap.get(exchangeBalanceAccountRespDto.getActivityId());
                if (exchangeRule == null || !CollectionUtils.isNotEmpty((Collection)exchangeRule.getExcRuleContents())) continue;
                ExcRuleContentDto excRuleContentDto = (ExcRuleContentDto)exchangeRule.getExcRuleContents().get(0);
                exchangeBalanceAccountRespDto.setDiscountUnit(excRuleContentDto.getDiscountUnit());
                if (UnitEnum.MONEY.getType().equals(excRuleContentDto.getDiscountUnit())) {
                    exchangeBalanceAccountRespDto.setDiscountUnitName("\u91d1\u989d");
                    continue;
                }
                exchangeBalanceAccountRespDto.setDiscountUnitName("\u6570\u91cf");
            }
        }
        return dtoPageInfo;
    }

    private ExchangeRule converter(ConditionEo conditionEo) {
        JSONObject jsonObject = JSON.parseObject((String)conditionEo.getConditionParams());
        ExchangeRule exchangeRule = (ExchangeRule)JSON.parseObject((String)jsonObject.getString("ExchangeCondition.rule"), ExchangeRule.class);
        return exchangeRule;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void useExchangeBalanceAccount(ExchangeAccountUseReq exchangeAccountUseReq) {
        logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 \u8bf7\u6c42\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)exchangeAccountUseReq));
        if (exchangeAccountUseReq.getBigBRequestFlag() != null && exchangeAccountUseReq.getBigBRequestFlag().booleanValue()) {
            this.useExchangeBalanceAccountDb(exchangeAccountUseReq);
        } else {
            this.useExchangeBalanceAccountXb(exchangeAccountUseReq);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void useExchangeBalanceAccountDb(ExchangeAccountUseReq exchangeAccountUseReq) {
        this.verifyParam(exchangeAccountUseReq);
        String lockKey = exchangeAccountUseReq.getActivityId() + "_" + exchangeAccountUseReq.getCustomerId();
        Mutex lock = this.lockService.lock("mk_exchange_balance_account", lockKey, 1500, 1500, TimeUnit.MILLISECONDS);
        try {
            ExchangeBalanceAccountRespDto accountRespDto = this.queryByActivityIdAndCustomerId(exchangeAccountUseReq.getActivityId(), exchangeAccountUseReq.getCustomerId());
            BigDecimal orderFreeze = this.getOrderFreeze(accountRespDto.getId(), exchangeAccountUseReq.getOrderNo());
            logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 \u83b7\u53d6\u5230\u6362\u8d2d\u8d26\u6237 {}", (Object)JSON.toJSONString((Object)accountRespDto));
            if (accountRespDto == null || accountRespDto.getId() == null) {
                throw new BizException("\u7d2f\u8ba1\u989d\u5ea6\u8d26\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BigDecimal finalAddBalance = BigDecimal.ZERO;
            BigDecimal finalSubBalance = BigDecimal.ZERO;
            BigDecimal finalAdvanceSubBalance = BigDecimal.ZERO;
            int step = 0;
            boolean freezeAdd = TurnoverChangeTypeEnum.SUBMIT_ORDER.equals((Object)exchangeAccountUseReq.getTurnoverChangeTypeEnum());
            if (accountRespDto.getAdvanceSurplusBalance().compareTo(BigDecimal.ZERO) > 0 && exchangeAccountUseReq.getChangeUsedBalance().compareTo(BigDecimal.ZERO) > 0) {
                if (accountRespDto.getAdvanceSurplusBalance().compareTo(exchangeAccountUseReq.getChangeUsedBalance()) >= 0) {
                    if (exchangeAccountUseReq.getChangeAvaBalance().compareTo(BigDecimal.ZERO) > 0) {
                        finalAdvanceSubBalance = exchangeAccountUseReq.getChangeUsedBalance();
                        finalAddBalance = exchangeAccountUseReq.getChangeAvaBalance();
                        step = freezeAdd ? 9 : 5;
                    } else {
                        finalAdvanceSubBalance = exchangeAccountUseReq.getChangeUsedBalance();
                        step = 3;
                    }
                } else {
                    BigDecimal tmpCalBalance = accountRespDto.getAdvanceSurplusBalance().add(accountRespDto.getAvailableBalance()).add(exchangeAccountUseReq.getChangeAvaBalance()).add(orderFreeze).subtract(exchangeAccountUseReq.getChangeUsedBalance());
                    if (tmpCalBalance.compareTo(BigDecimal.ZERO) < 0) {
                        throw new BizException("\u6362\u8d2d\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3");
                    }
                    finalAddBalance = exchangeAccountUseReq.getChangeAvaBalance();
                    finalSubBalance = exchangeAccountUseReq.getChangeUsedBalance().subtract(accountRespDto.getAdvanceSurplusBalance());
                    finalAdvanceSubBalance = accountRespDto.getAdvanceSurplusBalance();
                    step = exchangeAccountUseReq.getChangeAvaBalance().compareTo(BigDecimal.ZERO) > 0 ? (freezeAdd ? 10 : 7) : 6;
                }
            } else if (exchangeAccountUseReq.getChangeUsedBalance().compareTo(BigDecimal.ZERO) == 0 && exchangeAccountUseReq.getChangeAvaBalance().compareTo(BigDecimal.ZERO) > 0) {
                step = freezeAdd ? 11 : 1;
                finalAddBalance = exchangeAccountUseReq.getChangeAvaBalance();
            } else if (exchangeAccountUseReq.getChangeUsedBalance().compareTo(BigDecimal.ZERO) > 0 && exchangeAccountUseReq.getChangeAvaBalance().compareTo(BigDecimal.ZERO) == 0) {
                step = 2;
                if (accountRespDto.getAvailableBalance().add(orderFreeze).compareTo(exchangeAccountUseReq.getChangeUsedBalance()) < 0) {
                    throw new BizException("\u6362\u8d2d\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3");
                }
                finalSubBalance = exchangeAccountUseReq.getChangeUsedBalance();
            } else if (exchangeAccountUseReq.getChangeUsedBalance().compareTo(BigDecimal.ZERO) > 0 && exchangeAccountUseReq.getChangeAvaBalance().compareTo(BigDecimal.ZERO) > 0) {
                int n = step = freezeAdd ? 8 : 4;
                if (accountRespDto.getAvailableBalance().add(orderFreeze).add(exchangeAccountUseReq.getChangeAvaBalance()).compareTo(exchangeAccountUseReq.getChangeUsedBalance()) < 0) {
                    throw new BizException("\u6362\u8d2d\u53ef\u7528\u989d\u5ea6\u4e0d\u8db3");
                }
                finalSubBalance = exchangeAccountUseReq.getChangeUsedBalance();
                finalAddBalance = exchangeAccountUseReq.getChangeAvaBalance();
            }
            logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 \u9700\u53d8\u66f4\u7684\u989d\u5ea6\u6570\u636e {} step={} finalSubChangeBalance={} finalAddChangeBalance={} finalAdvanceSubBalance={}", new Object[]{accountRespDto.getId(), step, finalSubBalance, finalAddBalance, finalAdvanceSubBalance});
            switch (step) {
                case 1: {
                    BigDecimal s1NewAvailableBalance = accountRespDto.getAvailableBalance().add(finalAddBalance);
                    this.updateAccountBalance(accountRespDto, s1NewAvailableBalance, null, null);
                    this.submitOrderSaveStatment(exchangeAccountUseReq, accountRespDto, s1NewAvailableBalance, BigDecimal.ZERO, BigDecimal.ZERO);
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.EXCHANGE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAvailableBalance(), finalAddBalance, s1NewAvailableBalance, accountRespDto.getUsedBalance(), BigDecimal.ZERO, accountRespDto.getUsedBalance());
                    return;
                }
                case 2: {
                    BigDecimal s2NewAvailableBalance = accountRespDto.getAvailableBalance().subtract(finalSubBalance);
                    BigDecimal s2NewUseBalance = accountRespDto.getUsedBalance().add(finalSubBalance);
                    this.updateAccountBalance(accountRespDto, s2NewAvailableBalance, s2NewUseBalance, null);
                    this.submitOrderSaveStatment(exchangeAccountUseReq, accountRespDto, s2NewAvailableBalance, BigDecimal.ZERO, finalSubBalance);
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.EXCHANGE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAvailableBalance(), finalSubBalance.negate(), s2NewAvailableBalance, accountRespDto.getUsedBalance(), finalSubBalance, s2NewUseBalance);
                    return;
                }
                case 3: {
                    BigDecimal s3NewAdvanceSurplusBalance = accountRespDto.getAdvanceSurplusBalance().subtract(finalAdvanceSubBalance);
                    this.updateAccountBalance(accountRespDto, null, null, s3NewAdvanceSurplusBalance);
                    this.submitOrderSaveStatment(exchangeAccountUseReq, accountRespDto, accountRespDto.getAvailableBalance(), finalAdvanceSubBalance, BigDecimal.ZERO);
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.ADVANCE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAdvanceSurplusBalance(), finalAdvanceSubBalance.negate(), s3NewAdvanceSurplusBalance, accountRespDto.getAdvanceTotalBalance().subtract(accountRespDto.getAdvanceSurplusBalance()), finalAdvanceSubBalance, accountRespDto.getAdvanceTotalBalance().subtract(accountRespDto.getAdvanceSurplusBalance()).add(finalAdvanceSubBalance));
                    return;
                }
                case 4: {
                    BigDecimal s4NewAvailableBalance = accountRespDto.getAvailableBalance().add(finalAddBalance).subtract(finalSubBalance);
                    BigDecimal s4NewUseBalance = accountRespDto.getUsedBalance().add(finalSubBalance);
                    this.updateAccountBalance(accountRespDto, s4NewAvailableBalance, s4NewUseBalance, null);
                    this.submitOrderSaveStatment(exchangeAccountUseReq, accountRespDto, s4NewAvailableBalance, BigDecimal.ZERO, finalSubBalance);
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.EXCHANGE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAvailableBalance(), finalAddBalance.add(finalSubBalance.negate()), s4NewAvailableBalance, accountRespDto.getUsedBalance(), finalSubBalance, s4NewUseBalance);
                    return;
                }
                case 5: {
                    BigDecimal s5NewAvailableBalance = accountRespDto.getAvailableBalance().add(finalAddBalance);
                    BigDecimal s5NewAdvanceSurplusBalance = accountRespDto.getAdvanceSurplusBalance().subtract(finalAdvanceSubBalance);
                    this.updateAccountBalance(accountRespDto, s5NewAvailableBalance, null, s5NewAdvanceSurplusBalance);
                    this.submitOrderSaveStatment(exchangeAccountUseReq, accountRespDto, s5NewAvailableBalance, finalAdvanceSubBalance, BigDecimal.ZERO);
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.EXCHANGE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAvailableBalance(), finalAddBalance, s5NewAvailableBalance, accountRespDto.getUsedBalance(), BigDecimal.ZERO, accountRespDto.getUsedBalance());
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.ADVANCE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAdvanceSurplusBalance(), finalAdvanceSubBalance.negate(), s5NewAdvanceSurplusBalance, accountRespDto.getAdvanceTotalBalance().subtract(accountRespDto.getAdvanceSurplusBalance()), finalAdvanceSubBalance, accountRespDto.getAdvanceTotalBalance().subtract(accountRespDto.getAdvanceSurplusBalance()).add(finalAdvanceSubBalance));
                    return;
                }
                case 6: {
                    BigDecimal s6NewAvailableBalance = accountRespDto.getAvailableBalance().subtract(finalSubBalance);
                    BigDecimal s6NewUseBalance = accountRespDto.getUsedBalance().add(finalSubBalance);
                    BigDecimal s6NewAdvanceSurplusBalance = accountRespDto.getAdvanceSurplusBalance().subtract(finalAdvanceSubBalance);
                    this.updateAccountBalance(accountRespDto, s6NewAvailableBalance, s6NewUseBalance, s6NewAdvanceSurplusBalance);
                    this.submitOrderSaveStatment(exchangeAccountUseReq, accountRespDto, s6NewAvailableBalance, finalAdvanceSubBalance, finalSubBalance);
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.EXCHANGE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAvailableBalance(), finalSubBalance.negate(), s6NewAvailableBalance, accountRespDto.getUsedBalance(), finalSubBalance, s6NewUseBalance);
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.ADVANCE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAdvanceSurplusBalance(), finalAdvanceSubBalance.negate(), s6NewAdvanceSurplusBalance, accountRespDto.getAdvanceTotalBalance().subtract(accountRespDto.getAdvanceSurplusBalance()), finalAdvanceSubBalance, accountRespDto.getAdvanceTotalBalance().subtract(accountRespDto.getAdvanceSurplusBalance()).add(finalAdvanceSubBalance));
                    return;
                }
                case 7: {
                    BigDecimal s7NewAvailableBalance = accountRespDto.getAvailableBalance().add(finalAddBalance).subtract(finalSubBalance);
                    BigDecimal s7NewUseBalance = accountRespDto.getUsedBalance().add(finalSubBalance);
                    BigDecimal s7NewAdvanceSurplusBalance = accountRespDto.getAdvanceSurplusBalance().subtract(finalAdvanceSubBalance);
                    this.updateAccountBalance(accountRespDto, s7NewAvailableBalance, s7NewUseBalance, s7NewAdvanceSurplusBalance);
                    this.submitOrderSaveStatment(exchangeAccountUseReq, accountRespDto, s7NewAvailableBalance, finalAdvanceSubBalance, finalSubBalance);
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.EXCHANGE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAvailableBalance(), finalAddBalance.add(finalSubBalance.negate()), s7NewAvailableBalance, accountRespDto.getUsedBalance(), finalSubBalance, s7NewUseBalance);
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.ADVANCE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAdvanceSurplusBalance(), finalAdvanceSubBalance.negate(), s7NewAdvanceSurplusBalance, accountRespDto.getAdvanceTotalBalance().subtract(accountRespDto.getAdvanceSurplusBalance()), finalAdvanceSubBalance, accountRespDto.getAdvanceTotalBalance().subtract(accountRespDto.getAdvanceSurplusBalance()).add(finalAdvanceSubBalance));
                    return;
                }
                case 8: {
                    exchangeAccountUseReq.setChangeAvaFreeze(exchangeAccountUseReq.getChangeAvaBalance());
                    exchangeAccountUseReq.setChangeAvaBalance(BigDecimal.ZERO);
                    BigDecimal s8NewAvailableBalance = accountRespDto.getAvailableBalance().subtract(finalSubBalance);
                    BigDecimal s8NewUseBalance = accountRespDto.getUsedBalance().add(finalSubBalance);
                    this.updateAccountBalance(accountRespDto, s8NewAvailableBalance, s8NewUseBalance, null);
                    exchangeAccountUseReq.setChangeAvaBalance(BigDecimal.ZERO);
                    this.submitOrderSaveStatment(exchangeAccountUseReq, accountRespDto, s8NewAvailableBalance, BigDecimal.ZERO, finalSubBalance);
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.EXCHANGE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAvailableBalance(), finalSubBalance.negate(), s8NewAvailableBalance, accountRespDto.getUsedBalance(), finalSubBalance, s8NewUseBalance);
                    BigDecimal s8NewFreezeBalance = accountRespDto.getFreeze().add(exchangeAccountUseReq.getChangeAvaFreeze());
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.FREEZE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getFreeze(), exchangeAccountUseReq.getChangeAvaFreeze(), s8NewFreezeBalance, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
                    return;
                }
                case 9: {
                    exchangeAccountUseReq.setChangeAvaFreeze(exchangeAccountUseReq.getChangeAvaBalance());
                    exchangeAccountUseReq.setChangeAvaBalance(BigDecimal.ZERO);
                    BigDecimal s9NewAvailableBalance = accountRespDto.getAvailableBalance().subtract(finalSubBalance);
                    BigDecimal s9NewUseBalance = accountRespDto.getUsedBalance().add(finalSubBalance);
                    BigDecimal s9NewAdvanceSurplusBalance = accountRespDto.getAdvanceSurplusBalance().subtract(finalAdvanceSubBalance);
                    this.updateAccountBalance(accountRespDto, s9NewAvailableBalance, s9NewUseBalance, s9NewAdvanceSurplusBalance);
                    this.submitOrderSaveStatment(exchangeAccountUseReq, accountRespDto, s9NewAvailableBalance, finalAdvanceSubBalance, finalSubBalance);
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.EXCHANGE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAvailableBalance(), finalSubBalance.negate(), s9NewAvailableBalance, accountRespDto.getUsedBalance(), finalSubBalance, s9NewUseBalance);
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.ADVANCE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAdvanceSurplusBalance(), finalAdvanceSubBalance.negate(), s9NewAdvanceSurplusBalance, accountRespDto.getAdvanceTotalBalance().subtract(accountRespDto.getAdvanceSurplusBalance()), finalAdvanceSubBalance, accountRespDto.getAdvanceTotalBalance().subtract(accountRespDto.getAdvanceSurplusBalance()).add(finalAdvanceSubBalance));
                    BigDecimal s9NewFreezeBalance = accountRespDto.getFreeze().add(exchangeAccountUseReq.getChangeAvaFreeze());
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.FREEZE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getFreeze(), exchangeAccountUseReq.getChangeAvaFreeze(), s9NewFreezeBalance, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
                    return;
                }
                case 10: {
                    exchangeAccountUseReq.setChangeAvaFreeze(exchangeAccountUseReq.getChangeAvaBalance());
                    exchangeAccountUseReq.setChangeAvaBalance(BigDecimal.ZERO);
                    BigDecimal s10NewAvailableBalance = accountRespDto.getAvailableBalance().subtract(finalSubBalance);
                    BigDecimal s10NewUseBalance = accountRespDto.getUsedBalance().add(finalSubBalance);
                    BigDecimal s10NewAdvanceSurplusBalance = accountRespDto.getAdvanceSurplusBalance().subtract(finalAdvanceSubBalance);
                    this.updateAccountBalance(accountRespDto, s10NewAvailableBalance, s10NewUseBalance, s10NewAdvanceSurplusBalance);
                    this.submitOrderSaveStatment(exchangeAccountUseReq, accountRespDto, s10NewAvailableBalance, finalAdvanceSubBalance, finalSubBalance);
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.EXCHANGE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAvailableBalance(), finalSubBalance.negate(), s10NewAvailableBalance, accountRespDto.getUsedBalance(), finalSubBalance, s10NewUseBalance);
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.ADVANCE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAdvanceSurplusBalance(), finalAdvanceSubBalance.negate(), s10NewAdvanceSurplusBalance, accountRespDto.getAdvanceTotalBalance().subtract(accountRespDto.getAdvanceSurplusBalance()), finalAdvanceSubBalance, accountRespDto.getAdvanceTotalBalance().subtract(accountRespDto.getAdvanceSurplusBalance()).add(finalAdvanceSubBalance));
                    BigDecimal s10NewFreezeBalance = accountRespDto.getFreeze().add(exchangeAccountUseReq.getChangeAvaFreeze());
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.FREEZE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getFreeze(), exchangeAccountUseReq.getChangeAvaFreeze(), s10NewFreezeBalance, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
                    return;
                }
                case 11: {
                    exchangeAccountUseReq.setChangeAvaFreeze(exchangeAccountUseReq.getChangeAvaBalance());
                    exchangeAccountUseReq.setChangeAvaBalance(BigDecimal.ZERO);
                    this.submitOrderSaveStatment(exchangeAccountUseReq, accountRespDto, accountRespDto.getAdvanceUsedBalance(), BigDecimal.ZERO, BigDecimal.ZERO);
                    BigDecimal s11NewFreezeBalance = accountRespDto.getFreeze().add(exchangeAccountUseReq.getChangeAvaFreeze());
                    this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.FREEZE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getFreeze(), exchangeAccountUseReq.getChangeAvaFreeze(), s11NewFreezeBalance, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
                    return;
                }
                default: {
                    logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 step=0 \u4e0d\u5904\u7406");
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.error("\u4f7f\u7528\u6362\u8d2d\u989d\u5ea6\u8d26\u6237\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            throw new BizException("\u4f7f\u7528\u6362\u8d2d\u989d\u5ea6\u8d26\u6237\u5931\u8d25\uff0c\u539f\u56e0:" + e.getMessage());
        }
        finally {
            this.registerSynchronizationAfterCommit(i -> this.lockService.unlock(lock), 1);
        }
    }

    private void updateAccountBalance(ExchangeBalanceAccountRespDto accountRespDto, BigDecimal newAvailableBalance, BigDecimal newUsedBalance, BigDecimal newAdvanceSurplusBalance) {
        ExchangeBalanceAccountEo useAccountUpdateEo = new ExchangeBalanceAccountEo();
        useAccountUpdateEo.setId(accountRespDto.getId());
        useAccountUpdateEo.setAvailableBalance(newAvailableBalance);
        useAccountUpdateEo.setUsedBalance(newUsedBalance);
        useAccountUpdateEo.setAdvanceSurplusBalance(newAdvanceSurplusBalance);
        logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 {} \u66f4\u65b0\u8d26\u6237\u989d\u5ea6 newAvailableBalance={} newUsedBalance={} newAdvanceSurplusBalance={} ", new Object[]{accountRespDto.getId(), newAvailableBalance, newUsedBalance, newAdvanceSurplusBalance});
        this.exchangeBalanceAccountDas.updateSelective((BaseEo)useAccountUpdateEo);
    }

    public void useExchangeBalanceAccountXb(ExchangeAccountUseReq exchangeAccountUseReq) {
        this.verifyParam(exchangeAccountUseReq);
        String lockKey = exchangeAccountUseReq.getActivityId() + "_" + exchangeAccountUseReq.getCustomerId();
        Mutex lock = this.lockService.lock("mk_exchange_balance_account", lockKey, 1500, 1500, TimeUnit.MILLISECONDS);
        try {
            ExchangeBalanceAccountRespDto accountRespDto = this.queryByActivityIdAndCustomerId(exchangeAccountUseReq.getActivityId(), exchangeAccountUseReq.getCustomerId());
            logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 \u83b7\u53d6\u5230\u6362\u8d2d\u8d26\u6237 {}", (Object)JSON.toJSONString((Object)accountRespDto));
            if (accountRespDto == null || accountRespDto.getId() == null) {
                throw new BizException("\u7d2f\u8ba1\u989d\u5ea6\u8d26\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BigDecimal reallyAvaBalance = exchangeAccountUseReq.getChangeAvaBalance().subtract(exchangeAccountUseReq.getChangeUsedBalance());
            logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 {} reallyAvaBalance {}", (Object)accountRespDto.getId(), (Object)reallyAvaBalance);
            BigDecimal newBalance = accountRespDto.getTotalAvailableBalance().add(reallyAvaBalance);
            logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 {} newBalance {}", (Object)accountRespDto.getId(), (Object)newBalance);
            if (BigDecimal.ZERO.compareTo(newBalance) > 0) {
                throw new BizException("\u6362\u8d2d\u7d2f\u8ba1\u989d\u5ea6\u4e0d\u8db3");
            }
            BigDecimal changeUsedBalance = exchangeAccountUseReq.getChangeUsedBalance();
            logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 {} changeUsedBalance {}", (Object)accountRespDto.getId(), (Object)changeUsedBalance);
            BigDecimal newAdvanceSurplusBalance = BigDecimal.ZERO;
            BigDecimal advChangeBalance = BigDecimal.ZERO;
            if (accountRespDto.getAdvanceSurplusBalance().compareTo(BigDecimal.ZERO) > 0) {
                newAdvanceSurplusBalance = accountRespDto.getAdvanceSurplusBalance();
                if (newAdvanceSurplusBalance.compareTo(changeUsedBalance) >= 0) {
                    advChangeBalance = changeUsedBalance;
                    newAdvanceSurplusBalance = newAdvanceSurplusBalance.subtract(changeUsedBalance);
                    changeUsedBalance = BigDecimal.ZERO;
                    logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 {} \u60c5\u51b51 advChangeBalance={} newAdvanceSurplusBalance={} changeUsedBalance={} ", new Object[]{accountRespDto.getId(), advChangeBalance, newAdvanceSurplusBalance, changeUsedBalance});
                } else {
                    advChangeBalance = newAdvanceSurplusBalance;
                    newAdvanceSurplusBalance = BigDecimal.ZERO;
                    changeUsedBalance = changeUsedBalance.subtract(newAdvanceSurplusBalance);
                    logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 {} \u60c5\u51b52 advChangeBalance={} newAdvanceSurplusBalance={} changeUsedBalance={} ", new Object[]{accountRespDto.getId(), advChangeBalance, newAdvanceSurplusBalance, changeUsedBalance});
                }
                BigDecimal oldUsedBalance = accountRespDto.getAdvanceTotalBalance().subtract(accountRespDto.getAdvanceSurplusBalance());
                BigDecimal newUsedBalance = oldUsedBalance.add(advChangeBalance);
                logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 {} \u8bb0\u5f55\u65e5\u5fd7 oldUsedBalance={} newUsedBalance={} ", new Object[]{accountRespDto.getId(), oldUsedBalance, newUsedBalance});
                this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.ADVANCE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAdvanceSurplusBalance(), advChangeBalance, newAdvanceSurplusBalance, oldUsedBalance, advChangeBalance, newUsedBalance);
            }
            BigDecimal changeAvaBalance = exchangeAccountUseReq.getChangeAvaBalance();
            BigDecimal newChangeAvaBalance = changeAvaBalance.subtract(changeUsedBalance);
            BigDecimal newAvailableBalance = accountRespDto.getAvailableBalance().add(newChangeAvaBalance);
            BigDecimal newUsedBalance = accountRespDto.getUsedBalance().add(changeUsedBalance);
            ExchangeBalanceAccountEo useAccountUpdateEo = new ExchangeBalanceAccountEo();
            useAccountUpdateEo.setId(accountRespDto.getId());
            useAccountUpdateEo.setAvailableBalance(newAvailableBalance);
            useAccountUpdateEo.setUsedBalance(newUsedBalance);
            useAccountUpdateEo.setAdvanceSurplusBalance(newAdvanceSurplusBalance);
            logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 {} \u66f4\u65b0\u8d26\u6237\u989d\u5ea6 newAvailableBalance={} newUsedBalance={} newAdvanceSurplusBalance={} ", new Object[]{accountRespDto.getId(), newAvailableBalance, newUsedBalance, newAdvanceSurplusBalance});
            this.exchangeBalanceAccountDas.updateSelective((BaseEo)useAccountUpdateEo);
            if (changeUsedBalance.compareTo(BigDecimal.ZERO) > 0) {
                logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 {} \u8bb0\u5f55\u65e5\u5fd7 newAvailableBalance={} newUsedBalance={} newAdvanceSurplusBalance={} ", new Object[]{accountRespDto.getId(), newAvailableBalance, newUsedBalance, newAdvanceSurplusBalance});
                this.addExchangeBalanceAccountLog(ExchangeBalanceTypeEnum.EXCHANGE.getKey(), accountRespDto, exchangeAccountUseReq.getOrderNo(), accountRespDto.getAvailableBalance(), newChangeAvaBalance, newAvailableBalance, accountRespDto.getUsedBalance(), changeUsedBalance, newUsedBalance);
            }
            this.submitOrderSaveStatment(exchangeAccountUseReq, accountRespDto, newAvailableBalance, advChangeBalance, changeUsedBalance);
        }
        catch (Exception e) {
            logger.error("\u4f7f\u7528\u6362\u8d2d\u989d\u5ea6\u8d26\u6237\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)e));
            e.printStackTrace();
            throw new BizException("\u4f7f\u7528\u6362\u8d2d\u989d\u5ea6\u8d26\u6237\u5931\u8d25,\u539f\u56e0 " + e.getMessage());
        }
        finally {
            this.lockService.unlock(lock);
        }
    }

    private void addExchangeBalanceAccountLog(String balanceType, ExchangeBalanceAccountRespDto accountRespDto, String orderNo, BigDecimal oldBalance, BigDecimal changeBalance, BigDecimal newBalance, BigDecimal oldUsedBalance, BigDecimal changeUsedBalance, BigDecimal newUsedBalance) {
        logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 {} balanceType={} accountRespDto={} orderNo={} oldBalance={} changeBalance={} newBalance={} oldUsedBalance={} changeUsedBalance={} newUsedBalance={}", new Object[]{accountRespDto.getId(), balanceType, JSON.toJSONString((Object)accountRespDto), orderNo, oldBalance, changeBalance, newBalance, oldUsedBalance, changeUsedBalance, newUsedBalance});
        ExchangeBalanceTurnoverEo turnoverEo = new ExchangeBalanceTurnoverEo();
        turnoverEo.setBalanceAccountId(accountRespDto.getId());
        turnoverEo.setActivityId(accountRespDto.getActivityId());
        turnoverEo.setCustomerId(accountRespDto.getCustomerId());
        turnoverEo.setCustomerCode(accountRespDto.getCustomerCode());
        turnoverEo.setCustomerName(accountRespDto.getCustomerName());
        turnoverEo.setOrderNo(orderNo);
        turnoverEo.setStatus(Integer.valueOf(0));
        turnoverEo.setOrganizationId(accountRespDto.getOrganizationId());
        turnoverEo.setChangeType(TurnoverChangeTypeEnum.SUBMIT_ORDER.getType());
        turnoverEo.setOldBalance(oldBalance);
        turnoverEo.setChangeBalance(changeBalance);
        turnoverEo.setNewBalance(newBalance);
        turnoverEo.setOldUsedBalance(oldUsedBalance);
        turnoverEo.setChangeUsedBalance(changeUsedBalance);
        turnoverEo.setNewUsedBalance(newUsedBalance);
        turnoverEo.setBalanceType(balanceType);
        turnoverEo.setExtension(ServiceContext.getContext().getRequestId());
        this.exchangeBalanceTurnoverDas.insert((BaseEo)turnoverEo);
    }

    private void addExchangeBalanceAccountLogDB(String balanceType, ExchangeBalanceAccountRespDto accountRespDto, String orderNo, BigDecimal oldBalance, BigDecimal changeBalance, BigDecimal newBalance, BigDecimal oldUsedBalance, BigDecimal oldChangeUsedBalance, BigDecimal newUsedBalance) {
        ExchangeBalanceTurnoverEo turnoverEo = new ExchangeBalanceTurnoverEo();
        turnoverEo.setBalanceAccountId(accountRespDto.getId());
        turnoverEo.setActivityId(accountRespDto.getActivityId());
        turnoverEo.setCustomerId(accountRespDto.getCustomerId());
        turnoverEo.setCustomerCode(accountRespDto.getCustomerCode());
        turnoverEo.setCustomerName(accountRespDto.getCustomerName());
        turnoverEo.setOrderNo(orderNo);
        turnoverEo.setStatus(Integer.valueOf(0));
        turnoverEo.setOrganizationId(accountRespDto.getOrganizationId());
        turnoverEo.setChangeType(TurnoverChangeTypeEnum.SUBMIT_ORDER.getType());
        turnoverEo.setOldBalance(oldBalance);
        turnoverEo.setChangeBalance(changeBalance);
        turnoverEo.setNewBalance(newBalance);
        turnoverEo.setOldUsedBalance(oldUsedBalance);
        turnoverEo.setChangeUsedBalance(oldChangeUsedBalance);
        turnoverEo.setNewUsedBalance(newUsedBalance);
        turnoverEo.setBalanceType(balanceType);
        this.exchangeBalanceTurnoverDas.insert((BaseEo)turnoverEo);
    }

    private void submitOrderSaveStatment(ExchangeAccountUseReq exchangeAccountUseReq, ExchangeBalanceAccountRespDto accountRespDto, BigDecimal newBalance, BigDecimal advChangeBalance, BigDecimal changeUsedBalance) {
        ExchangeBalanceStatementEo giveStatementEo;
        ExchangeBalanceStatementEo deductionStatementEo;
        logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 \u8bb0\u5f55\u6d41\u6c34 {} newBalance={} advChangeBalance={} changeUsedBalance={}", new Object[]{accountRespDto.getId(), newBalance, advChangeBalance, changeUsedBalance});
        ArrayList statementEos = Lists.newArrayList();
        if (BigDecimal.ZERO.compareTo(advChangeBalance) < 0) {
            deductionStatementEo = new ExchangeBalanceStatementEo();
            deductionStatementEo.setBalanceAccountId(accountRespDto.getId());
            deductionStatementEo.setActivityId(exchangeAccountUseReq.getActivityId());
            deductionStatementEo.setCustomerId(exchangeAccountUseReq.getCustomerId());
            deductionStatementEo.setCustomerCode(accountRespDto.getCustomerCode());
            deductionStatementEo.setCustomerName(accountRespDto.getCustomerName());
            deductionStatementEo.setOrderNo(exchangeAccountUseReq.getOrderNo());
            deductionStatementEo.setOrganizationId(accountRespDto.getOrganizationId());
            deductionStatementEo.setChangeType(ExchangeStatementChangeTypeEnum.ORDER_DEDUCTION.getType());
            deductionStatementEo.setOldBalance(accountRespDto.getAdvanceSurplusBalance());
            deductionStatementEo.setChangeBalance(advChangeBalance.negate());
            deductionStatementEo.setNewBalance(accountRespDto.getAdvanceSurplusBalance().subtract(advChangeBalance));
            deductionStatementEo.setBalanceType(ExchangeBalanceTypeEnum.ADVANCE.getKey());
            statementEos.add(deductionStatementEo);
        }
        if (ObjectUtil.isNotNull((Object)exchangeAccountUseReq.getChangeAvaFreeze()) && BigDecimal.ZERO.compareTo(exchangeAccountUseReq.getChangeAvaFreeze()) < 0) {
            giveStatementEo = new ExchangeBalanceStatementEo();
            giveStatementEo.setBalanceAccountId(accountRespDto.getId());
            giveStatementEo.setActivityId(exchangeAccountUseReq.getActivityId());
            giveStatementEo.setCustomerId(exchangeAccountUseReq.getCustomerId());
            giveStatementEo.setCustomerCode(accountRespDto.getCustomerCode());
            giveStatementEo.setCustomerName(accountRespDto.getCustomerName());
            giveStatementEo.setOrderNo(exchangeAccountUseReq.getOrderNo());
            giveStatementEo.setOrganizationId(accountRespDto.getOrganizationId());
            giveStatementEo.setChangeType(ExchangeStatementChangeTypeEnum.GIVE_FREEZE.getType());
            giveStatementEo.setOldBalance(accountRespDto.getFreeze());
            giveStatementEo.setChangeBalance(exchangeAccountUseReq.getChangeAvaFreeze());
            giveStatementEo.setNewBalance(accountRespDto.getFreeze().add(exchangeAccountUseReq.getChangeAvaFreeze()));
            giveStatementEo.setBalanceType(ExchangeBalanceTypeEnum.FREEZE.getKey());
            statementEos.add(giveStatementEo);
        }
        if (BigDecimal.ZERO.compareTo(exchangeAccountUseReq.getChangeAvaBalance()) < 0) {
            giveStatementEo = new ExchangeBalanceStatementEo();
            giveStatementEo.setBalanceAccountId(accountRespDto.getId());
            giveStatementEo.setActivityId(exchangeAccountUseReq.getActivityId());
            giveStatementEo.setCustomerId(exchangeAccountUseReq.getCustomerId());
            giveStatementEo.setCustomerCode(accountRespDto.getCustomerCode());
            giveStatementEo.setCustomerName(accountRespDto.getCustomerName());
            giveStatementEo.setOrderNo(exchangeAccountUseReq.getOrderNo());
            giveStatementEo.setOrganizationId(accountRespDto.getOrganizationId());
            giveStatementEo.setChangeType(ExchangeStatementChangeTypeEnum.ORDER_GIVE.getType());
            giveStatementEo.setOldBalance(accountRespDto.getAvailableBalance());
            giveStatementEo.setChangeBalance(exchangeAccountUseReq.getChangeAvaBalance());
            giveStatementEo.setNewBalance(accountRespDto.getAvailableBalance().add(exchangeAccountUseReq.getChangeAvaBalance()));
            giveStatementEo.setBalanceType(ExchangeBalanceTypeEnum.EXCHANGE.getKey());
            statementEos.add(giveStatementEo);
        }
        if (BigDecimal.ZERO.compareTo(changeUsedBalance) < 0) {
            deductionStatementEo = new ExchangeBalanceStatementEo();
            deductionStatementEo.setBalanceAccountId(accountRespDto.getId());
            deductionStatementEo.setActivityId(exchangeAccountUseReq.getActivityId());
            deductionStatementEo.setCustomerId(exchangeAccountUseReq.getCustomerId());
            deductionStatementEo.setCustomerCode(accountRespDto.getCustomerCode());
            deductionStatementEo.setCustomerName(accountRespDto.getCustomerName());
            deductionStatementEo.setOrderNo(exchangeAccountUseReq.getOrderNo());
            deductionStatementEo.setOrganizationId(accountRespDto.getOrganizationId());
            deductionStatementEo.setChangeType(ExchangeStatementChangeTypeEnum.ORDER_DEDUCTION.getType());
            deductionStatementEo.setOldBalance(accountRespDto.getAvailableBalance().add(exchangeAccountUseReq.getChangeAvaBalance()));
            deductionStatementEo.setChangeBalance(changeUsedBalance.negate());
            deductionStatementEo.setNewBalance(newBalance);
            deductionStatementEo.setBalanceType(ExchangeBalanceTypeEnum.EXCHANGE.getKey());
            statementEos.add(deductionStatementEo);
        }
        if (CollectionUtils.isNotEmpty((Collection)statementEos)) {
            this.exchangeBalanceStatementDas.insertBatch((List)statementEos);
        }
    }

    private void verifyParam(ExchangeAccountUseReq exchangeAccountUseReq) {
        if (exchangeAccountUseReq.getActivityId() == null || exchangeAccountUseReq.getCustomerId() == null) {
            throw new BizException("\u6362\u8d2d\u6d3b\u52a8ID\u6216\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ActivityRespDto activityRespDto = this.activityService.queryById(exchangeAccountUseReq.getActivityId());
        if (!Objects.equals(ActivityType.EXCHANGE_ACTIVITY.getId(), activityRespDto.getActivityTemplateId())) {
            throw new BizException("\u6362\u8d2d\u6d3b\u52a8\u624d\u80fd\u4f7f\u7528\u7d2f\u8ba1\u989d\u5ea6\uff0c\u6d3b\u52a8ID\u3010" + exchangeAccountUseReq.getActivityId() + "\u3011");
        }
        if (exchangeAccountUseReq.getChangeAvaBalance() == null) {
            logger.info("\u4f7f\u7528\u989d\u5ea6 \u7d2f\u8ba1\u989d\u5ea6\u4e3anull");
            exchangeAccountUseReq.setChangeAvaBalance(BigDecimal.ZERO);
        }
        if (exchangeAccountUseReq.getChangeUsedBalance() == null) {
            logger.info("\u4f7f\u7528\u989d\u5ea6 \u4f7f\u7528\u91d1\u989d\u4e3anull");
            exchangeAccountUseReq.setChangeUsedBalance(BigDecimal.ZERO);
        }
        if (exchangeAccountUseReq.getChangeUsedBalance().compareTo(BigDecimal.ZERO) < 0) {
            throw new BizException("\u4f7f\u7528\u989d\u5ea6\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e0");
        }
        if (exchangeAccountUseReq.getChangeAvaBalance().compareTo(BigDecimal.ZERO) < 0) {
            throw new BizException("\u8d60\u9001\u989d\u5ea6\u5fc5\u987b\u5927\u4e8e\u6216\u7b49\u4e8e0");
        }
        if (exchangeAccountUseReq.getBigBRequestFlag() != null && exchangeAccountUseReq.getBigBRequestFlag().booleanValue()) {
            List rollBackTurnoverEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.exchangeBalanceTurnoverDas.filter().eq((Object)"activity_id", (Object)exchangeAccountUseReq.getActivityId())).eq((Object)"order_no", (Object)exchangeAccountUseReq.getOrderNo())).eq((Object)"status", (Object)0)).last(" for update")).list();
            logger.info("\u6362\u8d2d\u8d26\u6237\u4f7f\u7528 {} \u83b7\u53d6\u5230\u53d8\u66f4\u65e5\u5fd7\u8bb0\u5f55 {}", (Object)exchangeAccountUseReq.getOrderNo(), (Object)JSON.toJSONString((Object)rollBackTurnoverEoList));
            if (CollectionUtils.isNotEmpty((Collection)rollBackTurnoverEoList)) {
                throw new BizException("\u8be5\u8ba2\u5355\u5b58\u5728\u672a\u56de\u6eda\u7684\u989d\u5ea6\u53d8\u66f4\u8bb0\u5f55");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rollbackExchangeAccount(ExchangeBalanceRollBackReqDto rollBackReqDto) {
        logger.info("\u56de\u6eda\u989d\u5ea6 \u8bf7\u6c42\u5165\u53c2 {}", (Object)JSON.toJSONString((Object)rollBackReqDto));
        if (rollBackReqDto.getBigBRequestFlag() != null && rollBackReqDto.getBigBRequestFlag().booleanValue()) {
            Mutex lock = this.lockService.lock("mk_exchange_balance_account", rollBackReqDto.getOrderNo(), 10, 10, TimeUnit.SECONDS);
            try {
                ExchangeBalanceTurnoverEo turnoverEos = new ExchangeBalanceTurnoverEo();
                turnoverEos.setOrderNo(rollBackReqDto.getOrderNo());
                turnoverEos.setStatus(Integer.valueOf(0));
                List rollBackTurnoverEoList = this.exchangeBalanceTurnoverDas.select((BaseEo)turnoverEos);
                logger.info("\u56de\u6eda\u989d\u5ea6 {} \u83b7\u53d6\u5230\u65e5\u5fd7\u8bb0\u5f55 {}", (Object)rollBackReqDto.getOrderNo(), (Object)JSON.toJSONString((Object)rollBackTurnoverEoList));
                if (CollectionUtils.isEmpty((Collection)rollBackTurnoverEoList)) {
                    logger.info("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u53ef\u56de\u6eda\u6362\u8d2d\u989d\u5ea6\u8bb0\u5f55,\u8ba2\u5355\u7f16\u53f7\uff1a{}", (Object)rollBackReqDto.getOrderNo());
                    return;
                }
                Set accountIds = rollBackTurnoverEoList.stream().map(ExchangeBalanceTurnoverEo::getBalanceAccountId).collect(Collectors.toSet());
                ExchangeBalanceAccountEo queryEo = new ExchangeBalanceAccountEo();
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.in((String)"id", accountIds));
                queryEo.setSqlFilters(sqlFilters);
                List accountEoList = this.exchangeBalanceAccountDas.select((BaseEo)queryEo);
                Map<Long, ExchangeBalanceAccountEo> accountEoMap = accountEoList.stream().peek(r -> r.setFreeze(this.getFreeze(r.getId()))).collect(Collectors.toMap(e -> e.getId(), e -> e, (e1, e2) -> e1));
                Map<Long, ExchangeBalanceAccountEo> accountRecordMap = accountEoList.stream().collect(Collectors.toMap(BaseEo::getId, e -> {
                    ExchangeBalanceAccountEo balanceAccountEo = new ExchangeBalanceAccountEo();
                    CubeBeanUtils.copyProperties((Object)balanceAccountEo, (Object)e, (String[])new String[0]);
                    return balanceAccountEo;
                }, (e1, e2) -> e1));
                for (ExchangeBalanceTurnoverEo turnoverEo : rollBackTurnoverEoList) {
                    ExchangeBalanceAccountEo eo = accountEoMap.get(turnoverEo.getBalanceAccountId());
                    if (eo == null) {
                        logger.info("\u6362\u8d2d\u989d\u5ea6\u8d26\u6237\u4e3a\u7a7a\uff1a{}", (Object)turnoverEo.getBalanceAccountId());
                        return;
                    }
                    logger.info("\u56de\u6eda\u989d\u5ea6 {} \u83b7\u53d6\u6362\u8d2d\u989d\u5ea6\u8d26\u6237 {}", (Object)rollBackReqDto.getOrderNo(), (Object)JSON.toJSONString((Object)eo));
                    String accountLockKey = turnoverEo.getActivityId() + "_" + turnoverEo.getCustomerId();
                    Mutex accountLock = this.lockService.lock("mk_exchange_balance_account", accountLockKey, 10, 10, TimeUnit.SECONDS);
                    try {
                        BigDecimal oldBalance = eo.getAvailableBalance();
                        BigDecimal oldUsedBalance = eo.getUsedBalance();
                        ExchangeBalanceAccountEo rollBackAccountEo = new ExchangeBalanceAccountEo();
                        rollBackAccountEo.setId(eo.getId());
                        if (Objects.equals(turnoverEo.getBalanceType(), ExchangeBalanceTypeEnum.ADVANCE.getKey())) {
                            oldBalance = eo.getAdvanceSurplusBalance();
                            oldUsedBalance = eo.getAdvanceTotalBalance().subtract(eo.getAdvanceSurplusBalance());
                            rollBackAccountEo.setAdvanceSurplusBalance(eo.getAdvanceSurplusBalance().subtract(turnoverEo.getChangeBalance()));
                        } else if (Objects.equals(turnoverEo.getBalanceType(), ExchangeBalanceTypeEnum.FREEZE.getKey())) {
                            oldBalance = eo.getFreeze();
                            oldUsedBalance = BigDecimal.ZERO;
                            rollBackAccountEo.setFreeze(eo.getFreeze().subtract(turnoverEo.getChangeBalance()));
                        } else {
                            rollBackAccountEo.setAvailableBalance(oldBalance.subtract(turnoverEo.getChangeBalance()));
                            rollBackAccountEo.setUsedBalance(oldUsedBalance.subtract(turnoverEo.getChangeUsedBalance()));
                        }
                        if (!Objects.equals(ExchangeBalanceTypeEnum.FREEZE.getKey(), turnoverEo.getBalanceType())) {
                            this.exchangeBalanceAccountDas.updateSelective((BaseEo)rollBackAccountEo);
                        }
                        ExchangeBalanceTurnoverEo updateTurnoverEo = new ExchangeBalanceTurnoverEo();
                        updateTurnoverEo.setId(turnoverEo.getId());
                        updateTurnoverEo.setStatus(Integer.valueOf(1));
                        this.exchangeBalanceTurnoverDas.updateSelective((BaseEo)updateTurnoverEo);
                        ExchangeBalanceTurnoverEo addTurnoverEo = new ExchangeBalanceTurnoverEo();
                        addTurnoverEo.setBalanceAccountId(eo.getId());
                        addTurnoverEo.setActivityId(eo.getActivityId());
                        addTurnoverEo.setCustomerId(eo.getCustomerId());
                        addTurnoverEo.setCustomerCode(eo.getCustomerCode());
                        addTurnoverEo.setCustomerName(eo.getCustomerName());
                        addTurnoverEo.setOrderNo(rollBackReqDto.getOrderNo());
                        addTurnoverEo.setStatus(Integer.valueOf(1));
                        addTurnoverEo.setOrganizationId(eo.getOrganizationId());
                        addTurnoverEo.setChangeType(rollBackReqDto.getTurnoverChangeTypeEnum().getType());
                        addTurnoverEo.setOldBalance(oldBalance);
                        addTurnoverEo.setChangeBalance(turnoverEo.getChangeBalance().negate());
                        if (Objects.equals(turnoverEo.getBalanceType(), ExchangeBalanceTypeEnum.ADVANCE.getKey())) {
                            addTurnoverEo.setNewBalance(rollBackAccountEo.getAdvanceSurplusBalance());
                            addTurnoverEo.setOldUsedBalance(oldUsedBalance);
                            addTurnoverEo.setChangeUsedBalance(turnoverEo.getChangeUsedBalance().negate());
                            addTurnoverEo.setNewUsedBalance(oldUsedBalance.subtract(turnoverEo.getChangeUsedBalance()));
                        } else if (Objects.equals(turnoverEo.getBalanceType(), ExchangeBalanceTypeEnum.EXCHANGE.getKey())) {
                            addTurnoverEo.setNewBalance(rollBackAccountEo.getAvailableBalance());
                            addTurnoverEo.setOldUsedBalance(oldUsedBalance);
                            addTurnoverEo.setChangeUsedBalance(turnoverEo.getChangeUsedBalance().negate());
                            addTurnoverEo.setNewUsedBalance(rollBackAccountEo.getUsedBalance());
                        } else if (Objects.equals(turnoverEo.getBalanceType(), ExchangeBalanceTypeEnum.FREEZE.getKey())) {
                            addTurnoverEo.setOldUsedBalance(BigDecimal.ZERO);
                            addTurnoverEo.setChangeUsedBalance(BigDecimal.ZERO);
                            addTurnoverEo.setNewUsedBalance(BigDecimal.ZERO);
                        }
                        addTurnoverEo.setBalanceType(turnoverEo.getBalanceType());
                        this.exchangeBalanceTurnoverDas.insert((BaseEo)addTurnoverEo);
                        eo.setAdvanceSurplusBalance(Optional.ofNullable(rollBackAccountEo.getAdvanceSurplusBalance()).orElse(eo.getAdvanceSurplusBalance()));
                        eo.setAvailableBalance(Optional.ofNullable(rollBackAccountEo.getAvailableBalance()).orElse(eo.getAvailableBalance()));
                        eo.setFreeze(Optional.ofNullable(rollBackAccountEo.getFreeze()).orElse(eo.getFreeze()));
                        eo.setUsedBalance(Optional.ofNullable(rollBackAccountEo.getUsedBalance()).orElse(eo.getUsedBalance()));
                    }
                    catch (Exception e3) {
                        logger.error("\u56de\u6eda\u8d26\u6237\u5931\u8d25 " + e3.getMessage(), (Throwable)e3);
                        throw new BizException("\u56de\u6eda\u8d26\u6237\u5931\u8d25,\u539f\u56e0: " + e3.getMessage());
                    }
                    finally {
                        this.lockService.unlock(accountLock);
                    }
                }
                accountRecordMap.forEach((k, v) -> this.rollbacoSaveStatement(rollBackReqDto, (ExchangeBalanceAccountEo)v));
            }
            catch (Exception e4) {
                logger.error("\u56de\u6eda\u8d26\u6237\u5931\u8d25 " + e4.getMessage(), (Throwable)e4);
                throw new BizException("\u56de\u6eda\u5931\u8d25,\u539f\u56e0 " + e4.getMessage());
            }
            finally {
                this.lockService.unlock(lock);
            }
            if (TurnoverChangeTypeEnum.AUDIT_WITHDRAW.equals((Object)rollBackReqDto.getTurnoverChangeTypeEnum())) {
                List exchangeBalanceTurnoverEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.exchangeBalanceTurnoverDas.filter().eq((Object)"order_no", (Object)rollBackReqDto.getOrderNo())).eq((Object)"change_type", (Object)"SUBMIT_ORDER")).orderByDesc((Object)"create_time")).list();
                ExchangeBalanceTurnoverEo exchangeBalanceTurnoverEo = exchangeBalanceTurnoverEos.stream().filter(r -> ExchangeBalanceTypeEnum.FREEZE.getKey().equals(r.getBalanceType()) && r.getChangeBalance().compareTo(BigDecimal.ZERO) > 0).findFirst().orElse(null);
                if (ObjectUtil.isNull((Object)exchangeBalanceTurnoverEo)) {
                    logger.info("\u6ca1\u6709\u51bb\u7ed3\u6d41\u6c34\u53ef\u56de\u6eda");
                    return;
                }
                String batch = exchangeBalanceTurnoverEo.getExtension();
                List turnoverEos = exchangeBalanceTurnoverEos.stream().filter(r -> batch.equals(r.getExtension())).collect(Collectors.toList());
                BigDecimal exchange = turnoverEos.stream().filter(r -> ExchangeBalanceTypeEnum.EXCHANGE.getKey().equals(r.getBalanceType())).map(ExchangeBalanceTurnoverEo::getChangeBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal advance = turnoverEos.stream().filter(r -> ExchangeBalanceTypeEnum.ADVANCE.getKey().equals(r.getBalanceType())).map(ExchangeBalanceTurnoverEo::getChangeBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
                ExchangeAccountUseReq exchangeAccountUseReq = this.getExchangeAccountUseReq(exchange, advance, exchangeBalanceTurnoverEo);
                logger.info("\u6a21\u62df\u8ba2\u5355\u91cd\u65b0\u63d0\u4ea4\u989d\u5ea6:{}", (Object)JSONObject.toJSONString((Object)exchangeAccountUseReq));
                this.useExchangeBalanceAccount(exchangeAccountUseReq);
            }
        } else {
            this.rollbackExchangeAccountXB(rollBackReqDto);
        }
    }

    public <REQ> REQ executorNewTransaction(TransactionCallback<REQ> action) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.platformTransactionManager);
        transactionTemplate.setIsolationLevel(2);
        transactionTemplate.setPropagationBehavior(3);
        return (REQ)transactionTemplate.execute(action);
    }

    public void registerSynchronizationAfterCommit(final Consumer consumer, final Integer sort) {
        if (TransactionSynchronizationManager.isActualTransactionActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    consumer.accept(1);
                }

                public int getOrder() {
                    return sort != Integer.MIN_VALUE ? sort - 1 : sort;
                }
            });
        } else {
            consumer.accept(1);
        }
    }

    @NotNull
    private ExchangeAccountUseReq getExchangeAccountUseReq(BigDecimal exchange, BigDecimal advance, ExchangeBalanceTurnoverEo exchangeBalanceTurnoverEo) {
        ExchangeAccountUseReq exchangeAccountUseReq = new ExchangeAccountUseReq();
        exchangeAccountUseReq.setChangeUsedBalance(exchange.negate().add(advance.negate()));
        exchangeAccountUseReq.setChangeAvaBalance(exchangeBalanceTurnoverEo.getChangeBalance());
        exchangeAccountUseReq.setBigBRequestFlag(Boolean.valueOf(true));
        exchangeAccountUseReq.setActivityId(exchangeBalanceTurnoverEo.getActivityId());
        exchangeAccountUseReq.setCustomerId(exchangeBalanceTurnoverEo.getCustomerId());
        exchangeAccountUseReq.setTurnoverChangeTypeEnum(TurnoverChangeTypeEnum.SUBMIT_ORDER);
        exchangeAccountUseReq.setOrderNo(exchangeBalanceTurnoverEo.getOrderNo());
        return exchangeAccountUseReq;
    }

    public void rollbackExchangeAccountXB(ExchangeBalanceRollBackReqDto rollBackReqDto) {
        Mutex lock = this.lockService.lock("mk_exchange_balance_account", rollBackReqDto.getOrderNo(), 1500, 1500, TimeUnit.MILLISECONDS);
        try {
            ExchangeBalanceTurnoverEo turnoverEos = new ExchangeBalanceTurnoverEo();
            turnoverEos.setOrderNo(rollBackReqDto.getOrderNo());
            turnoverEos.setStatus(Integer.valueOf(0));
            List rollBackTurnoverEoList = this.exchangeBalanceTurnoverDas.select((BaseEo)turnoverEos);
            logger.info("\u56de\u6eda\u989d\u5ea6XB {} \u83b7\u53d6\u5230\u65e5\u5fd7\u8bb0\u5f55 {}", (Object)rollBackReqDto.getOrderNo(), (Object)JSON.toJSONString((Object)rollBackTurnoverEoList));
            if (CollectionUtils.isEmpty((Collection)rollBackTurnoverEoList)) {
                logger.info("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u53ef\u56de\u6eda\u6362\u8d2d\u989d\u5ea6\u8bb0\u5f55,\u8ba2\u5355\u7f16\u53f7\uff1a{}", (Object)rollBackReqDto.getOrderNo());
                return;
            }
            Set accountIds = rollBackTurnoverEoList.stream().map(ExchangeBalanceTurnoverEo::getBalanceAccountId).collect(Collectors.toSet());
            ExchangeBalanceAccountEo queryEo = new ExchangeBalanceAccountEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"id", accountIds));
            queryEo.setSqlFilters(sqlFilters);
            List accountEoList = this.exchangeBalanceAccountDas.select((BaseEo)queryEo);
            Map<Long, ExchangeBalanceAccountEo> accountEoMap = accountEoList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e, (e1, e2) -> e1));
            for (ExchangeBalanceTurnoverEo turnoverEo : rollBackTurnoverEoList) {
                ExchangeBalanceAccountEo eo = accountEoMap.get(turnoverEo.getBalanceAccountId());
                if (eo == null) {
                    logger.info("\u6362\u8d2d\u989d\u5ea6\u8d26\u6237\u4e3a\u7a7a\uff1a{}", (Object)turnoverEo.getBalanceAccountId());
                    return;
                }
                String accountLockKey = turnoverEo.getActivityId() + "_" + turnoverEo.getCustomerId();
                Mutex accountLock = this.lockService.lock("mk_exchange_balance_account", accountLockKey, 1500, 1500, TimeUnit.MILLISECONDS);
                try {
                    BigDecimal oldBalance = eo.getAvailableBalance();
                    BigDecimal oldUsedBalance = eo.getUsedBalance();
                    ExchangeBalanceAccountEo rollBackAccountEo = new ExchangeBalanceAccountEo();
                    rollBackAccountEo.setId(eo.getId());
                    if (Objects.equals(turnoverEo.getBalanceType(), ExchangeBalanceTypeEnum.ADVANCE.getKey())) {
                        oldBalance = eo.getAdvanceSurplusBalance();
                        oldUsedBalance = eo.getAdvanceTotalBalance().subtract(eo.getAdvanceSurplusBalance());
                        rollBackAccountEo.setAdvanceSurplusBalance(eo.getAdvanceSurplusBalance().add(turnoverEo.getChangeBalance()));
                    } else {
                        rollBackAccountEo.setAvailableBalance(oldBalance.subtract(turnoverEo.getChangeBalance()));
                        rollBackAccountEo.setUsedBalance(oldUsedBalance.subtract(turnoverEo.getChangeUsedBalance()));
                    }
                    this.exchangeBalanceAccountDas.updateSelective((BaseEo)rollBackAccountEo);
                    ExchangeBalanceTurnoverEo updateTurnoverEo = new ExchangeBalanceTurnoverEo();
                    updateTurnoverEo.setId(turnoverEo.getId());
                    updateTurnoverEo.setStatus(Integer.valueOf(1));
                    this.exchangeBalanceTurnoverDas.updateSelective((BaseEo)updateTurnoverEo);
                    ExchangeBalanceTurnoverEo addTurnoverEo = new ExchangeBalanceTurnoverEo();
                    addTurnoverEo.setBalanceAccountId(eo.getId());
                    addTurnoverEo.setActivityId(eo.getActivityId());
                    addTurnoverEo.setCustomerId(eo.getCustomerId());
                    addTurnoverEo.setCustomerCode(eo.getCustomerCode());
                    addTurnoverEo.setCustomerName(eo.getCustomerName());
                    addTurnoverEo.setOrderNo(rollBackReqDto.getOrderNo());
                    addTurnoverEo.setStatus(Integer.valueOf(1));
                    addTurnoverEo.setOrganizationId(eo.getOrganizationId());
                    addTurnoverEo.setChangeType(rollBackReqDto.getTurnoverChangeTypeEnum().getType());
                    addTurnoverEo.setOldBalance(oldBalance);
                    addTurnoverEo.setChangeBalance(turnoverEo.getChangeBalance().negate());
                    if (Objects.equals(turnoverEo.getBalanceType(), ExchangeBalanceTypeEnum.ADVANCE.getKey())) {
                        addTurnoverEo.setNewBalance(rollBackAccountEo.getAdvanceSurplusBalance());
                        addTurnoverEo.setOldUsedBalance(oldUsedBalance);
                        addTurnoverEo.setChangeUsedBalance(turnoverEo.getChangeUsedBalance().negate());
                        addTurnoverEo.setNewUsedBalance(oldUsedBalance.subtract(turnoverEo.getChangeUsedBalance()));
                    } else {
                        addTurnoverEo.setNewBalance(rollBackAccountEo.getAvailableBalance());
                        addTurnoverEo.setOldUsedBalance(oldUsedBalance);
                        addTurnoverEo.setChangeUsedBalance(turnoverEo.getChangeUsedBalance().negate());
                        addTurnoverEo.setNewUsedBalance(rollBackAccountEo.getUsedBalance());
                    }
                    addTurnoverEo.setBalanceType(turnoverEo.getBalanceType());
                    this.exchangeBalanceTurnoverDas.insert((BaseEo)addTurnoverEo);
                    this.rollbacoSaveStatement(rollBackReqDto, eo);
                }
                catch (Exception e3) {
                    logger.error("\u56de\u6eda\u8d26\u6237\u5931\u8d25 {}", (Object)JSON.toJSONString((Object)e3));
                    e3.printStackTrace();
                    throw new BizException("\u56de\u6eda\u8d26\u6237\u5931\u8d25,\u539f\u56e0 " + e3.getMessage());
                }
                finally {
                    this.lockService.unlock(accountLock);
                }
            }
        }
        catch (Exception e4) {
            logger.error("\u56de\u6eda\u5931\u8d25 {}", (Object)JSON.toJSONString((Object)e4));
            e4.printStackTrace();
            throw new BizException("\u56de\u6eda\u5931\u8d25,\u539f\u56e0 " + e4.getMessage());
        }
        finally {
            this.lockService.unlock(lock);
        }
    }

    private void rollbacoSaveStatement(ExchangeBalanceRollBackReqDto rollBackReqDto, ExchangeBalanceAccountEo eo) {
        ExchangeBalanceStatementEo deductionStatementEo;
        BigDecimal currAvaBalance;
        ExchangeBalanceStatementEo deductionHistoryStatementEo;
        Map<Integer, ExchangeBalanceStatementEo> statementEoMap;
        eo.setFreeze((BigDecimal)ObjectUtil.defaultIfNull((Object)eo.getFreeze(), (Object)this.getFreeze(eo.getId())));
        ExchangeBalanceStatementEo queryStatementEo = new ExchangeBalanceStatementEo();
        queryStatementEo.setOrderNo(rollBackReqDto.getOrderNo());
        queryStatementEo.setActivityId(eo.getActivityId());
        queryStatementEo.setCustomerId(eo.getCustomerId());
        List statementEos = this.exchangeBalanceStatementDas.select((BaseEo)queryStatementEo);
        logger.info("\u56de\u6eda\u989d\u5ea6 {} \u83b7\u53d6\u5230\u5173\u8054\u6d41\u6c34 {}", (Object)rollBackReqDto.getOrderNo(), (Object)JSON.toJSONString((Object)statementEos));
        List<Object> advStatementEos = Lists.newArrayList();
        List<Object> freezeStatementEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)statementEos)) {
            advStatementEos = statementEos.stream().filter(e -> Objects.equals(e.getBalanceType(), ExchangeBalanceTypeEnum.ADVANCE.getKey())).collect(Collectors.toList());
            freezeStatementEos = statementEos.stream().filter(e -> Objects.equals(e.getBalanceType(), ExchangeBalanceTypeEnum.FREEZE.getKey())).collect(Collectors.toList());
            statementEos = statementEos.stream().filter(e -> Objects.equals(e.getBalanceType(), ExchangeBalanceTypeEnum.EXCHANGE.getKey())).collect(Collectors.toList());
        }
        ArrayList insertStatementEos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)statementEos)) {
            ExchangeBalanceStatementEo giveHistoryStatementEo;
            statementEoMap = statementEos.stream().collect(Collectors.toMap(ExchangeBalanceStatementEo::getChangeType, e -> e, (e1, e2) -> e1));
            deductionHistoryStatementEo = statementEoMap.get(ExchangeStatementChangeTypeEnum.ORDER_DEDUCTION.getType());
            currAvaBalance = eo.getAvailableBalance();
            if (deductionHistoryStatementEo != null) {
                deductionStatementEo = new ExchangeBalanceStatementEo();
                deductionStatementEo.setBalanceAccountId(deductionHistoryStatementEo.getBalanceAccountId());
                deductionStatementEo.setActivityId(deductionHistoryStatementEo.getActivityId());
                deductionStatementEo.setCustomerId(deductionHistoryStatementEo.getCustomerId());
                deductionStatementEo.setCustomerCode(deductionHistoryStatementEo.getCustomerCode());
                deductionStatementEo.setCustomerName(deductionHistoryStatementEo.getCustomerName());
                deductionStatementEo.setOrderNo(deductionHistoryStatementEo.getOrderNo());
                deductionStatementEo.setOrganizationId(deductionHistoryStatementEo.getOrganizationId());
                deductionStatementEo.setChangeType(ExchangeStatementChangeTypeEnum.ORDER_BACK.getType());
                deductionStatementEo.setOldBalance(currAvaBalance);
                deductionStatementEo.setChangeBalance(deductionHistoryStatementEo.getChangeBalance().negate());
                currAvaBalance = currAvaBalance.add(deductionHistoryStatementEo.getChangeBalance().negate());
                deductionStatementEo.setNewBalance(currAvaBalance);
                deductionStatementEo.setBalanceType(ExchangeBalanceTypeEnum.EXCHANGE.getKey());
                insertStatementEos.add(deductionStatementEo);
            }
            if ((giveHistoryStatementEo = statementEoMap.get(ExchangeStatementChangeTypeEnum.ORDER_GIVE.getType())) != null) {
                ExchangeBalanceStatementEo giveStatementEo = new ExchangeBalanceStatementEo();
                giveStatementEo.setBalanceAccountId(giveHistoryStatementEo.getBalanceAccountId());
                giveStatementEo.setActivityId(giveHistoryStatementEo.getActivityId());
                giveStatementEo.setCustomerId(giveHistoryStatementEo.getCustomerId());
                giveStatementEo.setCustomerCode(giveHistoryStatementEo.getCustomerCode());
                giveStatementEo.setCustomerName(giveHistoryStatementEo.getCustomerName());
                giveStatementEo.setOrderNo(giveHistoryStatementEo.getOrderNo());
                giveStatementEo.setOrganizationId(giveHistoryStatementEo.getOrganizationId());
                giveStatementEo.setChangeType(ExchangeStatementChangeTypeEnum.GIVE_BACK.getType());
                giveStatementEo.setOldBalance(currAvaBalance);
                giveStatementEo.setChangeBalance(giveHistoryStatementEo.getChangeBalance().negate());
                giveStatementEo.setNewBalance(currAvaBalance.subtract(giveHistoryStatementEo.getChangeBalance()));
                giveStatementEo.setBalanceType(ExchangeBalanceTypeEnum.EXCHANGE.getKey());
                insertStatementEos.add(giveStatementEo);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)advStatementEos)) {
            statementEoMap = advStatementEos.stream().collect(Collectors.toMap(ExchangeBalanceStatementEo::getChangeType, e -> e, (e1, e2) -> e1));
            deductionHistoryStatementEo = statementEoMap.get(ExchangeStatementChangeTypeEnum.ORDER_DEDUCTION.getType());
            currAvaBalance = eo.getAdvanceSurplusBalance();
            if (deductionHistoryStatementEo != null) {
                deductionStatementEo = new ExchangeBalanceStatementEo();
                deductionStatementEo.setBalanceAccountId(deductionHistoryStatementEo.getBalanceAccountId());
                deductionStatementEo.setActivityId(deductionHistoryStatementEo.getActivityId());
                deductionStatementEo.setCustomerId(deductionHistoryStatementEo.getCustomerId());
                deductionStatementEo.setCustomerCode(deductionHistoryStatementEo.getCustomerCode());
                deductionStatementEo.setCustomerName(deductionHistoryStatementEo.getCustomerName());
                deductionStatementEo.setOrderNo(deductionHistoryStatementEo.getOrderNo());
                deductionStatementEo.setOrganizationId(deductionHistoryStatementEo.getOrganizationId());
                deductionStatementEo.setChangeType(ExchangeStatementChangeTypeEnum.ORDER_BACK.getType());
                deductionStatementEo.setOldBalance(currAvaBalance);
                deductionStatementEo.setChangeBalance(deductionHistoryStatementEo.getChangeBalance().negate());
                currAvaBalance = currAvaBalance.add(deductionHistoryStatementEo.getChangeBalance().negate());
                deductionStatementEo.setNewBalance(currAvaBalance);
                deductionStatementEo.setBalanceType(ExchangeBalanceTypeEnum.ADVANCE.getKey());
                insertStatementEos.add(deductionStatementEo);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)freezeStatementEos)) {
            statementEoMap = freezeStatementEos.stream().collect(Collectors.toMap(ExchangeBalanceStatementEo::getChangeType, e -> e, (e1, e2) -> {
                e1.setChangeBalance(e1.getChangeBalance().add(e2.getChangeBalance()));
                return e1;
            }));
            deductionHistoryStatementEo = statementEoMap.get(ExchangeStatementChangeTypeEnum.GIVE_FREEZE.getType());
            ExchangeBalanceStatementEo deductionHistoryStatementEo2 = statementEoMap.get(ExchangeStatementChangeTypeEnum.RELEASE_FREEZE.getType());
            BigDecimal currAvaBalance2 = eo.getFreeze();
            if (deductionHistoryStatementEo != null || deductionHistoryStatementEo2 != null) {
                ExchangeBalanceStatementEo deductionStatementEo2 = new ExchangeBalanceStatementEo();
                BigDecimal changeBalance = Optional.ofNullable(deductionHistoryStatementEo).map(ExchangeBalanceStatementEo::getChangeBalance).orElse(BigDecimal.ZERO);
                changeBalance = changeBalance.add(Optional.ofNullable(deductionHistoryStatementEo2).map(ExchangeBalanceStatementEo::getChangeBalance).orElse(BigDecimal.ZERO));
                ExchangeBalanceStatementEo deductionHistoryStatementEo3 = Optional.ofNullable(deductionHistoryStatementEo).orElse(deductionHistoryStatementEo2);
                deductionStatementEo2.setBalanceAccountId(deductionHistoryStatementEo3.getBalanceAccountId());
                deductionStatementEo2.setActivityId(deductionHistoryStatementEo3.getActivityId());
                deductionStatementEo2.setCustomerId(deductionHistoryStatementEo3.getCustomerId());
                deductionStatementEo2.setCustomerCode(deductionHistoryStatementEo3.getCustomerCode());
                deductionStatementEo2.setCustomerName(deductionHistoryStatementEo3.getCustomerName());
                deductionStatementEo2.setOrderNo(deductionHistoryStatementEo3.getOrderNo());
                deductionStatementEo2.setOrganizationId(deductionHistoryStatementEo3.getOrganizationId());
                deductionStatementEo2.setChangeType(changeBalance.compareTo(BigDecimal.ZERO) > 0 ? ExchangeStatementChangeTypeEnum.RELEASE_FREEZE.getType() : ExchangeStatementChangeTypeEnum.GIVE_FREEZE.getType());
                deductionStatementEo2.setOldBalance(currAvaBalance2);
                deductionStatementEo2.setChangeBalance(changeBalance.negate());
                currAvaBalance2 = currAvaBalance2.add(changeBalance.negate());
                deductionStatementEo2.setNewBalance(currAvaBalance2);
                deductionStatementEo2.setBalanceType(ExchangeBalanceTypeEnum.FREEZE.getKey());
                if (changeBalance.compareTo(BigDecimal.ZERO) != 0) {
                    insertStatementEos.add(deductionStatementEo2);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)insertStatementEos)) {
            this.exchangeBalanceStatementDas.insertBatch((List)insertStatementEos);
        }
    }

    @Override
    public void manualAdjust(ManualAdjustReqDto manualAdjustReqDto) {
        int row;
        ExchangeBalanceAccountEo queryEo = new ExchangeBalanceAccountEo();
        queryEo.setId(manualAdjustReqDto.getId());
        ExchangeBalanceAccountEo exchangeBalanceAccountEo = (ExchangeBalanceAccountEo)this.exchangeBalanceAccountDas.selectOne((BaseEo)queryEo);
        if (exchangeBalanceAccountEo == null) {
            throw new BizException("\u6362\u8d2d\u989d\u5ea6\u8d26\u6237\u4e0d\u5b58\u5728");
        }
        BigDecimal amount = manualAdjustReqDto.getAmount();
        if (ExchangeAdjustTypeEnum.SUB.getType().equals(manualAdjustReqDto.getAdjustType())) {
            amount = amount.negate();
        }
        if ((row = this.exchangeBalanceAccountDas.updateForManualAdjust(manualAdjustReqDto.getId(), amount, manualAdjustReqDto.getBeforAmount())) == 0) {
            throw new BizException("\u624b\u5de5\u8c03\u6574\u5931\u8d25");
        }
        ExchangeBalanceStatementEo manualAdjustStatementEo = new ExchangeBalanceStatementEo();
        manualAdjustStatementEo.setBalanceAccountId(exchangeBalanceAccountEo.getId());
        manualAdjustStatementEo.setActivityId(exchangeBalanceAccountEo.getActivityId());
        manualAdjustStatementEo.setCustomerId(exchangeBalanceAccountEo.getCustomerId());
        manualAdjustStatementEo.setCustomerCode(exchangeBalanceAccountEo.getCustomerCode());
        manualAdjustStatementEo.setCustomerName(exchangeBalanceAccountEo.getCustomerName());
        manualAdjustStatementEo.setOrganizationId(exchangeBalanceAccountEo.getOrganizationId());
        manualAdjustStatementEo.setChangeType(ExchangeStatementChangeTypeEnum.MANUAL_ADJUST.getType());
        manualAdjustStatementEo.setOldBalance(exchangeBalanceAccountEo.getAvailableBalance());
        manualAdjustStatementEo.setChangeBalance(amount);
        manualAdjustStatementEo.setNewBalance(exchangeBalanceAccountEo.getAvailableBalance().add(amount));
        manualAdjustStatementEo.setRemark(manualAdjustReqDto.getRemark());
        manualAdjustStatementEo.setBalanceType(ExchangeBalanceTypeEnum.EXCHANGE.getKey());
        this.exchangeBalanceStatementDas.insert((BaseEo)manualAdjustStatementEo);
    }

    private BigDecimal ofBigDecimalZero(BigDecimal num) {
        return Objects.nonNull(num) ? num : BigDecimal.ZERO;
    }
}

