/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityJoinLogDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityJoinLogReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityJoinLogExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IActivityJoinLogExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ActivityJoinLogDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ActivityJoinLogEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="activityJoinLogQueryExtService")
public class ActivityJoinLogExtQueryServiceImpl
implements IActivityJoinLogExtQueryService {
    @Resource
    private ActivityJoinLogDas activityJoinLogDas;
    @Resource
    private ActivityDas activityDas;

    @Override
    public int countActivityJoinTime(ActivityJoinLogDto reqDto) {
        if (reqDto.getUserId() == null || reqDto.getActivityId() == null) {
            throw new BusinessRuntimeException("\u7528\u6237id\u6216\u8005\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ActivityJoinLogEo queryEo = new ActivityJoinLogEo();
        queryEo.setUserId(reqDto.getUserId());
        queryEo.setActivityId(reqDto.getActivityId());
        return this.activityJoinLogDas.count((BaseEo)queryEo);
    }

    @Override
    public List<ActivityJoinLogExtRespDto> queryList(ActivityJoinLogReqDto reqDto) {
        ArrayList resp = Lists.newArrayList();
        ActivityJoinLogEo forQuery = this.getQueryEo(reqDto);
        List eoList = this.activityJoinLogDas.select((BaseEo)forQuery);
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            CubeBeanUtils.copyCollection((Collection)resp, (Collection)eoList, ActivityJoinLogExtRespDto.class);
        }
        return resp;
    }

    @Override
    public PageInfo<ActivityJoinLogExtRespDto> queryPage(ActivityJoinLogReqDto reqDto) {
        PageInfo result = new PageInfo();
        ActivityJoinLogEo forQuery = this.getQueryEo(reqDto);
        PageInfo sourcePage = this.activityJoinLogDas.selectPage((BaseEo)forQuery, reqDto.getPageNum(), reqDto.getPageSize());
        if (sourcePage != null && CollectionUtils.isNotEmpty((Collection)sourcePage.getList())) {
            ArrayList list = Lists.newArrayList();
            BeanUtils.copyProperties((Object)sourcePage, (Object)result, (String[])new String[]{"list"});
            CubeBeanUtils.copyCollection((Collection)list, (Collection)sourcePage.getList(), ActivityJoinLogExtRespDto.class);
            result.setList((List)list);
        }
        return result;
    }

    private ActivityJoinLogEo getQueryEo(ActivityJoinLogReqDto reqDto) {
        ActivityJoinLogEo forQuery = ActivityJoinLogEo.newInstance();
        if (reqDto != null) {
            List<Long> activityIds;
            forQuery.setItemId(reqDto.getItemId());
            forQuery.setSerialNumber(reqDto.getSerialNumber());
            ArrayList sqlFilters = Lists.newArrayList();
            BeanUtils.copyProperties((Object)reqDto, (Object)forQuery);
            if (reqDto.getActivityType() != null && CollectionUtils.isNotEmpty(activityIds = this.getActivityIds(reqDto.getActivityType()))) {
                sqlFilters.add(new SqlFilter("activity_id", SqlFilter.Operator.in, activityIds));
            }
            if (CollectionUtils.isNotEmpty((Collection)reqDto.getItemCodes())) {
                sqlFilters.add(new SqlFilter("item_id", SqlFilter.Operator.in, (Object)reqDto.getItemCodes()));
            }
            forQuery.setSqlFilters((List)sqlFilters);
        }
        return forQuery;
    }

    private List<Long> getActivityIds(ActivityType activityType) {
        Long templateId = activityType.getId();
        ActivityEo forQuery = new ActivityEo();
        forQuery.setActivityTemplateId(templateId);
        List select = this.activityDas.select((BaseEo)forQuery);
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            return select.stream().map(BaseEo::getId).collect(Collectors.toList());
        }
        return null;
    }
}

