/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.apiimpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.Bool;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponCategoryEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponHierarchyEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponMutexTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateErrorEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplatePurposeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateShopTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.constants.enums.CouponTemplateStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateCreateExtReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateDelayReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.CouponTemplateUpdateExtReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.request.TaskCustomerCouponTemplateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateShopDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.service.ICouponTemplateExtApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.CouponValidityTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.config.CouponConfig;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateExtService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.coupon.service.ICouponTemplateStockService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.coupon.CouponTemplateEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="couponTemplateExtApi")
public class CouponTemplateExtApiImpl
implements ICouponTemplateExtApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICouponExtService couponExtService;
    @Autowired
    private ICouponTemplateExtService couponTemplateExtService;
    @Autowired
    private ICouponTemplateExtQueryService couponTemplateExtQueryService;
    @Autowired
    private ICouponTemplateStockService couponTemplateStockService;
    @Autowired
    private CouponConfig couponConfig;
    @Autowired
    private IActivityService activityService;

    public RestResponse<Long> addCouponTemplate(CouponTemplateCreateExtReqDto couponCreateReqExtDto) {
        CouponTemplateEo couponTemplateEo = this.couponTemplateExtService.addCouponTemplate(couponCreateReqExtDto);
        this.couponTemplateStockService.initStock(couponTemplateEo.getId());
        return new RestResponse((Object)couponTemplateEo.getId());
    }

    public RestResponse<Void> modifyCouponTemplateById(Long id, CouponTemplateCreateExtReqDto couponCreateReqExtDto) {
        this.couponTemplateExtService.modifyCouponTemplateById(id, couponCreateReqExtDto);
        this.couponTemplateStockService.modifyStock(id);
        return RestResponse.VOID;
    }

    public RestResponse<List<CouponTemplateExtRespDto>> syncCouponTemplate(String json) {
        this.logger.info("\u4f18\u60e0\u5238\u6a21\u677f\u540c\u6b65, json={}", (Object)json);
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            JSONArray jsonArray = JSON.parseArray((String)json);
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                Boolean shareNy = jsonObject.getBoolean("shareNy");
                Boolean saleNy = jsonObject.getBoolean("saleNy");
                String notes = jsonObject.getString("notes");
                String cpnTptId = jsonObject.getString("cpnTptId");
                String campaignId = jsonObject.getString("campaignId");
                String content = jsonObject.getString("content");
                String couponType = jsonObject.getString("couponType");
                Long limitQty = jsonObject.getLong("limitQty");
                BigDecimal minOrderAmt = jsonObject.getBigDecimal("minOrderAmt");
                BigDecimal dcAmt = jsonObject.getBigDecimal("dcAmt");
                Integer discount = jsonObject.getInteger("discount");
                discount = discount == null ? 1 : discount;
                BigDecimal saleAmt = jsonObject.getBigDecimal("saleAmt");
                String issueDept = jsonObject.getString("issueDept");
                String bukrs = jsonObject.getString("bukrs");
                Integer limitFlag = jsonObject.getInteger("limitFlag");
                Integer storeAll = jsonObject.getInteger("storeAll");
                String produceAll = jsonObject.getString("produceAll");
                Integer fctType = jsonObject.getInteger("fctType");
                String cpnLevel = jsonObject.getString("cpnLevel");
                Integer type = jsonObject.getInteger("type");
                String noShareRule = jsonObject.getString("noShareRule");
                String validtyMode = jsonObject.getString("validtyMode");
                Date validDate = jsonObject.getDate("validDate");
                String invalidDateStr = jsonObject.getString("invalidDate");
                if (StringUtils.isNotBlank((CharSequence)invalidDateStr)) {
                    invalidDateStr = invalidDateStr.replace("00:00:00", "23:59:59");
                }
                String fixedDays = jsonObject.getString("fixedDays");
                String prevCoupon = jsonObject.getString("prevCoupon");
                Integer createdCode = jsonObject.getInteger("createdCode");
                String validFlag = jsonObject.getString("validFlag");
                String supplier = jsonObject.getString("zsupplier");
                String applicantNo = jsonObject.getString("applicantNo");
                String applicantName = jsonObject.getString("applicantName");
                CouponTemplateCreateExtReqDto couponTemplateCreateExtReqDto = new CouponTemplateCreateExtReqDto();
                couponTemplateCreateExtReqDto.setCouponCode(cpnTptId);
                couponTemplateCreateExtReqDto.setCouponName(content);
                couponTemplateCreateExtReqDto.setCouponTemplateStatus(CouponTemplateStatusEnum.ACTIVATE.getStatus());
                couponTemplateCreateExtReqDto.setCouponType(StringUtils.isBlank((CharSequence)couponType) ? CouponTypeEnum.COUPON.getType() : CouponTypeEnum.findEnum((String)couponType).getType());
                String hierarchy = "X".equals(cpnLevel) ? CouponHierarchyEnum.ORDER.getHierarchy() : ("Y".equals(cpnLevel) ? CouponHierarchyEnum.CATEGORY.getHierarchy() : CouponHierarchyEnum.ITEM.getHierarchy());
                couponTemplateCreateExtReqDto.setHierarchy(hierarchy);
                couponTemplateCreateExtReqDto.setTotalIssueQuantity(limitQty);
                couponTemplateCreateExtReqDto.setIsDirectional(Integer.valueOf(shareNy != false ? 1 : 0));
                couponTemplateCreateExtReqDto.setIsGroupPurchase(Integer.valueOf(saleNy != false ? 1 : 0));
                couponTemplateCreateExtReqDto.setGroupPurchasePrice(saleAmt);
                couponTemplateCreateExtReqDto.setCouponCategory(CouponCategoryEnum.findEnum((Integer)type).getCategory());
                couponTemplateCreateExtReqDto.setAmount(minOrderAmt);
                couponTemplateCreateExtReqDto.setCouponValue(dcAmt);
                couponTemplateCreateExtReqDto.setShopType(CouponTemplateShopTypeEnum.findEnum((Integer)storeAll).getType());
                couponTemplateCreateExtReqDto.setPurpose(CouponTemplatePurposeEnum.findEnum((Integer)fctType).getPurpose());
                if ("X".equals(validtyMode)) {
                    couponTemplateCreateExtReqDto.setValidityType(CouponValidityTypeEnum.DYNAMIC_DATE.getType());
                    String afterDate = StringUtils.isBlank((CharSequence)prevCoupon) || "0".equals(prevCoupon) ? "1" : prevCoupon;
                    String dynamicDate = "{\"afterDate\":\"" + afterDate + "\",\"day\":\"" + fixedDays + "\"}";
                    couponTemplateCreateExtReqDto.setDynamicDate(dynamicDate);
                } else {
                    couponTemplateCreateExtReqDto.setEffectiveTime(validDate);
                    couponTemplateCreateExtReqDto.setInvalidTime(DateUtil.parseDate((String)invalidDateStr, (String)"yyyy-MM-dd HH:mm:ss"));
                    couponTemplateCreateExtReqDto.setValidityType(CouponValidityTypeEnum.FIXED_DATE.getType());
                }
                CouponMutexTypeEnum mutexTypeEnum = CouponMutexTypeEnum.findEnum((Integer)limitFlag);
                couponTemplateCreateExtReqDto.setMutexType(mutexTypeEnum == null ? CouponMutexTypeEnum.NO_MUTEX.getMutex() : mutexTypeEnum.getMutex());
                couponTemplateCreateExtReqDto.setMarketingCode(campaignId);
                couponTemplateCreateExtReqDto.setRuleExplain(notes);
                couponTemplateCreateExtReqDto.setRemark(content);
                couponTemplateCreateExtReqDto.setIsGenerateCode(createdCode == 0 ? Bool.YES.getKey() : Bool.NO.getKey());
                couponTemplateCreateExtReqDto.setIssueDept(issueDept);
                couponTemplateCreateExtReqDto.setBukrs(bukrs);
                couponTemplateCreateExtReqDto.setIsStoreMutex(Integer.valueOf(discount == 1 ? 0 : 1));
                couponTemplateCreateExtReqDto.setSupplier(supplier);
                couponTemplateCreateExtReqDto.setApplicantNo(applicantNo);
                couponTemplateCreateExtReqDto.setApplicantName(applicantName);
                ArrayList<ConditionReqDto> conditionList = new ArrayList<ConditionReqDto>();
                ConditionReqDto shopCondition = this.parseShopCondition(jsonObject.getJSONArray("cpnChnls"));
                ConditionReqDto itemCondition = this.parseItemCondition(jsonObject.getJSONArray("cpnProds"));
                ConditionReqDto limitCondition = this.createLimitCondition();
                conditionList.add(shopCondition);
                conditionList.add(itemCondition);
                conditionList.add(limitCondition);
                couponTemplateCreateExtReqDto.setConditions(conditionList);
                List<ActionReqDto> actionList = this.createActionList();
                couponTemplateCreateExtReqDto.setActions(actionList);
                couponTemplateCreateExtReqDto.setActivityTemplateId(this.couponConfig.getActivityTemplateId());
                couponTemplateCreateExtReqDto.setAuditStatusEnum(AuditStatusEnum.AUDIT_PASS);
                couponTemplateCreateExtReqDto.setActivityStatusEnum(ActivityStatusEnum.ACTIVATE);
                CouponTemplateEo couponTemplateEo = this.couponTemplateExtService.addCouponTemplate(couponTemplateCreateExtReqDto);
                this.couponTemplateStockService.initStock(couponTemplateEo.getId());
                ids.add(couponTemplateEo.getId());
            }
        }
        catch (Exception e) {
            this.logger.error("OA\u4f18\u60e0\u5238\u6a21\u677f\u540c\u6b65error, message={}", (Object)e.getMessage(), (Object)e);
            throw new ProBizException(CouponTemplateErrorEnum.COUPON_TEMPLATE_SYNC_ERROR.getMsg());
        }
        return new RestResponse(this.couponTemplateExtQueryService.listByIds(ids));
    }

    public RestResponse<Void> editCouponTemplate(CouponTemplateUpdateExtReqDto couponTemplateUpdateExtReqDto) {
        this.couponTemplateExtService.editCouponTemplate(couponTemplateUpdateExtReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> invalid(Long id) {
        this.couponTemplateExtService.invalid(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> setStatus(Long id, String status) {
        this.couponTemplateExtService.setStatus(id, status);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delay(CouponTemplateDelayReqDto couponTemplateDelayReqDto) {
        this.couponTemplateExtService.delay(couponTemplateDelayReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> batchActivate(@Valid List<Long> ids) {
        this.couponTemplateExtService.batchActivate(ids);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        this.couponTemplateExtService.delete(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> initStock() {
        this.couponTemplateExtService.initStock();
        return RestResponse.VOID;
    }

    public RestResponse<Long> addCustTmplByMember(List<TaskCustomerCouponTemplateReqDto> taskCustomerCouponTemplateReqDtos) {
        return new RestResponse((Object)this.couponTemplateExtService.addCustTmplByMember(taskCustomerCouponTemplateReqDtos));
    }

    public RestResponse<Void> deleteCustTmplByTaskId(Long taskId) {
        this.couponTemplateExtService.deleteCustTmplByTaskId(taskId);
        return RestResponse.VOID;
    }

    private ConditionReqDto createLimitCondition() {
        ConditionReqDto condition = new ConditionReqDto();
        condition.setConditionTemplateId(this.couponConfig.getLimitConditionTemplateId());
        condition.setRuleId(this.couponConfig.getRuleId());
        condition.setConditionParams("{'CouponReceiveLimitCondition.limit':1}");
        return condition;
    }

    private ConditionReqDto parseShopCondition(JSONArray shops) {
        ArrayList<CouponTemplateShopDto> shopList = new ArrayList<CouponTemplateShopDto>();
        if (CollectionUtils.isNotEmpty((Collection)shops)) {
            for (int i = 0; i < shops.size(); ++i) {
                JSONObject shopObject = shops.getJSONObject(i);
                String shopCode = shopObject.getString("storeId");
                String validFlag = shopObject.getString("validFlag");
                boolean effective = StringUtils.isNotBlank((CharSequence)validFlag) && "X".equals(validFlag);
                shopList.add(new CouponTemplateShopDto(shopCode, Boolean.valueOf(effective)));
            }
        }
        ConditionReqDto condition = new ConditionReqDto();
        condition.setConditionTemplateId(this.couponConfig.getShopConditionTemplateId());
        condition.setRuleId(this.couponConfig.getRuleId());
        HashMap<String, ArrayList<CouponTemplateShopDto>> params = new HashMap<String, ArrayList<CouponTemplateShopDto>>();
        params.put("CouponShopCondition.shopIds", shopList);
        condition.setConditionParams(JSON.toJSONString(params));
        return condition;
    }

    private ConditionReqDto parseItemCondition(JSONArray items) {
        ArrayList<CouponTemplateItemDto> itemList = new ArrayList<CouponTemplateItemDto>();
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            for (int i = 0; i < items.size(); ++i) {
                JSONObject itemObject = items.getJSONObject(i);
                String itemCode = itemObject.getString("productId");
                String notYn = itemObject.getString("notYn");
                boolean exclude = !StringUtils.isBlank((CharSequence)notYn) && !"10".equals(notYn);
                String validFlag = itemObject.getString("validFlag");
                boolean effective = StringUtils.isNotBlank((CharSequence)validFlag) && "X".equals(validFlag);
                itemList.add(new CouponTemplateItemDto(itemCode, exclude, effective));
            }
        }
        ConditionReqDto condition = new ConditionReqDto();
        condition.setConditionTemplateId(this.couponConfig.getItemCondtionTemplateId());
        condition.setRuleId(this.couponConfig.getRuleId());
        HashMap<String, ArrayList<CouponTemplateItemDto>> params = new HashMap<String, ArrayList<CouponTemplateItemDto>>();
        params.put("CouponItemsCondition.items", itemList);
        condition.setConditionParams(JSON.toJSONString(params));
        return condition;
    }

    private List<ActionReqDto> createActionList() {
        ArrayList<ActionReqDto> actionList = new ArrayList<ActionReqDto>();
        this.couponConfig.getActionTriggerMap().forEach((actionTempateId, triggerIds) -> triggerIds.forEach(triggerId -> {
            ActionReqDto actionReqDto = new ActionReqDto();
            actionReqDto.setActionTemplateId(actionTempateId);
            actionReqDto.setTriggerId(triggerId);
            actionReqDto.setActionParams("");
            actionList.add(actionReqDto);
        }));
        return actionList;
    }
}

