/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.coupon.service.ICouponService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class CouponReceiveLimitCondition
extends ConditionTemplate {
    @Autowired
    private ICouponService couponService;
    public static final String RECEIVE_LIMIT = "CouponReceiveLimitCondition.limit";

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine templateDefine, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        long userId = context.getUserId();
        long couponTemplateId = context.getCouponTemplateId();
        int received = this.couponService.countByConditions(userId, couponTemplateId);
        Param param = templateDefine.getParam(RECEIVE_LIMIT);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u9886\u53d6\u9650\u5236\u672a\u914d\u7f6e"}));
        }
        int limit = (Integer)ConditionTemplate.converter(configParams.get(RECEIVE_LIMIT), param, templateDefine.getLoadClass());
        if (received >= limit) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u9886\u53d6\u6570\u91cf\u5df2\u8d85\u9650"}));
        }
        return true;
    }
}

