/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.engine.condition.bestore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirItemRelativeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirItemRelativeQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IDirectoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.crowdordering.dto.request.ActivityItemDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProBizException;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exception.ProExceptionCode;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ActivityCoupon;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.ItemVo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.Param;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.engine.core.ItemConditionTemplate;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CouponCategoryCondition
extends ItemConditionTemplate {
    public static final String CONFIG_PARAM_KEY_CATEGORY = "CouponCategoryCondition.categories";
    private Logger logger = LoggerFactory.getLogger(CouponCategoryCondition.class);
    @Autowired
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemActivityTagService itemActivityTagService;
    @Resource
    private IActivityService activityService;
    @Resource
    private IDirectoryQueryApi directoryQueryApi;

    @Override
    public <T extends EngineParams> boolean execute(TemplateDefine define, ConditionRespDto conditionRespDto, T context, Map<String, ?> configParams) {
        Param param = define.getParam(CONFIG_PARAM_KEY_CATEGORY);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u5546\u54c1\u54c1\u7c7b\u9650\u5236\u672a\u914d\u7f6e"}));
        }
        Collection categories = (Collection)ConditionTemplate.converter(configParams.get(CONFIG_PARAM_KEY_CATEGORY), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)categories)) {
            return true;
        }
        context.getItems().removeIf(itemVo -> itemVo.getItemCategory().parallelStream().noneMatch(dirId -> categories.parallelStream().anyMatch(category -> category.equals(dirId))));
        if (CollectionUtils.isEmpty((Collection)context.getItems())) {
            throw new ProBizException(ProExceptionCode.PARAMETER_ERROR.format(new String[]{"\u54c1\u7c7b\u5238\u65e0\u5bf9\u5e94\u7684\u5546\u54c1"}));
        }
        ActivityCoupon activityCoupon = context.getCouponByActivityId(Long.valueOf(context.getActivityId()));
        if (activityCoupon != null) {
            activityCoupon.setItems(context.getItems());
        }
        return true;
    }

    @Override
    public boolean apply(TemplateDefine define, ConditionRespDto conditionRespDto, ItemVo itemVo) {
        JSONObject configParams = JSON.parseObject((String)conditionRespDto.getConditionParams());
        Param param = define.getParam(CONFIG_PARAM_KEY_CATEGORY);
        Collection categories = (Collection)ConditionTemplate.converter(configParams.get(CONFIG_PARAM_KEY_CATEGORY), param, define.getLoadClass());
        if (CollectionUtils.isEmpty((Collection)categories)) {
            return true;
        }
        DirItemRelativeReqDto reqDto = new DirItemRelativeReqDto();
        reqDto.setItemId(Long.valueOf(itemVo.getItemId()));
        reqDto.setShopId(Long.valueOf(itemVo.getShopId()));
        List dirItems = (List)this.itemQueryApi.queryItemDirRelative(JSON.toJSONString((Object)reqDto)).getData();
        if (CollectionUtils.isEmpty((Collection)dirItems)) {
            return false;
        }
        List dirIdList = dirItems.stream().map(DirItemRelativeQueryRespDto::getDirId).collect(Collectors.toList());
        dirIdList.retainAll(categories);
        return !dirIdList.isEmpty();
    }

    @Override
    public Set<ActivityItemDto> getItems(TemplateDefine define, ConditionRespDto conditionRespDto, Map<String, ?> configParams) {
        Param param = define.getParam(CONFIG_PARAM_KEY_CATEGORY);
        if (null == param) {
            throw new ProBizException(ProExceptionCode.ENGINE_CONFIG_ERR.format(new String[]{"\u5546\u54c1\u54c1\u7c7b\u9650\u5236\u672a\u914d\u7f6e"}));
        }
        List categories = (List)ConditionTemplate.converter(configParams.get(CONFIG_PARAM_KEY_CATEGORY), param, define.getLoadClass());
        ActivityRespDto activityRespDto = this.activityService.queryById(conditionRespDto.getActivityId());
        if (null == activityRespDto) {
            return Collections.EMPTY_SET;
        }
        ItemShelfQueryReqDto queryReqDto = new ItemShelfQueryReqDto();
        queryReqDto.setInstanceId(activityRespDto.getInstanceId());
        queryReqDto.setTenantId(activityRespDto.getTenantId());
        queryReqDto.setSellerId(activityRespDto.getSellerId());
        queryReqDto.setShopId(activityRespDto.getShopId());
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)categories)) {
            DirectoryReqDto directoryReqDto = new DirectoryReqDto();
            directoryReqDto.setIds(categories);
            RestResponse response = this.directoryQueryApi.queryLinkAndChildDirIdListByDirId(directoryReqDto);
            queryReqDto.setDirIds((List)RestResponseHelper.extractData((RestResponse)response));
        }
        return this.itemActivityTagService.queryItemsForB2b(queryReqDto);
    }

    public static List<Long> parseParams(String conditionParams) {
        if (StringUtils.isEmpty((Object)conditionParams)) {
            return Lists.newArrayList();
        }
        JSONArray jsonArray = JSON.parseObject((String)conditionParams).getJSONArray(CONFIG_PARAM_KEY_CATEGORY);
        if (jsonArray != null) {
            return jsonArray.toJavaList(Long.class);
        }
        return Lists.newArrayList();
    }
}

