/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityAuditReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityExtDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityListRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.ActivityRespExtDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityDimensionEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.IActivityApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityExtQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityOverlapRuleQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IActivityQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IItemActivityTagQueryApi;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.CouponTemplateExtRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.BaseActivityDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.common.CouponTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group.ActivityQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.request.group.PageEditActivityReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.CouponInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.GroupInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.ItemActivityInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.ItemForActivityInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.agg.dto.response.PromotionInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.IActivityAggService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.ICouponTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ActivityFactory;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.condition.ConditionTemplate;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.enums.QueryActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.impl.MarketingModuleHelper;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.agg.util.PageInfoUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ActivityAggServiceImpl
implements IActivityAggService {
    private static Logger logger = LoggerFactory.getLogger(ActivityAggServiceImpl.class);
    @Resource(name="activityQueryApiImpl")
    private IActivityQueryApi activityQueryApi;
    @Resource(name="activityApiImpl")
    private IActivityApi activityApi;
    @Resource
    private MarketingModuleHelper marketingModuleHelper;
    @Resource
    private IContext context;
    @Resource(name="activityExtQueryApi")
    private IActivityExtQueryApi activityExtQueryApi;
    @Resource(name="itemActivityTagQueryImpl")
    private IItemActivityTagQueryApi itemActivityTagQueryApi;
    @Resource
    private ICouponTemplate couponTemplate;
    @Resource(name="activityOverlapRuleQueryApiImpl")
    private IActivityOverlapRuleQueryApi activityOverlapRuleQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;

    @Override
    public ItemForActivityInfoRespDto queryActivityByItemId(long itemId, boolean validStatus) {
        List activities = (List)this.activityQueryApi.inverseQuery(itemId, 0L, validStatus).getData();
        ItemForActivityInfoRespDto result = new ItemForActivityInfoRespDto();
        for (ActivityRespExtDto activity : activities) {
            PromotionInfoRespDto info;
            CouponInfoRespDto temp;
            if (null != activity.getCouponInfo()) {
                temp = new CouponInfoRespDto((ActivityRespDto)activity);
                CouponTemplateExtRespDto couponTemplateResDto = (CouponTemplateExtRespDto)activity.getCouponInfo().get(0);
                temp.setAmount(couponTemplateResDto.getAmount().toString());
                temp.setCouponCategory(couponTemplateResDto.getCouponCategory().intValue());
                temp.setCouponRange(couponTemplateResDto.getCouponRange());
                temp.setCouponValue(couponTemplateResDto.getCouponValue().toString());
                info = temp;
                result.addCouponPromotions((CouponInfoRespDto)info);
            }
            if (null != activity.getCrowdOrdering()) {
                temp = new GroupInfoRespDto((ActivityRespDto)activity);
                temp.setActivityGroupRespDtos(activity.getCrowdOrdering());
                info = temp;
                result.addActivityGroupPromotions((GroupInfoRespDto)info);
            } else {
                info = new PromotionInfoRespDto((ActivityRespDto)activity);
                result.addNormalPromotions(info);
            }
            for (ConditionTemplate conditionTemplate : ActivityFactory.getActivityTemplate(info.getActivityType())) {
            }
        }
        result.setSystemTime(System.currentTimeMillis());
        return result;
    }

    @Override
    public PageInfo<ActivityListRespDto> queryByPage(ActivityQueryReqDto activityQueryReqDto, Integer pageNum, Integer pageSize) {
        QueryActivityStatusEnum statusEnum;
        ActivityExtDto activityExtDto = new ActivityExtDto();
        activityExtDto.setInstanceId(this.context.instanceId());
        activityExtDto.setTenantId(this.context.tenantId());
        if (StringUtils.isNotBlank((String)activityQueryReqDto.getActivityStatus()) && null != (statusEnum = QueryActivityStatusEnum.getByStatus(activityQueryReqDto.getActivityStatus()))) {
            activityExtDto.setAuditStatusEnum(AuditStatusEnum.valueOf((String)statusEnum.getAdutitStatus()));
            activityExtDto.setActivityStatusEnum(ActivityStatusEnum.valueOf((String)statusEnum.getActivityStatus()));
        }
        if (null != activityQueryReqDto.getActivityType()) {
            activityExtDto.setActivityTemplateId(Long.valueOf(activityQueryReqDto.getActivityType().getId()));
        }
        activityExtDto.setBeginTimeStart(activityQueryReqDto.getActivityTimeStart());
        activityExtDto.setBeginTimeEnd(activityQueryReqDto.getActivityTimeEnd());
        activityExtDto.setActivityName(activityQueryReqDto.getActivityName());
        PageInfo pageInfo = (PageInfo)this.activityExtQueryApi.queryActivityPage(activityExtDto, pageNum, pageSize).getData();
        if (PageInfoUtil.isNotEmpty(pageInfo)) {
            pageInfo.getList().forEach(activity -> activity.setActivityStatus(QueryActivityStatusEnum.getStatus(activity.getActivityStatus(), activity.getAuditStatus())));
        }
        return pageInfo;
    }

    @Override
    public void finish(Long id) {
        ActivityRespDto activityRespDto = this.checkActivity(id);
        if (ActivityStatusEnum.FINISH.getKey().equals(activityRespDto.getActivityStatus())) {
            throw new BizException("\u6d3b\u52a8\u5df2\u7ed3\u675f\uff01");
        }
        if (!ActivityStatusEnum.ACTIVATE.getKey().equals(activityRespDto.getActivityStatus())) {
            throw new BizException("\u672a\u5f00\u59cb\u7684\u6d3b\u52a8\u4e0d\u80fd\u7ed3\u675f\uff01");
        }
        RestResponseHelper.checkOrThrow((RestResponse)this.activityApi.finishById(id.longValue()));
    }

    private ActivityRespDto checkActivity(Long activityId) {
        ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityFatDetail(activityId.longValue()).getData();
        if (activityRespDto == null) {
            throw new BizException("\u6d3b\u52a8\u4e0d\u5b58\u5728\uff01");
        }
        return activityRespDto;
    }

    @Override
    public void delete(Long id) {
        ActivityRespDto activityRespDto = this.checkActivity(id);
        if (!ActivityStatusEnum.READY.getKey().equals(activityRespDto.getActivityStatus())) {
            throw new BizException("\u5f53\u524d\u6d3b\u52a8\u72b6\u6001\u4e0d\u53ef\u5220\u9664\uff01");
        }
        RestResponseHelper.checkOrThrow((RestResponse)this.activityApi.deleteById(id.longValue()));
    }

    @Override
    public PageInfo<ActivityRespDto> queryActivityPage(ActivityDto queryDto, Integer pageNum, Integer pageSize) {
        queryDto.setAuditStatusEnum(AuditStatusEnum.AUDIT_PASS);
        queryDto.setActivityStatus((List)Lists.newArrayList((Object[])new String[]{ActivityStatusEnum.READY.getKey(), ActivityStatusEnum.ACTIVATE.getKey()}));
        return (PageInfo)this.activityQueryApi.queryActivityPage(queryDto, pageNum, pageSize).getData();
    }

    @Override
    public ItemForActivityInfoRespDto queryActivityByItemId(Long itemId) {
        ItemForActivityInfoRespDto itemForActivityInfo = new ItemForActivityInfoRespDto();
        ItemActivityTagQueryReqDto queryReqDto = new ItemActivityTagQueryReqDto();
        queryReqDto.setPreheatStartTime(new Date());
        queryReqDto.setItemId(itemId);
        List itemActivityTagDtos = (List)this.itemActivityTagQueryApi.queryList(queryReqDto).getData();
        if (CollectionUtils.isEmpty((Collection)itemActivityTagDtos)) {
            return itemForActivityInfo;
        }
        Map<Integer, List<ItemActivityInfoRespDto>> group = itemActivityTagDtos.stream().map(this::convertToItemActivityInfoRespDto).filter(activityInfo -> activityInfo.getId() != null && activityInfo.getDimension() != null).collect(Collectors.groupingBy(ItemActivityInfoRespDto::getDimension));
        for (Integer dimension : group.keySet()) {
            List<ItemActivityInfoRespDto> activityInfoRespDtos = group.get(dimension);
            if (ActivityDimensionEnum.COUPON.getKey().equals(dimension)) {
                List<ItemActivityInfoRespDto> couponActivityList = this.getCouponActivityInfoRespDtos(activityInfoRespDtos);
                itemForActivityInfo.setCouponActivityInfo(couponActivityList);
                continue;
            }
            if (ActivityDimensionEnum.ITEM.getKey().equals(dimension)) {
                itemForActivityInfo.setItemActivityInfo(activityInfoRespDtos);
                continue;
            }
            if (!ActivityDimensionEnum.ORDER.getKey().equals(dimension)) continue;
            itemForActivityInfo.setOrderActivityInfo(activityInfoRespDtos);
        }
        itemForActivityInfo.setSystemTime(System.currentTimeMillis());
        return itemForActivityInfo;
    }

    private List<ItemActivityInfoRespDto> getCouponActivityInfoRespDtos(List<ItemActivityInfoRespDto> activityInfoRespDtos) {
        List<Long> activityIds = activityInfoRespDtos.stream().map(BaseActivityDto::getId).collect(Collectors.toList());
        List<CouponTemplate> templates = this.couponTemplate.queryByActivityIds(activityIds);
        Map<Long, CouponTemplate> templateMap = templates.stream().collect(Collectors.toMap(CouponTemplate::getActivityId, e -> e, (e1, e2) -> e1));
        ArrayList activityList = Lists.newArrayList();
        activityInfoRespDtos.forEach(activityInfoDto -> {
            if (templateMap.containsKey(activityInfoDto.getId())) {
                CouponTemplate couponTemplate = (CouponTemplate)templateMap.get(activityInfoDto.getId());
                couponTemplate.setTag(activityInfoDto.getTag());
                activityInfoDto.setCouponTemplate(couponTemplate);
                activityList.add(activityInfoDto);
            }
        });
        return activityList;
    }

    private ItemActivityInfoRespDto convertToItemActivityInfoRespDto(ItemActivityTagDto itemActivityTagDto) {
        ItemActivityInfoRespDto activityInfo = new ItemActivityInfoRespDto();
        try {
            ActivityRespDto activityRespDto = (ActivityRespDto)this.activityQueryApi.queryActivityDetail(itemActivityTagDto.getActivityId().longValue()).getData();
            CubeBeanUtils.copyProperties((Object)activityInfo, (Object)activityRespDto, (String[])new String[0]);
            if (null == activityRespDto.getPreheatStartTime()) {
                activityInfo.setPreheatStartTime(activityRespDto.getBeginTime());
            }
            activityInfo.setDimension(activityRespDto.getActivityTemplate().getDimension());
            activityInfo.setActivityType(ActivityType.getByType((Long)activityRespDto.getActivityTemplateId()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return activityInfo;
    }

    @Override
    public void audit(Long id, ActivityAuditReqDto activityAuditReqDto) {
        activityAuditReqDto.setAuditPerson(this.context.userId());
        activityAuditReqDto.setTenantId(this.context.tenantId());
        activityAuditReqDto.setInstanceId(this.context.instanceId());
        activityAuditReqDto.setParentAuditPerson(activityAuditReqDto.getAuditPerson());
        this.activityApi.auditById(id.longValue(), activityAuditReqDto);
        if (AuditStatusEnum.AUDIT_PASS.getKey().equals(activityAuditReqDto.getAuditStatus())) {
            this.activityApi.enableById(id.longValue());
        }
    }

    @Override
    public ActivityListRespDto queryActivity(PageEditActivityReqDto pageEditActivityReqDto) {
        ActivityListRespDto activityListRespDto = new ActivityListRespDto();
        ActivityQueryReqDto activityQueryReqDto = new ActivityQueryReqDto();
        activityQueryReqDto.setActivityType(pageEditActivityReqDto.getActivityType());
        Date today = DateUtil.getToday();
        Date tomorrow = DateUtil.addDays((Date)today, (int)1);
        Date tomorrowEnd = DateUtil.getDayEnd((Date)tomorrow);
        Date lastSevenDay = DateUtil.addDays((Date)today, (int)7);
        Date lastSevenDayEnd = DateUtil.getDayEnd((Date)lastSevenDay);
        if ("TODAY_ACTIVITY".equals(pageEditActivityReqDto.getPageEditActivityType())) {
            activityQueryReqDto.setActivityStatus(ActivityStatusEnum.ACTIVATE.getKey());
        } else if ("TOMORROW_ACTIVITY".equals(pageEditActivityReqDto.getPageEditActivityType())) {
            activityQueryReqDto.setActivityStatus(ActivityStatusEnum.READY.getKey());
            activityQueryReqDto.setActivityTimeStart(tomorrow);
            activityQueryReqDto.setActivityTimeEnd(tomorrowEnd);
        } else if ("LAST_SEVEN_DAY_ACTIVITY".equals(pageEditActivityReqDto.getPageEditActivityType())) {
            activityQueryReqDto.setActivityStatus(ActivityStatusEnum.READY.getKey());
            activityQueryReqDto.setActivityTimeStart(tomorrow);
            activityQueryReqDto.setActivityTimeEnd(lastSevenDayEnd);
        }
        PageInfo<ActivityListRespDto> pageInfo = this.queryByPage(activityQueryReqDto, 1, 100);
        if (PageInfoUtil.isNotEmpty(pageInfo)) {
            List activityListRespDtos = pageInfo.getList();
            List activitySortList = activityListRespDtos.stream().sorted(Comparator.comparing(ActivityRespDto::getBeginTime)).collect(Collectors.toList());
            activityListRespDto = (ActivityListRespDto)activitySortList.get(0);
        }
        return activityListRespDto;
    }

    @Override
    public List<ItemShelfQueryRespDto> queryAllItem() {
        PageInfo pageInfo;
        ArrayList itemShelfQueryRespDtos = Lists.newArrayList();
        ItemShelfQueryReqDto queryReqDto = new ItemShelfQueryReqDto();
        queryReqDto.setInstanceId(this.context.instanceId());
        queryReqDto.setTenantId(this.context.tenantId());
        queryReqDto.setItemStatus(ItemStatus.ITEM_ONSHELF.getStatus());
        int pageNum = 1;
        int pageSize = 1000;
        do {
            RestResponse response;
            if (PageInfoUtil.isNotEmpty(pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)(response = this.itemQueryApi.queryShelfItemByPage(queryReqDto, Integer.valueOf(pageNum), Integer.valueOf(pageSize)))))) {
                itemShelfQueryRespDtos.addAll(pageInfo.getList());
            }
            ++pageNum;
        } while (PageInfoUtil.isNotEmpty(pageInfo));
        return itemShelfQueryRespDtos;
    }
}

